library IEEE;
    use IEEE.STD_LOGIC_1164.ALL;
    use work.TIMER_PKG.ALL;
 
entity TB_DEBOUNCER is
end TB_DEBOUNCER;
 
architecture TB of TB_DEBOUNCER is 
  --Inputs
   signal sysclk_in       : std_logic := '0';
   signal sampling_clk_in : std_logic := '0';
   signal reset_in        : std_logic := '0';
   
    signal button_in : std_logic := '0';

  --Outputs
   signal button_out   : std_logic;
   signal released_out : std_logic;
   signal pressed_out  : std_logic;
 
   constant sysclk_period : time := 100 ms / 500000e3;
   constant sampling_clk_period : time := 100 ms / 50000e3;
begin
   -- Stimulus process
   stim_proc: process
   begin        
        reset_in <= '1';
        --wait for sysclk_period * 5; 
        reset_in <= '0';
        --wait for sysclk_period * 2;

-- TODO: Passen Sie die folgenden Stimuli an, um einen Tastendruck mit Prellen zu simulieren.
-- Dabei sollen sowohl beim Drcken, als auch beim Loslassen Strungen im Sub-Millisekunden-
-- Bereich auftreten.
		  button_in <= '0'; wait for 400 ns;
        button_in <= '1'; wait for 30 ps;
        button_in <= '0'; wait for 1 ps;
		  button_in <= '1'; wait for 4 ps;
		  button_in <= '0'; wait for 30 ps;
		  button_in <= '1'; wait for 4 ps;
		  button_in <= '0'; wait for 30 ps;
		  button_in <= '1'; wait for 20 ps;
		  button_in <= '0'; wait for 10 ps;
		  button_in <= '1';
		  wait for 200 ns;
		  button_in <= '0'; wait for 30 ps;
        button_in <= '1'; wait for 1 ps;
		  button_in <= '0'; wait for 4 ps;
		  button_in <= '1'; wait for 30 ps;
		  button_in <= '0'; wait for 20 ps;
		  button_in <= '1'; wait for 4 ps;
		  button_in <= '0'; wait for 30 ps;
		  button_in <= '1'; wait for 10 ps;
		  button_in <= '0';
		  
   end process;

    -- Instantiate the Unit Under Test (UUT)
   uut: DEBOUNCER port map (
          sysclk_in => sysclk_in,
          sampling_clk_in => sampling_clk_in,
          reset_in => reset_in,
          button_in => button_in,
          button_out => button_out,
          released_out => released_out,
          pressed_out => pressed_out
        );

    -- Clocks
    sysclk_proc: process is begin
        sysclk_in <= '0'; wait for sysclk_period / 2;
        sysclk_in <= '1'; wait for sysclk_period / 2;
    end process;
    
    sampling_clk_proc: process is begin
        sampling_clk_in <= '0'; wait for sampling_clk_period / 2;
        sampling_clk_in <= '1'; wait for sampling_clk_period / 2;
    end process;
end;
