library IEEE;
    use IEEE.STD_LOGIC_1164.ALL;
    use IEEE.NUMERIC_STD.ALL;

	use work.TIMER_PKG.ALL;     -- enthält etwa die COMPONENTEN Definition für CONTROLLER

entity TB_CONTROLLER is
end TB_CONTROLLER;

architecture TB of TB_CONTROLLER is
	signal sysclk_in, clk10hz_in, reset_in : std_logic := '0';
	signal keyUp_in, keyDown_in, keyLeft_in, keyRight_in, keySet_in : std_logic := '0';
	
	signal disp_dots_i, disp_brightness_i : std_logic_vector(3 downto 0);
	
	signal alarm_i : std_logic;

	signal alu_instruction_i : ALU_INSTRUCTION_TYPE;
    signal timer_is_zero_i : std_logic := '0';
begin
-- Takt und Reset
    sysclk_in  <= not sysclk_in  after  5 ns;
    clk10hz_in <= not clk10hz_in after 50 ns;
    reset_in   <= '1', '0' after 20 ns;

-- Tastendrücke
    process is begin
        wait until reset_in = '0';
   
-- TODO: Implementieren Sie Tastendrücke, die das Einstellen einer neuen Zeit simulieren.
-- Bedenken Sie hierbei, dass der Controller pro Tastendruck einen Peak von 10 ns Länge 
-- erwartet. Dieser kann etwa mittels 
--    keySet_in <= '1', '0' after 10 ns; wait for 50 ns;
-- erzeugt werden.
			timer_is_zero_i <= '1' after 470 ns, '0' after 500ns;
			wait for 5 ns;
        keyset_in <= '1', '0' after 10 ns; wait for 50 ns;
		  keydown_in <= '1', '0' after 10 ns; wait for 50 ns;
		  keyright_in <= '1', '0' after 10 ns; wait for 50 ns;
		  keyright_in <= '1', '0' after 10 ns; wait for 50 ns;
		  keyup_in <= '1', '0' after 10 ns; wait for 50 ns;
		  keyup_in <= '1', '0' after 10 ns; wait for 50 ns;
		  keyright_in <= '1', '0' after 10 ns; wait for 270 ns;
		  keyright_in <= '1', '0' after 10 ns;
        wait; -- Auf nimmer Wiedersehen
    end process;
    
-- Instantiierung des Controllers
	my_controller: CONTROLLER port map (
		sysclk_in  => sysclk_in,
		clk10hz_in => clk10hz_in,
		reset_in   => reset_in,
        
        alu_instruction_out => alu_instruction_i,
        timer_is_zero_in    => timer_is_zero_i,
		
		keyUp_in    => keyUp_in,
		keyDown_in  => keyDown_in,
		keyLeft_in  => keyLeft_in,
		keyRight_in => keyRight_in,
		keySet_in   => keySet_in,
		
		disp_highlight_out => disp_brightness_i,
		disp_dots_out => disp_dots_i,
		
		alarm_out => alarm_i
	);
end TB;

