library IEEE;
    use IEEE.STD_LOGIC_1164.ALL;
    use IEEE.NUMERIC_STD.ALL;
    use work.TIMER_PKG.ALL;

entity CONTROLLER is
    port (
        -- Clocks and Reset
        sysclk_in   : in std_logic;
        clk10hz_in  : in std_logic;
        reset_in    : in std_logic;

        -- Alu
        alu_instruction_out : out ALU_INSTRUCTION_TYPE;
        timer_is_zero_in : in std_logic;
        
        -- Key Controls
        keyUp_in    : in std_logic;
        keyDown_in  : in std_logic;
        keyLeft_in  : in std_logic;
        keyRight_in : in std_logic;
        keySet_in   : in std_logic;

        -- 7 Segment Display
        disp_highlight_out : out std_logic_vector(3 downto 0);
        disp_dots_out      : out std_logic_vector(3 downto 0);

        -- Alarm
        alarm_out   : out std_logic
    );
end CONTROLLER;

architecture Behavioral of CONTROLLER is
-- TODO: Hier die Zustandsmenge mit zugehörigen Signalen einfügen

type timer_states is (idle, reset, start, set_min, set_sec1, set_sec0, running,
	aborted, dec, alarm, load_default_start, load_default_set, inc_min, dec_min,
	inc_sec1, dec_sec1, inc_sec0, dec_sec0);
signal timer_state : timer_states := reset;
signal timer_next_state : timer_states;

begin
-- TODO: Hier den synchronen "Register" Prozess erstellen

proc_sync: process is begin
		wait until rising_edge(sysclk_in);
		timer_state <= timer_next_state;
end process;

-- TODO: Hier das asynchrone Schaltnetz der Transition und Output-Funktion erstellen.
-- Achten Sie darauf, dass zu jedem Zeitpunkt die Ausgänge
-- alu_instruction_out, disp_highlight_out, disp_dots_out, alarm_out
-- einen definierten Wert haben. Weiter darf die Ausgabe-Funktion nur vom
-- aktuellen Zustand abhängen (Moore-Automat).


proc_comb: process (timer_state, timer_is_zero_in, keyup_in, keydown_in, keyleft_in, keyright_in, keyset_in, sysclk_in, clk10hz_in)
is begin

		timer_next_state <= timer_state; 	-- implizierte eigenkante

		case timer_state is
			when reset => timer_next_state <= idle;
			when idle => if (keyset_in ='1') then timer_next_state <= set_min;
				elsif (keyup_in = '1' or keydown_in = '1' or keyleft_in = '1' or keyright_in = '1') then
					timer_next_state <= start;
					end if;
			when set_min => if (keyup_in = '1') then timer_next_state <= inc_min;
				elsif (keydown_in = '1') then timer_next_state <= dec_min;
				elsif (keyright_in = '1') then timer_next_state <= set_sec1;
				elsif (keyset_in = '1') then timer_next_state <= idle;
				end if;
			when dec_min => timer_next_state <= set_min;
			when inc_min => timer_next_state <= set_min;
			when set_sec1 => if (keyup_in = '1') then timer_next_state <= inc_sec1;
				elsif (keydown_in = '1') then timer_next_state <= dec_sec1;
				elsif (keyleft_in = '1') then timer_next_state <= set_min;
				elsif (keyright_in = '1') then timer_next_state <= set_sec0;
				elsif (keyset_in = '1') then timer_next_state <= idle;
				end if;
			when inc_sec1 => timer_next_state <= set_sec1;
			when dec_sec1 => timer_next_state <= set_sec1;
			when set_sec0 => if (keyleft_in = '1') then timer_next_state <= set_sec1;
				elsif (keyup_in = '1') then timer_next_state <= inc_sec0;
				elsif (keydown_in = '1') then timer_next_state <= dec_sec0;
				elsif (keyright_in = '1') then timer_next_state <= start;
				elsif (keyset_in = '1') then timer_next_state <= idle;
				end if;
			when inc_sec0 => timer_next_state <= set_sec0;
			when dec_sec0 => timer_next_state <= set_sec0;
			when start => timer_next_state <= running;
			when running => if (clk10hz_in = '1') then timer_next_state <= dec;
				elsif (keyright_in = '1' or keydown_in = '1' or keyleft_in = '1' or keyup_in = '1') then timer_next_state <= aborted;
				elsif (timer_is_zero_in = '1') then timer_next_state <= alarm;
				end if;
			when dec => timer_next_state <= running;
			when alarm => if (keyset_in = '1') then timer_next_state <= load_default_set;
				elsif (keyleft_in = '1' or keydown_in = '1' or keyright_in = '1' or keyup_in = '1') then timer_next_state <= load_default_start;
				end if;
			when load_default_set => timer_next_state <= set_min;
			when load_default_start => timer_next_state <= start;
			when aborted => timer_next_state <= idle;
			--when others => null;
		end case;
		
		if reset_in = '1' then timer_next_state <= idle;
		end if;
		
		-- Output Function

		alarm_out <= '0';
		disp_highlight_out <= "1111";
		disp_dots_out <= "1010";	
		alu_instruction_out <= ALU_NONE;
		
		case timer_state is
			--when reset => alu_instruction_out <= alu_single_inc_min;
			when idle => alu_instruction_out <= alu_none;
			when set_min => disp_highlight_out <= "1000";
			when dec_min => alu_instruction_out <= alu_single_dec_min;
				disp_highlight_out <= "1000";
			when inc_min => alu_instruction_out <= alu_single_inc_min;
				disp_highlight_out <= "1000";
			when set_sec1 => disp_highlight_out <= "0100";
			when dec_sec1 => alu_instruction_out <= alu_single_dec_sec10;
				disp_highlight_out <= "0100";
			when inc_sec1 => alu_instruction_out <= alu_single_inc_sec10;
				disp_highlight_out <= "0100";
			when set_sec0 => disp_highlight_out <= "0010";
			when dec_sec0 => alu_instruction_out <= alu_single_dec_sec;
				disp_highlight_out <= "0010";
			when inc_sec0 => alu_instruction_out <= alu_single_inc_sec;
				disp_highlight_out <= "0010";
			when start => alu_instruction_out <= alu_store;
			when running => alu_instruction_out <= alu_none;
			when dec => alu_instruction_out <= alu_dec_timer;
			when aborted => alu_instruction_out <= alu_load;
			when alarm => alarm_out <= '1';
			when load_default_set => alu_instruction_out <= alu_load;
			when load_default_start => alu_instruction_out <= alu_load;
			when others	=>	null;
		end case;
		
		
		
end process;
end Behavioral;