library IEEE;
    use IEEE.STD_LOGIC_1164.ALL;
    use IEEE.NUMERIC_STD.ALL;
    use IEEE.MATH_REAL.ALL;
    
entity CLOCK_DIVIDER is
   generic (
      SOURCE_FREQUENCY : positive := 50e6; -- Hz
      TARGET_FREQUENCY : positive :=  1e3  -- Hz
   );
   
   port (
      clk_in    : in std_logic;
      reset_in  : in std_logic;
      clk_out   : out std_logic
   );
end entity;

architecture RTL of CLOCK_DIVIDER is
   constant COUNTER_UPPER : positive := SOURCE_FREQUENCY / TARGET_FREQUENCY;
   constant FREQ_ERROR    : real := REAL(SOURCE_FREQUENCY / COUNTER_UPPER) / REAL(TARGET_FREQUENCY);
   
   signal   counter : integer range 0 to COUNTER_UPPER := 0;
   
begin
   assert (SOURCE_FREQUENCY >= 2*TARGET_FREQUENCY)
      report "CLOCK_DIVIDER requires a source frequency above the 2x target frequency"
      severity failure;
      
   assert (0.9 < FREQ_ERROR and FREQ_ERROR < 1.1)
      report "CLOCK_DIVIDER produces a relative error > 10%"
      severity failure;

   proc_counter: process is
   begin
      wait until rising_edge(clk_in);

     clk_out <= '0';
      
    --  if reset_in = '1' then
    --     counter <= 0;
         
      if counter = COUNTER_UPPER - 1 then
         clk_out <= '1';
         counter <= 0;
         
      else
         counter <= counter + 1;
         
      end if;
   end process;
end RTL;