library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity v2_3 is
   port ( clk : in    std_logic; 
          in0 : in    std_logic; 
          in1 : in    std_logic; 
          in2 : in    std_logic; 
          in3 : in    std_logic;
			 reset : in std_logic;
          a : out std_logic_vector (3 downto 0);
			 c_out : out std_logic;
			 clr : out std_logic);
end v2_3;

architecture BEHAVIORAL of v2_3 is
   signal XLXN_3   : std_logic;
   signal XLXN_4   : std_logic;
   signal XLXN_7   : std_logic;
   signal XLXN_8   : std_logic;
   signal XLXN_10  : std_logic;
   signal XLXN_12  : std_logic;
   signal XLXN_14  : std_logic;
   signal a0_DUMMY : std_logic;
   signal a1_DUMMY : std_logic;
   signal a2_DUMMY : std_logic;
   signal a3_DUMMY : std_logic;
   component halbaddierer
      port ( a    : in    std_logic; 
             b    : in    std_logic; 
             s    : out   std_logic; 
             cout : out   std_logic);
   end component;
   
   component Volladdierer
      port ( a     : in    std_logic; 
             b     : in    std_logic; 
             c_in  : in    std_logic; 
             d     : out   std_logic; 
             c_out : out   std_logic);
   end component;
   
   component dff
      port ( C : in    std_logic; 
             D : in    std_logic; 
             Q : out   std_logic);
   end component;
   
begin

   XLXI_1 : halbaddierer
      port map (a=>in0,
                b=>a0_DUMMY,
                cout=>XLXN_4,
                s=>XLXN_3);
   
   XLXI_2 : Volladdierer
      port map (a=>in1,
                b=>a1_DUMMY,
                c_in=>XLXN_4,
                c_out=>XLXN_10,
                d=>XLXN_7);
   
   XLXI_3 : Volladdierer
      port map (a=>in2,
                b=>XLXN_10,
                c_in=>a2_DUMMY,
                c_out=>XLXN_12,
                d=>XLXN_8);
   
   XLXI_4 : Volladdierer
      port map (a=>in3,
                b=>XLXN_12,
                c_in=>a3_DUMMY,
                c_out=>c_out,
                d=>XLXN_14);
   
   XLXI_5 : dff
      port map (C=>clk,
                D=>XLXN_3 and not reset,
                Q=>a0_DUMMY);
   
   XLXI_6 : dff
      port map (C=>clk,
                D=>XLXN_7 and not reset,
                Q=>a1_DUMMY);
   
   XLXI_7 : dff
      port map (C=>clk,
                D=>XLXN_8 and not reset,
                Q=>a2_DUMMY);
   
   XLXI_8 : dff
      port map (C=>clk,
                D=>XLXN_14 and not reset,
                Q=>a3_DUMMY);
   a(0) <= a0_DUMMY;
   a(1) <= a1_DUMMY;
   a(2) <= a2_DUMMY;
   a(3) <= a3_DUMMY;
	clr <= not a0_dummy and not a1_dummy and not a2_dummy and not a3_dummy;
	
end BEHAVIORAL;
