library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity clockSim is
end clockSim;

architecture Behavioral of clockSim is

component clock port  ( clk     : in    std_logic; 
          reset   : in    std_logic; 
          clr     : out   std_logic; 
          hundert : out   std_logic_vector (3 downto 0); 
          min0    : out   std_logic_vector (3 downto 0); 
          min1    : out   std_logic_vector (2 downto 0); 
          sec0    : out   std_logic_vector (3 downto 0); 
          sec1    : out   std_logic_vector (2 downto 0); 
          zehn    : out   std_logic_vector (3 downto 0));
end component;

signal clk : std_logic := '1';
signal reset, clr : std_logic;
signal hundert, zehn, min0, sec0  : std_logic_vector (3 downto 0);
signal min1, sec1  : std_logic_vector (2 downto 0);

begin

myclock : clock port map(
	clk => clk,
	reset => reset,
	clr => clr,
	hundert => hundert,
	zehn => zehn,
	min0 => min0,
	min1 => min1,
	sec0 => sec0,
	sec1 => sec1
);

clk <= not clk after 1 ps;
reset <= '0' after 0 ps,
	'1' after 500 ns,
	'0' after 850 ns;

end Behavioral;