library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity clock is
   port ( clk     : in    std_logic; 
          reset   : in    std_logic; 
          clr     : out   std_logic; 
          hundert : out   std_logic_vector (3 downto 0); 
          min0    : out   std_logic_vector (3 downto 0); 
          min1    : out   std_logic_vector (2 downto 0); 
          sec0    : out   std_logic_vector (3 downto 0); 
          sec1    : out   std_logic_vector (2 downto 0); 
          zehn    : out   std_logic_vector (3 downto 0));
end clock;

architecture BEHAVIORAL of clock is
   signal XLXN_13       : std_logic;
   signal XLXN_14       : std_logic;
   signal XLXN_15       : std_logic;
   signal XLXN_16       : std_logic;
   signal XLXN_17       : std_logic;
   signal XLXN_18       : std_logic;
   signal XLXN_19       : std_logic;
   signal XLXN_20       : std_logic;
   signal XLXN_21       : std_logic;
   signal XLXN_23       : std_logic;
   signal XLXN_69       : std_logic;
   signal XLXN_72       : std_logic;
   signal XLXN_78       : std_logic;
   signal XLXN_79       : std_logic;
   signal XLXN_80       : std_logic;
   signal sec0_DUMMY    : std_logic_vector (3 downto 0);
   signal sec1_DUMMY    : std_logic_vector (2 downto 0);
   signal hundert_DUMMY : std_logic_vector (3 downto 0);
   signal min0_DUMMY    : std_logic_vector (3 downto 0);
   signal zehn_DUMMY    : std_logic_vector (3 downto 0);
   component asynchronMod10
      port ( clk   : in    std_logic; 
             reset : in    std_logic; 
             clr   : out   std_logic; 
             a     : out   std_logic_vector (3 downto 0));
   end component;
   
   component asynchronMod6
      port ( clk   : in    std_logic; 
             reset : in    std_logic; 
             clr   : out   std_logic; 
             a     : out   std_logic_vector (2 downto 0));
   end component;
   
   component and_gate
      port ( a : in    std_logic; 
             b : in    std_logic; 
             c : out   std_logic);
   end component;
   
begin
   hundert(3 downto 0) <= hundert_DUMMY(3 downto 0);
   min0(3 downto 0) <= min0_DUMMY(3 downto 0);
   sec0(3 downto 0) <= sec0_DUMMY(3 downto 0);
   sec1(2 downto 0) <= sec1_DUMMY(2 downto 0);
   zehn(3 downto 0) <= zehn_DUMMY(3 downto 0);
   XLXI_1 : asynchronMod10
      port map (clk=>clk,
                reset=>reset,
                a(3 downto 0)=>hundert_DUMMY(3 downto 0),
                clr=>XLXN_13);
   
   XLXI_2 : asynchronMod10
      port map (clk=>XLXN_69,
                reset=>reset,
                a(3 downto 0)=>zehn_DUMMY(3 downto 0),
                clr=>XLXN_14);
   
   XLXI_3 : asynchronMod10
      port map (clk=>XLXN_72,
                reset=>reset,
                a(3 downto 0)=>sec0_DUMMY(3 downto 0),
                clr=>XLXN_15);
   
   XLXI_4 : asynchronMod10
      port map (clk=>XLXN_79,
                reset=>reset,
                a(3 downto 0)=>min0_DUMMY(3 downto 0),
                clr=>XLXN_17);
   
   XLXI_5 : asynchronMod6
      port map (clk=>XLXN_78,
                reset=>reset,
                a(2 downto 0)=>sec1_DUMMY(2 downto 0),
                clr=>XLXN_16);
   
   XLXI_6 : asynchronMod6
      port map (clk=>XLXN_80,
                reset=>reset,
                a(2 downto 0)=>min1(2 downto 0),
                clr=>XLXN_18);
   
   XLXI_7 : and_gate
      port map (a=>XLXN_13,
                b=>XLXN_14,
                c=>XLXN_19);
   
   XLXI_8 : and_gate
      port map (a=>XLXN_15,
                b=>XLXN_16,
                c=>XLXN_20);
   
   XLXI_9 : and_gate
      port map (a=>XLXN_17,
                b=>XLXN_18,
                c=>XLXN_21);
   
   XLXI_10 : and_gate
      port map (a=>XLXN_19,
                b=>XLXN_20,
                c=>XLXN_23);
   
   XLXI_11 : and_gate
      port map (a=>XLXN_23,
                b=>XLXN_21,
                c=>clr);
   
   XLXI_23 : and_gate
      port map (a=>hundert_DUMMY(3),
                b=>hundert_DUMMY(0),
                c=>XLXN_69);
   
   XLXI_24 : and_gate
      port map (a=>zehn_DUMMY(3),
                b=>zehn_DUMMY(0),
                c=>XLXN_72);
   
   XLXI_25 : and_gate
      port map (a=>sec0_DUMMY(0),
                b=>sec0_DUMMY(3),
                c=>XLXN_78);
   
   XLXI_26 : and_gate
      port map (a=>sec1_DUMMY(2),
                b=>sec1_DUMMY(0),
                c=>XLXN_79);
   
   XLXI_27 : and_gate
      port map (a=>min0_DUMMY(3),
                b=>min0_DUMMY(0),
                c=>XLXN_80);
   
end BEHAVIORAL;


