library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity asynchronMod6 is
   port ( clk : in    std_logic;
			 reset : in std_logic;
          a  : out   std_logic_vector (2 downto 0);
			 clr : out std_logic
			);
end asynchronMod6;

architecture BEHAVIORAL of asynchronMod6 is
   signal XLXN_1   : std_logic;
   signal XLXN_4   : std_logic;
   signal XLXN_12  : std_logic;   
	signal a0_DUMMY : std_logic;
   signal a1_DUMMY : std_logic;
   signal a2_DUMMY : std_logic;
	signal clr_dummy : std_logic;
   component dff2
      port ( D  : in    std_logic; 
             C  : in    std_logic; 
             Q  : out   std_logic; 
             Q1 : out   std_logic
				 );
   end component;
   
begin
   a(0) <= a0_DUMMY;
   a(1) <= a1_DUMMY;
	a(2) <= a2_DUMMY;
	clr_dummy <= (a0_dummy nand a0_dummy) and (a1_dummy nand a1_dummy) and (a2_dummy nand a2_dummy);
	clr <= clr_dummy;
   XLXI_1 : dff2
      port map (C=>clk,
                D=>XLXN_1 and (reset nand clr_dummy),
                Q=>a0_DUMMY,
                Q1=>XLXN_1);
   
   XLXI_2 : dff2
      port map (C=>a0_dummy,
                D=>(((a0_dummy nand XLXN_4)nand (a0_dummy nand XLXN_4)) nand XLXN_12) nand (XLXN_1 nand a1_dummy),
                Q=>a1_DUMMY,
                Q1=>XLXN_4);
   
   XLXI_3 : dff2
      port map (C=>a0_dummy,
                D=>(a0_dummy nand a1_dummy) nand (XLXN_1 nand a2_dummy),
                Q=>a2_dummy,
                Q1=>XLXN_12);
   
end BEHAVIORAL;
