
library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity asynchronMod10 is
   port ( clk, reset : in    std_logic; 
          a : out std_logic_vector (3 downto 0);
			 clr : out std_logic);
end asynchronMod10;

architecture BEHAVIORAL of asynchronMod10 is
   signal XLXN_2   : std_logic;
   signal XLXN_4   : std_logic;
   signal XLXN_6   : std_logic;
   signal XLXN_10  : std_logic;
   signal a0_DUMMY : std_logic;
   signal a1_DUMMY : std_logic;
   signal a2_DUMMY : std_logic;
	signal a3_DUMMY : std_logic;
	signal clr_dummy : std_logic;
   component dff2
      port ( D  : in    std_logic; 
             C  : in    std_logic; 
             Q  : out   std_logic; 
             Q1 : out   std_logic);
   end component;
   
begin
   a(0) <= a0_DUMMY;
   a(1) <= a1_DUMMY;
   a(2) <= a2_DUMMY;
	a(3) <= a3_dummy;
	clr_dummy <= (a0_dummy nand a0_dummy) and (a1_dummy nand a1_dummy) and (a2_dummy nand a2_dummy) and (a3_dummy nand a3_dummy);
	clr <= clr_dummy;
   XLXI_1 : dff2
      port map (C=>clk,
                D=>XLXN_2 and (reset nand clr_dummy),
                Q=>a0_DUMMY,
                Q1=>XLXN_2);
   
   XLXI_2 : dff2
      port map (C=>a0_DUMMY,
                D=>XLXN_4 and XLXN_10,
                Q=>a1_DUMMY,
                Q1=>XLXN_4);
   
   XLXI_3 : dff2
      port map (C=>a1_DUMMY,
                D=>XLXN_6,
                Q=>a2_DUMMY,
                Q1=>XLXN_6);
   
   XLXI_4 : dff2
      port map (C=>a0_DUMMY,
                D=>a1_DUMMY and a2_DUMMY,
                Q=>a3_dummy,
                Q1=>XLXN_10);
   
end BEHAVIORAL;


