LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY SEG_CTRL IS
PORT(
	CLK 		: IN STD_LOGIC;
	CTRL		: IN STD_LOGIC;
	MIN_U    : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
	MIN_L    : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
	SEC_L    : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
	SEC_U    : IN STD_LOGIC_VECTOR(2 DOWNTO 0);
	DSEC_L   : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
	DSEC_U   : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
	SEGMENT  : OUT STD_LOGIC_VECTOR(11 DOWNTO 0)
);
END SEG_CTRL;



ARCHITECTURE Behavioral OF SEG_CTRL IS

SIGNAL AN_CTRL : STD_LOGIC_VECTOR(4 DOWNTO 0) := "00001";

	FUNCTION DEC_TO_7SEG(DECIM : STD_LOGIC_VECTOR(3 DOWNTO 0)) RETURN STD_LOGIC_VECTOR IS
	VARIABLE SEG : STD_LOGIC_VECTOR(6 DOWNTO 0);
	BEGIN	
		CASE DECIM IS	
			WHEN "0000" => SEG := "1000000";
			WHEN "0001" => SEG := "1111001";		
			WHEN "0010" => SEG := "0100100";
			WHEN "0011" => SEG := "0110000";
			WHEN "0100" => SEG := "0011001";
			WHEN "0101" => SEG := "0010010";
			WHEN "0110" => SEG := "0000010";
			WHEN "0111" => SEG := "1111000";
			WHEN "1000" => SEG := "0000000";
			WHEN "1001" => SEG := "0010000";	
			WHEN OTHERS => SEG := "XXXXXXX";				
		END CASE;			
		RETURN SEG;
	END DEC_TO_7SEG;

BEGIN
	
	PROCESS(CLK)
	BEGIN		
		IF rising_edge(CLK) THEN
			CASE AN_CTRL IS		
				WHEN "00001" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG(DSEC_L);
				WHEN "00010" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG(DSEC_U);
				WHEN "00100" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG(SEC_L);
				WHEN "01000" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG('0'&SEC_U);				
				WHEN "10001" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG(SEC_L);
				WHEN "10010" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG('0'&SEC_U);
				WHEN "10100" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG(MIN_L);
				WHEN "11000" => SEGMENT(6 DOWNTO 0) <= DEC_TO_7SEG('0'&MIN_U);
				WHEN OTHERS   => SEGMENT(6 DOWNTO 0) <= "XXXXXXX"; 				
			END CASE;
			
			AN_CTRL <= CTRL & AN_CTRL(2 DOWNTO 0) & AN_CTRL(3);
			SEGMENT(11 DOWNTO 7) <= (NOT AN_CTRL(3 DOWNTO 0)) & (NOT AN_CTRL(2));
			
		END IF;
	END PROCESS;

END Behavioral;






