LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;


ENTITY CLK_CTRL IS
PORT(
		CLK 		  : IN STD_LOGIC;
		RESET		  : IN STD_LOGIC;
		HOLD		  : IN STD_LOGIC;
		CLK_100Hz  : OUT STD_LOGIC;
		CLK_1kHz   : OUT STD_LOGIC
);
END CLK_CTRL;

ARCHITECTURE Behavioral OF CLK_CTRL IS

SIGNAL DIV_100Hz  : STD_LOGIC_VECTOR(18 DOWNTO 0) := (OTHERS => '0');
SIGNAL INV_100Hz  : STD_LOGIC := '0';
SIGNAL DIV_1kHz   : STD_LOGIC_VECTOR(12 DOWNTO 0) := (OTHERS => '0');
SIGNAL INV_1kHz   : STD_LOGIC := '0';
SIGNAL DIV_1MHz	: STD_LOGIC_VECTOR(5 DOWNTO 0);
SIGNAL INV_1MHz   : STD_LOGIC := '0';

BEGIN

	clk_ctrl : PROCESS(CLK,RESET)
	BEGIN

		IF rising_edge(CLK) THEN
			DIV_1kHZ <= DIV_1kHZ + '1';
			IF DIV_1kHZ = "1001110001000" THEN 
				INV_1kHz <= NOT INV_1kHz;
				DIV_1kHz <= (OTHERS => '0');
			END IF;
			
			DIV_1MHz <= DIV_1MHz + '1';
			IF DIV_1MHz = "110010" THEN
				INV_1MHz <= NOT INV_1MHz;
				DIV_1MHz <= (OTHERS =>'0');
			END IF;
			
			IF HOLD = '0' THEN
				IF DIV_100HZ = "01111010000100100000" THEN 
					INV_100Hz <= NOT INV_100Hz;
					DIV_100Hz <= (OTHERS => '0');
				ELSE
					DIV_100Hz <= DIV_100Hz + '1';
				END IF;
			END IF;
		END IF;
		
	END PROCESS;
			
	CLK_100Hz <= INV_100Hz WHEN RESET = '0' ELSE INV_1MHz;
	CLK_1kHz  <= INV_1kHz;
	
END Behavioral;

