library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity impgate is
    Port ( a : in  STD_LOGIC;
           b : in  STD_LOGIC;
           c : out  STD_LOGIC);
end impgate;

architecture Behavioral of impgate is

begin
	P1 : process(a,b)
	begin
		if (a = '0') then c <= '1';
			else c <= b;
		end if;
	end process P1;

end Behavioral;

architecture dataflow of impgate is

begin
	c <= not a or b;
end dataflow;

architecture struct of impgate is

component inve port (a : in std_logic;
	b : out std_logic);
end component;
component orgate port (a, b : in std_logic;
	c : out std_logic);
end component;
signal a0 : std_logic;
begin

myinv : inve port map (
	a => a,
	b => a0
);

myor : orgate port map (
	a => a0,
	b => b,
	c => c
);

end struct;
