
library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity andgates5 is
   port ( in0  : in    std_logic; 
          in1  : in    std_logic; 
          in2  : in    std_logic; 
          in3  : in    std_logic; 
          in4  : in    std_logic; 
          out0 : out   std_logic);
end andgates5;

architecture BEHAVIORAL of andgates5 is
   signal XLXN_11 : std_logic;
   signal XLXN_12 : std_logic;
   signal XLXN_13 : std_logic;
   component and_gate
      port ( a : in    std_logic; 
             b : in    std_logic; 
             c : out   std_logic);
   end component;
   
begin
   XLXI_1 : and_gate
      port map (a=>in0,
                b=>in1,
                c=>XLXN_11);
   
   XLXI_2 : and_gate
      port map (a=>XLXN_11,
                b=>in2,
                c=>XLXN_12);
   
   XLXI_3 : and_gate
      port map (a=>XLXN_12,
                b=>in3,
                c=>XLXN_13);
   
   XLXI_4 : and_gate
      port map (a=>XLXN_13,
                b=>in4,
                c=>out0);
   
end BEHAVIORAL;


