library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity video_controller is port (
	sysclk : in std_logic;
	light : out std_logic_vector (7 downto 0) := "00000000";
	DE : out std_logic := '0';
	TFT_EN : out std_logic := '0';
	DISP : out std_logic := '0';
	EN : out std_logic := '0';
	CLK : out std_logic := '1';
	R : out std_logic_vector(7 downto 0) := "00000000";
	G : out std_logic_vector(7 downto 0) := "00000000";
	B : out std_logic_vector(7 downto 0) := "00000000";
	switch0, switch1, switch2 : in std_logic
);
end video_controller;

architecture Behavioral of video_controller is

signal cnt : natural range 0 to 10000000;

component clock_divider port (
      clk_in    : in std_logic;
      clk_out   : out std_logic
   );
end component;

component tfttest port (
	sysclk_in : in std_logic;
	light : out std_logic_vector (7 downto 0);
	DE : out std_logic := '0';
	TFT_EN : out std_logic := '0';
	DISP : out std_logic := '0';
	EN : out std_logic := '0'
);
end component;

signal videoclk : std_logic := '1';
--signal sysclk0 : std_logic := '1';

begin

my10mhz : clock_divider port map(
	--clk_in => sysclk0,
	clk_in => sysclk,
	clk_out => videoclk
);

myfsm : tfttest port map (
sysclk_in => videoclk,
	light => light,
	DE => DE,
	TFT_EN => TFT_EN,
	DISP => DISP,
	EN => EN
);

switches : process (switch0, switch1, switch2) is begin

	if (switch0 = '1') then R <= "11111111"; else R <= "00011111";
	end if;
	if (switch1 = '1') then G <= "11111111"; else G <= "00110000";
	end if;	
	if (switch2 = '1') then B <= "11111111"; else B <= "00001101";
	end if;

end process;

--lightshow : process is begin
--
--	wait until rising_edge(videoclk);
--	if cnt < 3333333 then R <= "11111111"; G <= "00000000"; B <= "00000000"; else
--	if cnt < 6666666 then R <= "00000000"; G <= "11111111"; B <= "00000000"; else
--	if cnt < 10000000 then R <= "00000000"; G <= "00000000"; B <= "11111111"; end if; end if; end if;
--	if cnt < 10000000 then cnt <= cnt + 1; else cnt <= 0; end if;
--	
--end process;


CLK <= videoclk;
--sysclk0 <= not sysclk0 after 5ns;
end Behavioral;

