library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity tfttest is port(
	sysclk_in : in std_logic;
	light : out std_logic_vector (7 downto 0) := "00000000";
	DE : out std_logic := '0';
	TFT_EN : out std_logic := '0';
	DISP : out std_logic := '0';
	EN : out std_logic := '0'
	);
end tfttest;

architecture Behavioral of tfttest is

type zustand is (init0, init1, ready, data);
signal v : zustand := init0;
signal boot_counter : integer range 0 to 6000 := 0;
signal col_counter : integer range 0 to 524 := 0;
signal row_counter : integer range 0 to 287 := 0;
signal bklt_counter : integer range 0 to 10 := 0;
signal v1 : zustand;

begin

boot : process is begin
	wait until rising_edge(sysclk_in);
v1 <= v;
case v is
	when init0 => if boot_counter = 10 then v1 <= init1;
		light(7) <= '1';
		TFT_EN <= '1';
		else boot_counter <= boot_counter + 1;
		v1 <= init0;
		end if;
	when init1 => if boot_counter = 5999 then v1 <= ready;
		light(6) <= '1';
		DISP <= '1';
		else boot_counter <= boot_counter + 1;
		end if;
	when ready => v1 <= data; light(5) <= '1';
	when data =>
	if row_counter < 16
		then DE <= '0';
	else if col_counter > 44
			then DE <= '1';
			else DE <= '0';
		end if;
	end if;
		if col_counter = 524 then col_counter <= 0;
				if row_counter = 287 then row_counter <= 0;
			else row_counter <= row_counter + 1;
		end if;
			else col_counter <= col_counter + 1;
		end if;
end case;
end process;

kante : process is begin
	wait until rising_edge(sysclk_in);
	v <= v1;
end process;

bklt : process is begin
	wait until rising_edge(sysclk_in);
	if bklt_counter < 9 then
		EN <= '1';
		bklt_counter <= bklt_counter + 1;
	else
		bklt_counter <= 0;
		EN <= '0';
	end if;

end process;

end Behavioral;