-- Deklaration und Implementierung der Simulationsumgebung

Library IEEE;
use IEEE.std_logic_1164.all;

-- Die SimBox ist die "ganze Welt", es existieren
-- keine Ein- und Ausgaenge
entity SimBox is
end SimBox;


architecture Test_NAND of SimBox is

-- Hier muss das NAND-Gatter mit
-- den gleichen Ports und Portnamen
-- wie in der Entity als Komponente deklariert werden

component NAND_gate
  port (
    a,b : in  STD_LOGIC;
    c   : out STD_LOGIC
  );
end component;

-- hier werden die Signale deklariert,
-- die in der Simbox verwendet werden
-- a_test und b_test sind Eingangssignale
-- die mit einem Startwert von 0 initiiert
-- werden.
-- der Wert von c_test ist ein Ausgangssignal
-- und wird sinnvoller weise nicht
-- spezifiziert

signal a_test, b_test : STD_LOGIC := '0';
signal c_test: STD_LOGIC;

--Konfiguration der SimBox
-- hier werden die verwendeten Architectures der Entity-Instanzen
-- angegeben. Bei nur einer Architektur je Entity
-- ist dieser Block !OPTIONAL!

for my_NAND_gate : NAND_gate use entity work.NAND_gate(behavior);

begin
  
  -- Dies ist die Instanziierung von
  -- my_NAND_gate der "Klasse" NAND_gate
  
  my_NAND_gate : NAND_gate
  port map (
    a => a_test,     -- explizite Zuordnung der Testsignale
    b => b_test,     -- zu den Ports der Entity
    c => c_test
  );
  
  -- Hier werden den Signalen konkrete Werte zugewiesen.
  -- Die Zeiten beziehen sich auf den Start der Simulation.
  a_test <= not a_test after 2 ns;
  
  b_test <= not b_test after 4 ns;
  
  
end Test_NAND;