
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity mux_gate is
    port ( s0 : in  STD_LOGIC;
           s1 : in  STD_LOGIC;
           s2 : in  STD_LOGIC;
           s3 : in  STD_LOGIC;
           d0 : in  STD_LOGIC;
           d1 : in  STD_LOGIC;
           y : out  STD_LOGIC);
end mux_gate;

architecture mux_behavior of mux_gate is

begin
	P1:process(s0, s1, s2, s3, d0, d1)
	begin
		if(d0 = '0' and d1 = '0') then
			y <= s0;
		else
			if (d0 = '0'  and d1 = '1') then
				y <= s1;
			else
				if(d0 = '1' and d1 = '0') then
					y <= s2;
				else
					if (d0 = '1' and d1 = '1') then
						y <= s3;
					end if;
				end if;
			end if;
		end if;
	end process P1;
end mux_behavior;

