library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


entity eq_gate is
    Port ( a : in  STD_LOGIC;
           b : in  STD_LOGIC;
           c : out  STD_LOGIC);
end eq_gate;

architecture eq_dataflow of eq_gate is

begin

c <= (not a and not b) or (a and b);

end eq_dataflow;

architecture eq_structure of eq_gate is

component mux_gate port (
	s0 : in  STD_LOGIC;
   s1 : in  STD_LOGIC;
   s2 : in  STD_LOGIC;
   s3 : in  STD_LOGIC;
   d0 : in  STD_LOGIC;
   d1 : in  STD_LOGIC;
   y : out  STD_LOGIC);
end component;

begin

my_mux_gate : mux_gate port map(
	s0 => '1',
	s1 => '0',
	s2 => '0',
	s3 => '1',
	d0 => a,
	d1 => b,
	y => c
);

end eq_structure;