library ieee;
use ieee.std_logic_1164.all;

entity tb_serialadder is
end tb_serialadder;

architecture tb of tb_serialadder is

    component serialadder
        port (clk : in std_logic);
    end component;

    signal clk : std_logic;

    constant TbPeriod : time := 1000 ns;
    signal TbClock : std_logic := '0';
    signal TbSimEnded : std_logic := '0';

begin

    dut : serialadder
    port map (clk => clk);

    -- Clock generation
    TbClock <= not TbClock after TbPeriod/2 when TbSimEnded /= '1' else '0';

    -- EDIT: Check that clk is really your main clock signal
    clk <= TbClock;

    stimuli : process
    begin
        -- EDIT Adapt initialization as needed

        -- EDIT Add stimuli here
        wait for 100 * TbPeriod;

        -- Stop the clock and hence terminate the simulation
        TbSimEnded <= '1';
        wait;
    end process;

end tb;

-- Configuration block below is required by some simulators. Usually no need to edit.

configuration cfg_tb_serialadder of tb_serialadder is
    for tb
    end for;
end cfg_tb_serialadder;