library ieee;
use ieee.std_logic_1164.all;

entity serialadder is
  generic (SIZE : natural := 8);
  port (
  clk : in std_logic
  );
end serialadder;

architecture behavioral of serialadder is

  signal a : std_logic_vector(SIZE-1 downto 0) := "10010110";
  signal b : std_logic_vector(SIZE-1 downto 0) := "00000001";
  signal carry_to_ff, carry_buf, carry_from_ff, a_feedback : std_logic;
  component fulladder is port(
    a, b, cin : in std_logic;
    s, cout : out std_logic
  );
end component;
  
  component flipflop is port(
  d, c : in std_logic;
  q : out std_logic
  );
end component;
begin

  
  fa : fulladder port map(a(0), b(0), carry_from_ff, a_feedback, carry_to_ff);
  ff : flipflop port map(carry_to_ff, clk, carry_from_ff);
  my_proc : process(clk) is begin
  
  if (rising_edge(clk)) then
    a(SIZE-2 downto 0) <= a (SIZE-1 downto 1);
    a(7) <= a_feedback;
    b(SIZE-2 downto 0) <= b (SIZE-1 downto 1);
    b(7) <= b(0);
  end if;

end process;
  
end architecture;

