library ieee;
use ieee.std_logic_1164.all;

entity look_ahead is
  port (
   a : in std_logic_vector(3 downto 0);
   b : in std_logic_vector(3 downto 0);
   s : out std_logic_vector(3 downto 0);
   cout : out std_logic
  );
end look_ahead;

architecture structure of look_ahead is

component halfadder is port(
   a : in std_logic;
   b : in std_logic;
   s : out std_logic;
   cout : out std_logic
);
end component;
signal s0, c0, s1, c1, s2, c2, s3, c3 : std_logic;

begin

my_ha0 : halfadder port map(a(0), b(0), s0, c0);
my_ha1 : halfadder port map(a(1), b(1), s1, c1);
my_ha2 : halfadder port map(a(2), b(2), s2, c2);
my_ha3 : halfadder port map(a(3), b(3), s3, c3);
  
s(0) <= s0;
s(1) <= (s1) xor (c0);
s(2) <= (s2) xor ((c0 and s1) or (c1));
s(3) <= (s3) xor ((c2) or ((s2) and (c1)) or ((s2) and (s1) and (c0)));
cout <= (c3) or ((s3) and (s2) and (s1) and (c0)) or ((s3) and (s2) and (c1)) or ((s3) and (c2));

end architecture;

