library ieee;
use ieee.std_logic_1164.all;

entity fulladder_ripple_carry is
  port (
  a, b : in std_logic_vector(7 downto 0);
  s : out std_logic_vector(7 downto 0);
  cout : out std_logic
  );
end fulladder_ripple_carry;

architecture structure of fulladder_ripple_carry is

component halfadder is port (
  a : in std_logic;
  b : in std_logic;
  s, cout : out std_logic
);
end component;

component fulladder is port (
  a : in std_logic;
  b : in std_logic;
  cin : in std_logic;
  s, cout : out std_logic
);
end component;

signal c0, c1, c2, c3, c4, c5, c6 : std_logic;

begin
 
  ha : halfadder port map (a(0), b(0),s(0), c0);
  fa1 : fulladder port map (a(1), b(1), c0, s(1), c1);
  fa2 : fulladder port map (a(2), b(2), c1, s(2), c2);
  fa3 : fulladder port map (a(3), b(3), c2, s(3), c3);
  fa4 : fulladder port map (a(4), b(4), c3, s(4), c4);
  fa5 : fulladder port map (a(5), b(5), c4, s(5), c5);
  fa6 : fulladder port map (a(6), b(6), c5, s(6), c6);
  fa7 : fulladder port map (a(7), b(7), c6, s(7), cout);

end architecture;
