library ieee;
use ieee.std_logic_1164.all;

entity fulladder_nand is
  port (
  a : in std_logic;
  b : in std_logic;
  cin : in std_logic;
  s : out std_logic;
  cout : out std_logic
  );
end fulladder_nand;

architecture dataflow of fulladder_nand is
begin
  s <= a xor b xor cin;
  cout <= (a and b) or (a and cin) or (b and cin);
end architecture;


architecture struct of fulladder_nand is

component halfadder_nand is port (
  a : in std_logic;
  b : in std_logic;
  s, cout : out std_logic
);
end component;

signal buf_1, buf_2, buf_3 : std_logic;

begin
  
  ha1 : halfadder_nand port map (a, b, buf_1, buf_2);
  ha2 : halfadder_nand port map (buf_1, cin, s, buf_3);
  
  cout <= (buf_3 nand buf_3) nand (buf_2 nand buf_2);

end architecture;