library ieee;
use ieee.std_logic_1164.all;

entity fulladder is
  port (
  a : in std_logic;
  b : in std_logic;
  cin : in std_logic;
  s : out std_logic;
  cout : out std_logic
  );
end fulladder;

architecture dataflow of fulladder is
begin
  s <= a xor b xor cin;
  cout <= (a and b) or (a and cin) or (b and cin);
end architecture;


architecture struct of fulladder is

component halfadder is port (
  a : in std_logic;
  b : in std_logic;
  s, cout : out std_logic
);
end component;

signal buf_1, buf_2, buf_3 : std_logic;

begin
  
  ha1 : halfadder port map (a, b, buf_1, buf_2);
  ha2 : halfadder port map (buf_1, cin, s, buf_3);
  
  cout <= buf_3 or buf_2;

end architecture;
