int PIN_A = 11;
int PIN_B = 12;
int PIN_S = 7;
int PIN_C = 8;
int PIN_DEBUG_LED = 13;

int write_and_get_expected(int a, int b);
void verifyKram(int expected);

void setup() {
  pinMode(PIN_A, OUTPUT);
  pinMode(PIN_B, OUTPUT);
  pinMode(PIN_S, INPUT);
  pinMode(PIN_C, INPUT);
  pinMode(PIN_DEBUG_LED, OUTPUT);
}

void loop() {
  write_and_check(LOW, LOW);
  write_and_check(LOW, HIGH);
  write_and_check(HIGH, HIGH);
  write_and_check(HIGH, LOW);
}

void write_and_check(int a, int b) {
  digitalWrite(PIN_A, a);
  digitalWrite(PIN_B, b);
  int sum = a + b;
  verify_kram(1 & sum, a & b);
}

void verify_kram(int expected_s, int expected_c) {
  int val = 0;
  digitalWrite(PIN_DEBUG_LED, LOW);
  delay(100);

  val = digitalRead(PIN_S);
  if (val != expected_s) {
    digitalWrite(PIN_DEBUG_LED, HIGH);
  } else {
    val = digitalRead(PIN_C);
    if (val != expected_c) {
      digitalWrite(PIN_DEBUG_LED, HIGH);
    }
  }
  delay(400);
}
