const int A_PINS[4] = {0, 2, 4, 6};
const int B_PINS[4] = {1, 3, 5, 7};
const int S_PINS[4] = {8, 9, 10, 11};
const int PIN_COUT = 12;
const int PIN_DEBUG_LED = 13;

void print_binary(int vals[]);
void perform_add_and_check(int a, int b);
void verify_values(int expected_s[], int expected_cout);

void setup() {
  for (int i = 0; i < 4; i++) {
    pinMode(A_PINS[i], OUTPUT);
    pinMode(B_PINS[i], OUTPUT);
    pinMode(S_PINS[i], INPUT);
  }
  pinMode(PIN_COUT, INPUT);
  pinMode(PIN_DEBUG_LED, OUTPUT);
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
}

void loop() {
  String input = Serial.readStringUntil('\n');
  input.trim();
  if (!input.length()){
    return;
  }
  int split_at = input.indexOf(" ");
  String val_one = input.substring(0, split_at);
  String val_two = input.substring(split_at + 1);
  int a = val_one.toInt();
  int b = val_two.toInt();
  //              A     B     Cin
  digitalWrite(PIN_DEBUG_LED, LOW);
  perform_add_and_check(a, b);
}

void print_binary(int vals[]) {
  for (int i = 3; i >= 0; i--) {
    Serial.print(vals[i]);
  }
}

void perform_add_and_check(int a, int b) {
  a = a % 16;
  b = b % 16;
  Serial.print("Adding integers ");
  Serial.print(a);
  Serial.print(" and ");
  Serial.println(b);

  int a_vals[4];
  int b_vals[4];
  int s_vals[4];
  int cout;
  // values to write
  for (int i = 0; i < 4; i++) {
    a_vals[i] = 1 & (a >> i);
  }
  for (int i = 0; i < 4; i++) {
    b_vals[i] = 1 & (b >> i);
  }
  Serial.print("As binaries: ");
  print_binary(a_vals);
  Serial.print(" and ");
  print_binary(b_vals);
  Serial.print("\n");

  // expected values
  int s = (a) + (b);
  for (int i = 0; i < 4; i++) {
    s_vals[i] = 1 & (s >> i);
  }
  cout = 1 & (s >> 4);

  // write values
  for (int i = 0; i < 4; i++) {
    digitalWrite(A_PINS[i], a_vals[i]);
  }
  for (int i = 0; i < 4; i++) {
    digitalWrite(B_PINS[i], b_vals[i]);
  }

  // verify output
  verify_values(s_vals, cout);
}

void verify_values(int expected_s[], int expected_cout) {
  delay(10);

  // read actual values
  int actual_s[4];
  for (int i = 0; i < 4; i++) {
    actual_s[i] = digitalRead(S_PINS[i]);
  }
  int actual_cout = digitalRead(PIN_COUT);

  // verify sum
  Serial.print("Expected sum: ");
  print_binary(expected_s);
  Serial.print(", actual sum: ");
  print_binary(actual_s);
  for (int i = 0; i < 4; i++) {
    if (expected_s[i] != actual_s[i]) {
      digitalWrite(PIN_DEBUG_LED, HIGH);
    }
  }
  Serial.print("\n");

  // verify carry
  Serial.print("Expected carry: ");
  Serial.print(expected_cout);
  Serial.print(", actual carry: ");
  Serial.print(actual_cout);
  Serial.print("\n");
  if (actual_cout != expected_cout) {
    digitalWrite(PIN_DEBUG_LED, HIGH);
  }
  delay(20);
}
