int PIN_A = 9;
int PIN_B = 10;
int PIN_CIN = 11;
int PIN_S = 8;
int PIN_COUT = 7;
int PIN_DEBUG_LED = 13;

int write_and_get_expected(int a, int b, int cin);
void verify_kram(int expected_s, int expected_c);

void setup() {
  pinMode(PIN_A, OUTPUT);
  pinMode(PIN_B, OUTPUT);
  pinMode(PIN_CIN, OUTPUT);
  pinMode(PIN_S, INPUT);
  pinMode(PIN_COUT, INPUT);
  pinMode(PIN_DEBUG_LED, OUTPUT);
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
}

void loop() {
  //              A     B     Cin
  Serial.println("Starting iteration");
  write_and_check(LOW,  LOW,  LOW);
  write_and_check(LOW,  LOW,  HIGH);
  write_and_check(LOW,  HIGH, HIGH);
  write_and_check(LOW,  HIGH, LOW);
  write_and_check(HIGH, HIGH, LOW);
  write_and_check(HIGH, HIGH, HIGH);
  write_and_check(HIGH, LOW,  HIGH);
  write_and_check(HIGH, LOW,  LOW);
}

void write_and_check(int a, int b, int cin) {
  digitalWrite(PIN_A, a);
  digitalWrite(PIN_B, b);
  digitalWrite(PIN_CIN, cin);
  Serial.print("Adding a: ");
  Serial.print(a);
  Serial.print(", b: ");
  Serial.print(b);
  Serial.print(", cin: ");
  Serial.print(cin);
  Serial.print("\n");
  int sum = a + b + cin;
  int s = 1 & sum;
  int c = sum >> 1;
  verify_kram(s, c);
}

void verify_kram(int expected_s, int expected_c) {
  int val = 0;
  digitalWrite(PIN_DEBUG_LED, LOW);
  delay(100);

  val = digitalRead(PIN_S);
  Serial.print("Expected sum: ");
  Serial.print(expected_s);
  Serial.print(", actual sum: ");
  Serial.print(val);
  Serial.print("\n");
  if (val != expected_s) {
    digitalWrite(PIN_DEBUG_LED, HIGH);
  } else {
    val = digitalRead(PIN_COUT);
    Serial.print("Expected carry: ");
    Serial.print(expected_c);
    Serial.print(", actual carry: ");
    Serial.print(val);
    Serial.print("\n");
    if (val != expected_c) {
      digitalWrite(PIN_DEBUG_LED, HIGH);
    }
  }
  delay(400);
}
