const byte A_PINS[4] = {0, 2, 4, 6};
const byte B_PINS[4] = {1, 3, 5, 7};
const byte S_PINS[4] = {8, 9, 10, 11};
const byte PIN_COUT = 12;
const byte PIN_CIN = 13;
const byte PIN_OVERFLOW = A0;

void setup() {
  for (byte i = 0; i < 4; i++) {
    pinMode(A_PINS[i], OUTPUT);
    pinMode(B_PINS[i], OUTPUT);
    pinMode(S_PINS[i], INPUT);
  }
  pinMode(PIN_COUT, INPUT);
  pinMode(PIN_CIN, OUTPUT);
  pinMode(PIN_OVERFLOW, INPUT);
  Serial.begin(115200);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
}

void loop() {
  String input = Serial.readStringUntil('\n');
  input.trim();
  if (!input.length()) {
    return;
  }
  int split_at = input.indexOf(" ");
  String val_one = input.substring(0, split_at);
  int a = val_one.toInt();
  String val_two = input.substring(split_at + 1);
  int b = val_two.toInt();

  perform_add(a, b);
}

void print_binary(byte vals[]) {
  for (byte i = 0; i < 32; i++) {
    Serial.print(vals[31 - i]);
  }
}

void perform_add(int a_int, int b_int) {
  // print as decimal
  Serial.print("Adding integers ");
  Serial.print(a_int);
  Serial.print(" and ");
  Serial.println(b_int);

  // convert to binaries
  byte a_binary[32];
  for (byte i = 0; i < 32; i++) {
    a_binary[i] = 1 & (a_int >> i);
  }
  byte b_binary[32];
  for (byte i = 0; i < 32; i++) {
    b_binary[i] = 1 & (b_int >> i);
  }

  // print binaries
  Serial.print("As binaries: ");
  print_binary(a_binary);
  Serial.print(" and ");
  print_binary(b_binary);
  Serial.println("");

  // perform calculation
  byte cin = 0;
  byte s_binary[32];
  byte overflow_binary;
  for (byte i = 0; i < 8; i++) {
    byte offset = 4 * i;
    perform_4bit_calculation(a_binary + offset, b_binary + offset, cin, s_binary + offset, &cin, &overflow_binary);
  }

  // print results
  Serial.println("Result is:");
  int result = 0;
  for (byte i = 0; i < 32; i++) {
    result += s_binary[i] << i;
  }
  Serial.println(result);
  Serial.println("As binary:");
  print_binary(s_binary);
  Serial.println("");
  // bool overflow = (a_binary[31] && b_binary[31] && !s_binary[31]) || (!a_binary[31] && !b_binary[31] && s_binary[31]);
  bool overflow = overflow_binary > 0;
  if (overflow) {
    Serial.println("Overflow detected!");
  }
}

void perform_4bit_calculation(byte a_vals[], byte b_vals[], byte cin, byte s_vals[], byte *cout, byte *overflow) {
  // write values
  digitalWrite(PIN_CIN, cin);
  for (byte i = 0; i < 4; i++) {
    digitalWrite(A_PINS[i], a_vals[i]);
    /*Serial.print("Write ");
    Serial.print(a_vals[i]);
    Serial.print(" to PIN ");
    Serial.println(A_PINS[i]);*/
  }
  for (byte i = 0; i < 4; i++) {
    digitalWrite(B_PINS[i], b_vals[i]);
    /*Serial.print("Write ");
    Serial.print(b_vals[i]);
    Serial.print(" to PIN ");
    Serial.println(B_PINS[i]);*/
  }

  // wait for gatters to switch
  //delay(5);

  // read actual values
  byte actual_s[4];
  for (byte i = 0; i < 4; i++) {
    actual_s[i] = digitalRead(S_PINS[i]);
  }
  byte actual_cout = digitalRead(PIN_COUT);
  byte actual_overflow = digitalRead(PIN_OVERFLOW);

  // return values
  for (byte i = 0; i < 4; i++) {
    s_vals[i] = actual_s[i];
  }
  *cout = actual_cout;
  *overflow = actual_overflow;
}
