const int A_PINS[4] = {0, 2, 4, 6};
const int B_PINS[4] = {1, 3, 5, 7};
const int S_PINS[4] = {8, 9, 10, 11};
const int PIN_COUT = 12;
const int PIN_DEBUG_LED = 13;

void print_binary(int vals[]);
void perform_add_and_check(int a, int b);
void verify_values(int expected_s[], int expected_cout);

void setup() {
  for (int i = 0; i < 4; i++) {
    pinMode(A_PINS[i], OUTPUT);
    pinMode(B_PINS[i], OUTPUT);
    pinMode(S_PINS[i], INPUT);
  }
  pinMode(PIN_COUT, INPUT);
  pinMode(PIN_DEBUG_LED, OUTPUT);
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
}

void loop() {
  String input = Serial.readStringUntil('\n');
  input.trim();
  if (!input.length()) {
    return;
  }
  int split_at = input.indexOf(" ");
  String val_one = input.substring(0, split_at);
  int a = val_one.toInt();
  String val_two = input.substring(split_at + 1);
  int b = val_two.toInt();

  digitalWrite(PIN_DEBUG_LED, LOW);
  perform_add_and_check(a, b);
}

void print_binary(int vals[]) {
  for (int i = 3; i >= 0; i--) {
    Serial.print(vals[i]);
  }
}

void perform_add_and_check(int a, int b) {
  int a_logical;
  int b_logical;
  bool substract = false;

  if (a < 0) {
    a = (-a) % 8;
    a_logical = -a;
    a = (~a) + 1;
    substract = true;
  } else {
    a = a % 16;
    a_logical = a;
  }
  if (b < 0) {
    b = (-b) % 8;
    b_logical = -b;
    b = (~b) + 1;
    substract = true;
  } else {
    b = b % 16;
    b_logical = b;
  }

  Serial.print("Adding integers ");
  Serial.print(a_logical);
  Serial.print(" and ");
  Serial.println(b_logical);

  int a_vals[4];
  int b_vals[4];
  int s_vals[4];
  int cout;
  // values to write
  for (int i = 0; i < 4; i++) {
    a_vals[i] = 1 & (a >> i);
  }
  for (int i = 0; i < 4; i++) {
    b_vals[i] = 1 & (b >> i);
  }
  Serial.print("As binaries: ");
  print_binary(a_vals);
  Serial.print(" and ");
  print_binary(b_vals);
  Serial.print("\n");

  // expected values
  int s = (a) + (b);
  for (int i = 0; i < 4; i++) {
    s_vals[i] = 1 & (s >> i);
  }
  cout = 1 & (s >> 4);

  // write values
  for (int i = 0; i < 4; i++) {
    digitalWrite(A_PINS[i], a_vals[i]);
    Serial.print("Write ");
    Serial.print(a_vals[i]);
    Serial.print(" to PIN ");
    Serial.println(A_PINS[i]);
  }
  for (int i = 0; i < 4; i++) {
    digitalWrite(B_PINS[i], b_vals[i]);
    Serial.print("Write ");
    Serial.print(b_vals[i]);
    Serial.print(" to PIN ");
    Serial.println(B_PINS[i]);
  }

  // verify output
  get_results(a_vals, b_vals, s_vals, cout, substract);
}

void get_results(int a_vals[], int b_vals[], int expected_s[], int expected_cout, bool substract) {
  delay(10);

  // read actual values
  int actual_s[4];
  for (int i = 0; i < 4; i++) {
    actual_s[i] = digitalRead(S_PINS[i]);
  }
  int actual_cout = digitalRead(PIN_COUT);

  // verify sum
  Serial.print("Expected sum: ");
  print_binary(expected_s);
  Serial.print(", actual sum: ");
  print_binary(actual_s);
  for (int i = 0; i < 4; i++) {
    if (expected_s[i] != actual_s[i]) {
      digitalWrite(PIN_DEBUG_LED, HIGH);
    }
  }
  Serial.print("\n");

  if (!substract) {
    // verify carry
    Serial.print("Expected carry: ");
    Serial.print(expected_cout);
    Serial.print(", actual carry: ");
    Serial.print(actual_cout);
    Serial.print("\n");
    if (actual_cout != expected_cout) {
      digitalWrite(PIN_DEBUG_LED, HIGH);
    }
    Serial.print("Result is: ");
    int sum = 0;
    for (int i = 0; i < 4; i++) {
      sum += actual_s[i] << i;
    }
    Serial.println(sum);
    if (actual_cout) {
      Serial.println("Overflow detected!");
    }
  } else {
    bool overflow = (a_vals[3] && b_vals[3] && !actual_s[3]) ||  (!a_vals[3] && !b_vals[3] && actual_s[3]);
    bool negative = actual_s[3] & 1;
    int sum = 0;
    for (int i = 0; i < 3; i++) {
      sum += actual_s[i] << i;
    }
    Serial.print("Result is: ");
    if (negative) {
      sum = ~(sum - 1);
      sum = 7 & sum;
      if (sum == 0) {
        sum = 8;
      }
      Serial.print("-");
      Serial.println(sum);
    } else {
      sum = 7 & sum;
      Serial.println(sum);
    }
    if (overflow) {
      Serial.println("Overflow detected!");
    }
  }
  delay(20);
}

