/*
  Blink
  Turns on an LED on for one second, then off for one second, repeatedly.

  Most Arduinos have an on-board LED you can control. On the Uno and
  Leonardo, it is attached to digital pin 13. If you're unsure what
  pin the on-board LED is connected to on your Arduino model, check
  the documentation at http://arduino.cc

  This example code is in the public domain.

  modified 8 May 2014
  by Scott Fitzgerald
 */


// the setup function runs once when you press reset or power the board
void setup() {
  // initialize digital pin 13 as an output.
  pinMode(13, OUTPUT);
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
}

// the loop function runs over and over again forever
void loop() {
  String input = Serial.readStringUntil('\n');
  input.trim();
  if (!input.equals("")) {
    if (input.equalsIgnoreCase("on")) {
      Serial.println("Turning on LED...");
      digitalWrite(13, HIGH);
    } else if (input.equalsIgnoreCase("off")) {
      Serial.println("Turning off LED...");
      digitalWrite(13, LOW);
    } else {
      Serial.println("Unknown command. Try on/off");
    }
  }
}
