int PIN_A = 4;
int PIN_B = 7;
int PIN_C = 8;
int PIN_OUT = 12;
int PIN_DEBUG_LED = 13;

int write_and_get_expected(int a, int b, int c);
void verifyKram(int expected);

void setup() {
  pinMode(PIN_A, OUTPUT);
  pinMode(PIN_B, OUTPUT);
  pinMode(PIN_C, OUTPUT);
  pinMode(PIN_DEBUG_LED, OUTPUT);
  pinMode(PIN_OUT, INPUT);
}

void loop() {
  int expected = write_and_get_expected(LOW, LOW, LOW);
  verify_kram(expected);

  expected = write_and_get_expected(HIGH, LOW, LOW);
  verify_kram(expected);

  expected = write_and_get_expected(HIGH, HIGH, LOW);
  verify_kram(expected);

  expected = write_and_get_expected(LOW, HIGH, LOW);
  verify_kram(expected);

  expected = write_and_get_expected(LOW, HIGH, HIGH);
  verify_kram(expected);

  expected = write_and_get_expected(HIGH, HIGH, HIGH);
  verify_kram(expected);

  expected = write_and_get_expected(LOW, HIGH, HIGH);
  verify_kram(expected);

  expected = write_and_get_expected(LOW, LOW, HIGH);
  verify_kram(expected);
}

int write_and_get_expected(int a, int b, int c) {
  digitalWrite(PIN_A, a);
  digitalWrite(PIN_B, b);
  digitalWrite(PIN_C, c);
  return (a && b) || c;
}

void verify_kram(int expected) {
  int val = 0;
  digitalWrite(PIN_DEBUG_LED, LOW);
  delay(100);

  val = digitalRead(PIN_OUT);
  if (val != expected) {
    digitalWrite(PIN_DEBUG_LED, HIGH);
  }
  delay(400);
}
