#include <errno.h>
#include <string.h>
#include <arpa/inet.h>
#include <net/ethernet.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#include <netpacket/packet.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#ifndef ARDUINO_ETH
#define ARDUINO_ETH "eth0"
#define IFNAMSIZ 4
#define BUF_SIZ 512
#endif


void setup() {
  struct ifreq ifr;
  struct ifreq if_mac;
  struct sockaddr_in sin;
  int ret;
  int tx_len = 0;
  char sendbuf[BUF_SIZ];
  struct ether_header *eh = (struct ether_header *) sendbuf;
  const unsigned char ether_broadcast_addr[] = {0xde, 0xad, 0xbe, 0xef, 0x13, 0x37};
  memset(sendbuf, 0, BUF_SIZ);

  // start Serial interface
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }

  // open socket
  int fd = socket(AF_PACKET, SOCK_RAW, IPPROTO_RAW);
  if (fd == -1) {
    Serial.println("Error opening socket");
    Serial.println(strerror(errno));
    return;
  } else {
    Serial.println("Socket successfully opened");
  }

  // bring up interface
  strncpy(ifr.ifr_name, ARDUINO_ETH, IFNAMSIZ);
  ret = ioctl(fd, SIOCGIFFLAGS, &ifr);
  if (ret < 0) {
    close(fd);
    Serial.println("Error bringing up interface");
    Serial.println("cannot ioctl to get SIOCGIFFLAGS");
    return;
  }
  if (ifr.ifr_flags | ~(IFF_UP)) {
    ifr.ifr_flags |= IFF_UP | IFF_RUNNING;
    ret = ioctl(fd, SIOCSIFFLAGS, &ifr);
    if (ret < 0) {
      close(fd);
      Serial.println("Error bringing up interface");
      Serial.println("cannot ioctl to get SIOCSIFFLAGS");
      return;
    }
  }

  // get interface index
  if (ioctl(fd, SIOCGIFINDEX, &ifr) == -1) {
    Serial.println("Error getting interface index");
    Serial.println(strerror(errno));
    return;
  }
  int ifindex = ifr.ifr_ifindex;

  // get interface mac
  memset(&if_mac, 0, sizeof(struct ifreq));
  strncpy(if_mac.ifr_name, ARDUINO_ETH, IFNAMSIZ);
  if (ioctl(fd, SIOCGIFHWADDR, &if_mac) < 0) {
    Serial.println("Error optaining hardware address");
    Serial.println(strerror(errno));
    return;
  }

  /* Ethernet header */
  //memcpy(eh->ether_shost, if_mac.ifr_hwaddr.sa_data, 
  eh->ether_shost[0] = ((uint8_t *)&if_mac.ifr_hwaddr.sa_data)[0];
  eh->ether_shost[1] = ((uint8_t *)&if_mac.ifr_hwaddr.sa_data)[1];
  eh->ether_shost[2] = ((uint8_t *)&if_mac.ifr_hwaddr.sa_data)[2];
  eh->ether_shost[3] = ((uint8_t *)&if_mac.ifr_hwaddr.sa_data)[3];
  eh->ether_shost[4] = ((uint8_t *)&if_mac.ifr_hwaddr.sa_data)[4];
  eh->ether_shost[5] = ((uint8_t *)&if_mac.ifr_hwaddr.sa_data)[5];
  eh->ether_dhost[0] = ether_broadcast_addr[0];
  eh->ether_dhost[1] = ether_broadcast_addr[1];
  eh->ether_dhost[2] = ether_broadcast_addr[2];
  eh->ether_dhost[3] = ether_broadcast_addr[3];
  eh->ether_dhost[4] = ether_broadcast_addr[4];
  eh->ether_dhost[5] = ether_broadcast_addr[5];
  /* Ethertype field */
  eh->ether_type = htons(0x88B5);
  tx_len += sizeof(struct ether_header);

  // set packet payload
  sendbuf[tx_len++] = 0xde;
  sendbuf[tx_len++] = 0xad;
  sendbuf[tx_len++] = 0xbe;
  sendbuf[tx_len++] = 0xef;

  // construct destination address
  struct sockaddr_ll addr = {0};
  addr.sll_family = AF_PACKET;
  addr.sll_ifindex = ifindex;
  addr.sll_halen = ETHER_ADDR_LEN;
  addr.sll_protocol = htons(ETH_P_ALL);
  memcpy(addr.sll_addr, ether_broadcast_addr, ETHER_ADDR_LEN);

  // construct message
  struct iovec iov;
  iov.iov_base = &sendbuf;
  iov.iov_len = tx_len;
  struct msghdr message;
  message.msg_name = &addr;
  message.msg_namelen = sizeof(addr);
  message.msg_iov = &iov;
  message.msg_iovlen = 1;
  message.msg_control = 0;
  message.msg_controllen = 0;

  // send message
  if (sendmsg(fd, &message, 0) == -1) {
    Serial.println("Error sending message");
    Serial.println(strerror(errno));
    return;
  }
}

void loop() {
  delay(100);
}
