----------------------------------------------------------------------------------
-- Company:
-- Engineer: Meister Rados
--
-- Create Date: 02.05.2017 17:08:24
-- Design Name:
-- Module Name: top_module - Behavioral
-- Project Name: Bachelorarbeit
-- Target Devices: Artix-7
-- Tool Versions:
-- Description: Topmodul der Bachelorarbeit
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

ENTITY top_module IS
	PORT (
		clk_in : IN std_logic;
		reset_in : IN std_logic;
		done_out : OUT std_logic;
		up : OUT std_logic;
		down : OUT std_logic;
		left : OUT std_logic;
		right : OUT std_logic;
		miso_jstk : IN STD_LOGIC;
		ss_jstk : OUT STD_LOGIC;
		sclk_jstk : OUT STD_LOGIC;
		mosi_jstk : OUT STD_LOGIC
	);
END top_module;

ARCHITECTURE Behavioral OF top_module IS

	COMPONENT jstk_controller
		PORT (
			clk : IN std_logic;
			reset : IN std_logic;
			led2 : IN std_logic;
			led1 : IN std_logic;
			up : OUT std_logic;
			down : OUT std_logic;
			left : OUT std_logic;
			right : OUT std_logic;
			btn1 : OUT std_logic;
			btn2 : OUT std_logic;
			btn3 : OUT std_logic;
			miso : IN std_logic;
			ss : OUT std_logic;
			sclk : OUT std_logic;
			mosi : OUT std_logic
		);
	END COMPONENT;

	COMPONENT math_module
		PORT (
			clk : IN std_logic; --clock for math_module
			reset : IN std_logic;
			data : IN std_logic_vector (63 DOWNTO 0); --upper left re and im value, stepsize
			run : IN std_logic; --calc pictute
			re_ready : IN std_logic;
			im_ready : IN std_logic;
			zf_ready : IN std_logic;
			pixel_received : IN std_logic;
			re_received : OUT std_logic;
			im_received : OUT std_logic;
			zf_received : OUT std_logic;
			result_data : OUT std_logic_vector (22 DOWNTO 0);
			pixel_done : OUT std_logic;
			picture_done : OUT std_logic
		);
	END COMPONENT;

	COMPONENT clk_wiz_0
		PORT (
			reset : IN std_logic;
			clk_in1 : IN std_logic;
			clk_out1 : OUT std_logic;
			locked : OUT std_logic
		);
	END COMPONENT;

	COMPONENT floating_point_multiply
		PORT (
			aclk : IN STD_LOGIC;
			s_axis_a_tvalid : IN STD_LOGIC;
			s_axis_a_tready : OUT STD_LOGIC;
			s_axis_a_tdata : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid : IN STD_LOGIC;
			s_axis_b_tready : OUT STD_LOGIC;
			s_axis_b_tdata : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);
	END COMPONENT;

	COMPONENT floating_point_adder
		PORT (
			aclk : IN STD_LOGIC;
			s_axis_a_tvalid : IN STD_LOGIC;
			s_axis_a_tready : OUT STD_LOGIC;
			s_axis_a_tdata : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid : IN STD_LOGIC;
			s_axis_b_tready : OUT STD_LOGIC;
			s_axis_b_tdata : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);
	END COMPONENT;
	COMPONENT floating_point_subtractor
		PORT (
			aclk : IN STD_LOGIC;
			s_axis_a_tvalid : IN STD_LOGIC;
			s_axis_a_tready : OUT STD_LOGIC;
			s_axis_a_tdata : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid : IN STD_LOGIC;
			s_axis_b_tready : OUT STD_LOGIC;
			s_axis_b_tdata : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);
	END COMPONENT;
	--signals for joystick
	SIGNAL jstk_led2, jstk_led1, jstk_up, jstk_down, jstk_left, jstk_right, jstk_btn2, jstk_btn1, jstk_btn3 : std_logic := '0';
	SIGNAL jstk_miso, jstk_ss, jstk, jstk_mosi, jstk_sclk : std_logic;
	SIGNAL clk : std_logic;

	--signals for math_module
	SIGNAL llre : std_logic_vector (63 DOWNTO 0) := "1100000000001000000000000000000000000000000000000000000000000000"; --lower left corner re value, deafult -3
	SIGNAL llim : std_logic_vector (63 DOWNTO 0) := "1100000000000000000000000000000000000000000000000000000000000000"; --lower left corner im value, default -2
	SIGNAL zf : std_logic_vector (63 DOWNTO 0) := "0011111110110000000000000000000000000000000000000000000000000000"; --default 0.0625
	SIGNAL mem, data : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL zoom, run, re_ready, im_ready, zf_ready : std_logic := '0';
	SIGNAL done, re_received, im_received, zf_received : std_logic;
	SIGNAL pixel_done, picture_done, pixel_received : std_logic;
	SIGNAL result_data : std_logic_vector (22 DOWNTO 0) := "00000000000000000000000";


	--signals for led_controller
	SIGNAL r, g, b : std_logic_vector (2 DOWNTO 0);
	Signal x, y : natural range 0 to 95;

	--signals for FSM
	TYPE main_states IS (send_re, idle, send_im, send_zf, wait_for_pixel, pixel_received_state, restart, move_right0, move_right1, move_right2, move_right3, move_right4, move_right5, move_left0, move_left1, move_left2, move_left3, move_left4, move_left5, move_up0, move_up1, move_up2, move_up3, move_up4, move_up5, move_down0, move_down1, move_down2, move_down3, move_down4, move_down5, zoom0, zoom1, zoom2, zoom3, zoom4, zoom5, zoom6, zoom7, zoom8);
	SIGNAL main_state : main_states := send_re;
	SIGNAL main_state_next : main_states;

	--signals for adder and multiplier and subtractor

	SIGNAL m0_a_valid, m0_a_ready, m0_b_valid, m0_b_ready, m0_result_valid, m0_result_ready : std_logic := '0';
	SIGNAL m0_a_data, m0_b_data, m0_result : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";

	SIGNAL a0_a_valid, a0_a_ready, a0_b_valid, a0_b_ready, a0_result_valid, a0_result_ready : std_logic := '0';
	SIGNAL a0_a_data, a0_b_data, a0_result : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";

	SIGNAL s0_a_valid, s0_a_ready, s0_b_valid, s0_b_ready, s0_result_valid, s0_result_ready : std_logic := '0';
	SIGNAL s0_a_data, s0_b_data, s0_result : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
BEGIN
	clk_gen : clk_wiz_0
	PORT MAP(
		reset => reset_in, 
		clk_in1 => clk_in, 
		clk_out1 => clk, 
		locked => OPEN
	);

	jstk_controller0 : jstk_controller
	PORT MAP(
		clk => clk, 
		reset => reset_in, 
		led2 => jstk_led2, 
		led1 => jstk_led1, 
		up => jstk_up, 
		down => jstk_down, 
		left => jstk_left, 
		right => jstk_right, 
		btn1 => jstk_btn1, 
		btn2 => jstk_btn2, 
		btn3 => jstk_btn3, 
		miso => jstk_miso, 
		ss => jstk_ss, 
		sclk => jstk_sclk, 
		mosi => jstk_mosi
	);

	math_module0 : math_module
	PORT MAP(
		clk => clk, 
		reset => reset_in, 
		data => data, 
		run => run, 
		re_ready => re_ready, 
		im_ready => im_ready, 
		zf_ready => zf_ready, 
		pixel_received => pixel_received, 
		re_received => re_received, 
		im_received => im_received, 
		zf_received => zf_received, 
		result_data => result_data, 
		pixel_done => pixel_done, 
		picture_done => picture_done
	);

	multiplyer0 : floating_point_multiply
	PORT MAP(
		aclk => clk, 
		s_axis_a_tvalid => m0_a_valid, 
		s_axis_a_tready => m0_a_ready, 
		s_axis_a_tdata => m0_a_data, 
		s_axis_b_tvalid => m0_b_valid, 
		s_axis_b_tready => m0_b_ready, 
		s_axis_b_tdata => m0_b_data, 
		m_axis_result_tvalid => m0_result_valid, 
		m_axis_result_tready => m0_result_ready, 
		m_axis_result_tdata => m0_result
	);

	adder0 : floating_point_adder
	PORT MAP(
		aclk => clk, 
		s_axis_a_tvalid => a0_a_valid, 
		s_axis_a_tready => a0_a_ready, 
		s_axis_a_tdata => a0_a_data, 
		s_axis_b_tvalid => a0_b_valid, 
		s_axis_b_tready => a0_b_ready, 
		s_axis_b_tdata => a0_b_data, 
		m_axis_result_tvalid => a0_result_valid, 
		m_axis_result_tready => a0_result_ready, 
		m_axis_result_tdata => a0_result
	);

	subtractor0 : floating_point_subtractor
	PORT MAP(
		aclk => clk, 
		s_axis_a_tvalid => s0_a_valid, 
		s_axis_a_tready => s0_a_ready, 
		s_axis_a_tdata => s0_a_data, 
		s_axis_b_tvalid => s0_b_valid, 
		s_axis_b_tready => s0_b_ready, 
		s_axis_b_tdata => s0_b_data, 
		m_axis_result_tvalid => s0_result_valid, 
		m_axis_result_tready => s0_result_ready, 
		m_axis_result_tdata => s0_result
	);
	--next state process
	next_state : PROCESS (clk) IS BEGIN
		IF rising_edge(clk) THEN
--			IF (reset_in = '1') THEN
--				main_state <= restart;
--			ELSE
				main_state <= main_state_next;
--			END IF;
		END IF;
	END PROCESS;

	outputs : PROCESS (main_state) IS BEGIN
			data <= "0000000000000000000000000000000000000000000000000000000000000000";
			run <= '0';
			re_ready <= '0';
			im_ready <= '0';
			zf_ready <= '0';
			done <= '0';
			done_out <= '0';
			pixel_received <= '0';
			up <= jstk_up;
			down <= jstk_down;
			left <= jstk_left;
			right <= jstk_right;
			zoom <= jstk_btn3;
			jstk_led2 <= jstk_btn2 OR jstk_btn3;
			jstk_led1 <= jstk_btn1 OR jstk_btn3;
			ss_jstk <= jstk_ss;
			mosi_jstk <= jstk_mosi;
			jstk_miso <= miso_jstk;
			sclk_jstk <= jstk_sclk;
			a0_a_data <= "0000000000000000000000000000000000000000000000000000000000000000";
			a0_b_data <= "0000000000000000000000000000000000000000000000000000000000000000";
			m0_a_data <= "0000000000000000000000000000000000000000000000000000000000000000";
			m0_b_data <= "0000000000000000000000000000000000000000000000000000000000000000";
			m0_a_valid <= '0';
			m0_b_valid <= '0';
			m0_result_ready <= '0';
			a0_a_valid <= '0';
			a0_b_valid <= '0';
			a0_result_ready <= '0';
			s0_a_valid <= '0';
			s0_b_valid <= '0';
			s0_result_ready <= '0';
			s0_a_data <= "0000000000000000000000000000000000000000000000000000000000000000";
			s0_b_data <= "0000000000000000000000000000000000000000000000000000000000000000";
 
			CASE main_state IS
				WHEN idle => done_out <= '1';
				WHEN send_re => re_ready <= '1';
				data <= llre;
				run <= '1'; --notify math_module to receive new vaules via 64bit bus
				WHEN send_im => im_ready <= '1';
				data <= llim;
				run <= '1';
				WHEN send_zf => zf_ready <= '1';
				data <= zf;
				run <= '1';
				WHEN wait_for_pixel => 
				WHEN pixel_received_state => 
				    pixel_received <= '1';
				    x <= to_integer(unsigned(result_data (12 downto 0))) mod 96;
				    y <= to_integer(unsigned(result_data (12 downto 0))) / 96;
				    r <= result_data (15 DOWNTO 13);
				    g <= result_data (18 DOWNTO 16);
				    b <= result_data (21 DOWNTO 19);
				WHEN restart => --restore default values
					llre <= "1100000000001000000000000000000000000000000000000000000000000000";
					llim <= "1100000000000000000000000000000000000000000000000000000000000000";
					zf <= "0011111110110000000000000000000000000000000000000000000000000000";
				WHEN move_up0 => 
					m0_a_valid <= '1';
					m0_b_valid <= '1';
					m0_a_data <= "0100000001000000000000000000000000000000000000000000000000000000"; --constant 32
					m0_b_data <= zf;
					m0_result_ready <= '1';
				WHEN move_up1 => 
				WHEN move_up2 => 
					mem <= m0_result;
				WHEN move_up3 => 
					a0_a_valid <= '1';
					a0_b_valid <= '1';
					a0_a_data <= llim;
					a0_b_data <= mem;
					a0_result_ready <= '1';
				WHEN move_up4 => 
				WHEN move_up5 => 
					llim <= a0_result;
					run <= '1';
				WHEN move_down0 => 
					m0_a_valid <= '1';
					m0_b_valid <= '1';
					m0_a_data <= "0100000001000000000000000000000000000000000000000000000000000000"; --constant 32
					m0_b_data <= zf;
					m0_result_ready <= '1';
				WHEN move_down1 => 
				WHEN move_down2 => 
					mem <= m0_result;
				WHEN move_down3 => 
					s0_a_valid <= '1';
					s0_b_valid <= '1';
					s0_a_data <= llim;
					s0_b_data <= mem;
					s0_result_ready <= '1';
				WHEN move_down4 => 
				WHEN move_down5 => 
					llim <= s0_result;
					run <= '1';
				WHEN move_left0 => 
					m0_a_valid <= '1';
					m0_b_valid <= '1';
                    m0_a_data <= "0100000001001000000000000000000000000000000000000000000000000000"; --constant 48
                    m0_b_data <= zf;
					m0_result_ready <= '1';
				WHEN move_left1 => 
				WHEN move_left2 => 
					mem <= m0_result;
				WHEN move_left3 => 
					s0_a_valid <= '1';
					s0_b_valid <= '1';
					s0_a_data <= llre;
					s0_b_data <= mem;
					s0_result_ready <= '1';
				WHEN move_left4 => 
				WHEN move_left5 => 
					llre <= s0_result;
					run <= '1';
				WHEN move_right0 => 
					m0_a_valid <= '1';
					m0_b_valid <= '1';
                    m0_a_data <= "0100000001001000000000000000000000000000000000000000000000000000"; --constant 48
                    m0_b_data <= zf;
					m0_result_ready <= '1';
				WHEN move_right1 => 
				WHEN move_right2 => 
					mem <= m0_result;
				WHEN move_right3 => 
					a0_a_valid <= '1';
					a0_b_valid <= '1';
					a0_a_data <= llre;
					a0_b_data <= mem;
					a0_result_ready <= '1';
				WHEN move_right4 => 
				WHEN move_right5 =>
					llre <= a0_result;
					run <= '1';
				WHEN zoom0 => 
					m0_a_valid <= '1';
					m0_b_valid <= '1';
					m0_a_data <= "0100000000111000000000000000000000000000000000000000000000000000"; --constant 24
					m0_b_data <= zf;
					m0_result_ready <= '1';
				WHEN zoom1 => 
				WHEN zoom2 => 
					mem <= m0_result;
				WHEN zoom3 => 
					a0_a_valid <= '1';
					a0_b_valid <= '1';
					a0_a_data <= llre;
					a0_b_data <= mem;
					a0_result_ready <= '1';
					m0_a_valid <= '1';
					m0_b_valid <= '1';
					m0_a_data <= "0100000000110000000000000000000000000000000000000000000000000000"; --constant 16
					m0_b_data <= zf;
					m0_result_ready <= '1';
				WHEN zoom4 => 
				WHEN zoom5 => 
					llre <= a0_result;
					mem <= m0_result;
				WHEN zoom6 => 
					a0_a_valid <= '1';
					a0_b_valid <= '1';
					a0_a_data <= llim;
					a0_b_data <= mem;
					a0_result_ready <= '1';
					m0_a_valid <= '1';
                    m0_b_valid <= '1';
                    m0_a_data <= "0011111111100000000000000000000000000000000000000000000000000000"; --constant 0.5
                    m0_b_data <= zf;
                    m0_result_ready <= '1';
				WHEN zoom7 => 
				WHEN zoom8 => 
					llim <= a0_result;
                    zf <= m0_result;
					run <= '1';
			END CASE;
	END PROCESS;

	transitions : PROCESS (jstk_btn3, jstk_left, jstk_right, jstk_up, jstk_down, clk, main_state, re_received, im_received, zf_received, picture_done, reset_in, pixel_done) IS BEGIN
		IF rising_edge(clk) THEN
 
			main_state_next <= main_state; --loop
 
			CASE main_state IS
				WHEN idle => IF (jstk_down = '1') THEN
					main_state_next <= move_down0;
			ELSIF (jstk_up = '1') THEN
				main_state_next <= move_up0;
			ELSIF (jstk_left = '1') THEN
				main_state_next <= move_left0;
			ELSIF (jstk_right = '1') THEN
				main_state_next <= move_right0;
			ELSIF (jstk_btn3 = '1') THEN
				main_state_next <= zoom0;
			END IF;
				WHEN move_up0 => 
				IF (m0_a_ready = '1' AND m0_b_ready = '1') THEN
					main_state_next <= move_up1;
				END IF;
				WHEN move_up1 => 
				IF (m0_result_valid = '1') THEN
					main_state_next <= move_up2;
				END IF;
				WHEN move_up2 => 
				main_state_next <= move_up3;
				WHEN move_up3 => 
				IF (a0_a_ready = '1' AND a0_b_ready = '1') THEN
					main_state_next <= move_up4;
				END IF;
				WHEN move_up4 => 
				IF (a0_result_valid = '1') THEN
					main_state_next <= move_up5;
				END IF;
				WHEN move_up5 => main_state_next <= send_re;
				WHEN move_down0 => 
				IF (m0_a_ready = '1' AND m0_b_ready = '1') THEN
					main_state_next <= move_down1;
				END IF;
				WHEN move_down1 => 
				IF (m0_result_valid = '1') THEN
					main_state_next <= move_down2;
				END IF;
				WHEN move_down2 => 
				main_state_next <= move_down3;
				WHEN move_down3 => 
				IF (s0_a_ready = '1' AND s0_b_ready = '1') THEN
					main_state_next <= move_down4;
				END IF;
				WHEN move_down4 => 
				IF (s0_result_valid = '1') THEN
					main_state_next <= move_down5;
				END IF;
				WHEN move_down5 => main_state_next <= send_re;
				WHEN move_left0 => 
				IF (m0_a_ready = '1' AND m0_b_ready = '1') THEN
					main_state_next <= move_left1;
				END IF;
				WHEN move_left1 => 
				IF (m0_result_valid = '1') THEN
					main_state_next <= move_left2;
				END IF;
				WHEN move_left2 => 
				main_state_next <= move_left3;
				WHEN move_left3 => 
				IF (s0_a_ready = '1' AND s0_b_ready = '1') THEN
					main_state_next <= move_left4;
				END IF;
				WHEN move_left4 => 
				IF (s0_result_valid = '1') THEN
					main_state_next <= move_left5;
				END IF;
				WHEN move_left5 => main_state_next <= send_re;
 
				WHEN move_right0 => 
				IF (m0_a_ready = '1' AND m0_b_ready = '1') THEN
					main_state_next <= move_right1;
				END IF;
				WHEN move_right1 => 
				IF (m0_result_valid = '1') THEN
					main_state_next <= move_right2;
				END IF;
				WHEN move_right2 => 
				main_state_next <= move_right3;
				WHEN move_right3 => 
				IF (a0_a_ready = '1' AND a0_b_ready = '1') THEN
					main_state_next <= move_right4;
				END IF;
				WHEN move_right4 => 
				IF (a0_result_valid = '1') THEN
					main_state_next <= move_right5;
				END IF;
				WHEN move_right5 => main_state_next <= send_re;
 
				WHEN zoom0 => IF (m0_a_ready = '1' AND m0_b_ready = '1') THEN
				    main_state_next <= zoom1;
		        END IF;
				WHEN zoom1 => IF (m0_result_valid = '1') THEN
		      	   main_state_next <= zoom2;
            	END IF;
				WHEN zoom2 => main_state_next <= zoom3;
				WHEN zoom3 => IF (a0_a_ready = '1' AND a0_b_ready = '1' AND m0_a_ready = '1' AND m0_b_ready = '1') THEN
		            main_state_next <= zoom4;
                END IF;
				WHEN zoom4 => IF (m0_result_valid = '1' AND a0_result_valid = '1') THEN
		            main_state_next <= zoom5;
                END IF;
				WHEN zoom5 => main_state_next <= zoom6;
				WHEN zoom6 => IF (a0_a_ready = '1' AND a0_b_ready = '1' AND m0_a_ready = '1' AND m0_b_ready = '1') THEN
                    main_state_next <= zoom7;
                END IF;
				WHEN zoom7 => IF (a0_result_valid = '1' and m0_result_valid = '1') THEN
                    main_state_next <= zoom8;
                END IF;
				WHEN zoom8 => main_state_next <= send_re;
				WHEN send_re => IF (re_received = '1') THEN
                    main_state_next <= send_im;
                END IF;
				WHEN send_im => IF (im_received = '1') THEN
                    main_state_next <= send_zf;
                END IF;
				WHEN send_zf => IF (zf_received = '1') THEN
                    main_state_next <= wait_for_pixel;
                END IF;
				WHEN wait_for_pixel => 
                    IF (pixel_done = '1') THEN
	                   main_state_next <= pixel_received_state;
                    END IF;
                    if (picture_done = '1') then
                        main_state_next <= idle;
                        end if;
				WHEN pixel_received_state =>
				    main_state_next <= wait_for_pixel;
				WHEN restart => 
                    main_state_next <= idle;
				WHEN OTHERS => 
            END CASE;
        END IF;
    END PROCESS;

END Behavioral;
