----------------------------------------------------------------------------------
-- Company:
-- Engineer: Meister Rados
--
-- Create Date: 02.05.2017 17:19:00
-- Design Name:
-- Module Name: math_module - Behavioral
-- Project Name: Bachelorarbeit
-- Target Devices: Artix-7
-- Tool Versions:
-- Description: Math-Modul der Bachelorarbeit
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity math_module is
	port
		(
		clk : in std_logic; --clock for math_module
		reset : in std_logic;
		data : in std_logic_vector (63 downto 0); --databus for re, im, zf values and result values
		run : in std_logic; --calc pictute
		re_ready : in std_logic;
		im_ready : in std_logic;
		zf_ready : in std_logic; --databus has valid data
		pixel_received : in std_logic;
		re_received : out std_logic := '0';
		im_received : out std_logic := '0';
		zf_received : out std_logic := '0'; --everything received
		result_data : out std_logic_vector (22 downto 0);
		pixel_done : out std_logic := '0';
		picture_done : out std_logic
	);
end math_module;

architecture Behavioral of math_module is

	--signals for math FSM
 
	type math_states is (idle, fetch_llre, fetch_llim, fetch_zf, fetch_re, fetch_im, receive_llre, receive_llim, 
	receive_zf, calc_next_pixel_im, calc_next_pixel_re, wait_for_re_value_ready, 
	wait_for_im_value_ready, wait_for_alus, pixel_ready, 
	fetch_alu0, run_alu0, fetch_alu1, run_alu1, fetch_alu2, run_alu2, fetch_alu3, run_alu3, 
	fetch_alu4, run_alu4, fetch_alu5, run_alu5, fetch_alu6, run_alu6, fetch_alu7, run_alu7, 
	inc_pixel);
	signal math_state : math_states := idle;
	signal math_state_next : math_states;

	--signals for math_module in general
	signal llre, llim, zf, current_re, current_im : std_logic_vector (63 downto 0);
	signal current_pixel, current_pixel_inc : natural range 0 to 6145;
	constant display_width : integer := 96;
	--signals for complex alus
	signal pixel_alu0 : integer range 0 to 6143;
	signal re_alu0, im_alu0 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu0 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu0 : std_logic := '0';
	signal received_alu0 : std_logic;
	signal done_alu0 : std_logic;
	signal idle_alu0 : std_logic;

	signal pixel_alu1 : integer range 0 to 6143;
	signal re_alu1, im_alu1 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu1 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu1 : std_logic := '0';
	signal received_alu1 : std_logic;
	signal done_alu1 : std_logic;
	signal idle_alu1 : std_logic;

	signal pixel_alu2 : integer range 0 to 6143;
	signal re_alu2, im_alu2 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu2 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu2 : std_logic := '0';
	signal received_alu2 : std_logic;
	signal done_alu2 : std_logic;
	signal idle_alu2 : std_logic;

	signal pixel_alu3 : integer range 0 to 6143;
	signal re_alu3, im_alu3 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu3 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu3 : std_logic := '0';
	signal received_alu3 : std_logic;
	signal done_alu3 : std_logic;
	signal idle_alu3 : std_logic;
 
	signal pixel_alu4 : integer range 0 to 6143;
	signal re_alu4, im_alu4 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu4 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu4 : std_logic := '0';
	signal received_alu4 : std_logic;
	signal done_alu4 : std_logic;
	signal idle_alu4 : std_logic;

	signal pixel_alu5 : integer range 0 to 6143;
	signal re_alu5, im_alu5 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu5 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu5 : std_logic := '0';
	signal received_alu5 : std_logic;
	signal done_alu5 : std_logic;
	signal idle_alu5 : std_logic;

	signal pixel_alu6 : integer range 0 to 6143;
	signal re_alu6, im_alu6 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu6 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu6 : std_logic := '0';
	signal received_alu6 : std_logic;
	signal done_alu6 : std_logic;
	signal idle_alu6 : std_logic;

	signal pixel_alu7 : integer range 0 to 6143;
	signal re_alu7, im_alu7 : std_logic_vector (63 downto 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	signal iteration_alu7 : std_logic_vector (9 downto 0) := "0000000000";
	signal start_alu7 : std_logic := '0';
	signal received_alu7 : std_logic;
	signal done_alu7 : std_logic;
	signal idle_alu7 : std_logic;

	--signals for adder ip core
	signal adder_a_valid, adder_b_valid, adder_result_ready : std_logic := '0';
	signal adder_a_ready, adder_b_ready, adder_result_valid : std_logic;
	signal adder_a, adder_b, adder_result : std_logic_vector (63 downto 0);

	component complex_alu
		port
			(
			re, im : in std_logic_vector (63 downto 0);
			iteration_out : out std_logic_vector (9 downto 0);
			start : in std_logic;
			clk : in std_logic;
			received : in std_logic;
			reset : in std_logic;
			done : out std_logic;
			idle : out std_logic
		);
	end component;

	component floating_point_adder
		port
			(
			aclk : in STD_LOGIC;
			s_axis_a_tvalid : in STD_LOGIC;
			s_axis_a_tready : out STD_LOGIC;
			s_axis_a_tdata : in STD_LOGIC_VECTOR(63 downto 0);
			s_axis_b_tvalid : in STD_LOGIC;
			s_axis_b_tready : out STD_LOGIC;
			s_axis_b_tdata : in STD_LOGIC_VECTOR(63 downto 0);
			m_axis_result_tvalid : out STD_LOGIC;
			m_axis_result_tready : in STD_LOGIC;
			m_axis_result_tdata : out STD_LOGIC_VECTOR(63 downto 0)
		);

	end component;

begin
	adder : floating_point_adder
	port map(
		aclk => clk, 
		s_axis_a_tvalid => adder_a_valid, 
		s_axis_a_tready => adder_a_ready, 
		s_axis_a_tdata => adder_a, 
		s_axis_b_tvalid => adder_b_valid, 
		s_axis_b_tready => adder_b_ready, 
		s_axis_b_tdata => adder_b, 
		m_axis_result_tvalid => adder_result_valid, 
		m_axis_result_tready => adder_result_ready, 
		m_axis_result_tdata => adder_result
	);

	complex_alu_0 : complex_alu
	port map(
		re => re_alu0, 
		im => im_alu0, 
		iteration_out => iteration_alu0, 
		clk => clk, 
		start => start_alu0, 
		received => received_alu0, 
		reset => reset, 
		done => done_alu0, 
		idle => idle_alu0
	);

	complex_alu_1 : complex_alu
	port map(
		re => re_alu1, 
		im => im_alu1, 
		iteration_out => iteration_alu1, 
		clk => clk, 
		start => start_alu1, 
		received => received_alu1, 
		reset => reset, 
		done => done_alu1, 
		idle => idle_alu1
	);

	complex_alu_2 : complex_alu
	port map(
		re => re_alu2, 
		im => im_alu2, 
		iteration_out => iteration_alu2, 
		clk => clk, 
		start => start_alu2, 
		received => received_alu2, 
		reset => reset, 
		done => done_alu2, 
		idle => idle_alu2
	);

	complex_alu_3 : complex_alu
	port map(
		re => re_alu3, 
		im => im_alu3, 
		iteration_out => iteration_alu3, 
		clk => clk, 
		start => start_alu3, 
		received => received_alu3, 
		reset => reset, 
		done => done_alu3, 
		idle => idle_alu3
	);
 
	complex_alu_4 : complex_alu
	port map(
		re => re_alu4, 
		im => im_alu4, 
		iteration_out => iteration_alu4, 
		clk => clk, 
		start => start_alu4, 
		received => received_alu4, 
		reset => reset, 
		done => done_alu4, 
		idle => idle_alu4
	);
 
	complex_alu_5 : complex_alu
	port map(
		re => re_alu5, 
		im => im_alu5, 
		iteration_out => iteration_alu5, 
		clk => clk, 
		start => start_alu5, 
		received => received_alu5, 
		reset => reset, 
		done => done_alu5, 
		idle => idle_alu5
	);
 
	complex_alu_6 : complex_alu
	port map(
		re => re_alu6, 
		im => im_alu6, 
		iteration_out => iteration_alu6, 
		clk => clk, 
		start => start_alu6, 
		received => received_alu6, 
		reset => reset, 
		done => done_alu6, 
		idle => idle_alu6
	);
 
	complex_alu_7 : complex_alu
	port map(
		re => re_alu7, 
		im => im_alu7, 
		iteration_out => iteration_alu7, 
		clk => clk, 
		start => start_alu7, 
		received => received_alu7, 
		reset => reset, 
		done => done_alu7, 
		idle => idle_alu7
	);

	--next state process
	next_state : process (clk) is begin
		if rising_edge(clk) then
			if (reset = '1') then
				math_state <= idle;
			else
				math_state <= math_state_next;
			end if;
		end if;
	end process;

	--transitions
	outputs : process (math_state)
		is begin
		re_received <= '0';
		im_received <= '0';
		zf_received <= '0';
		picture_done <= '0';
		pixel_done <= '0';
		start_alu0 <= '0';
		start_alu1 <= '0';
		start_alu2 <= '0';
		start_alu3 <= '0';
		start_alu4 <= '0';
		start_alu5 <= '0';
		start_alu6 <= '0';
		start_alu7 <= '0';
		received_alu0 <= '0';
		received_alu1 <= '0';
		received_alu2 <= '0';
		received_alu3 <= '0';
		received_alu4 <= '0';
		received_alu5 <= '0';
		received_alu6 <= '0';
		received_alu7 <= '0';
		adder_a_valid <= '0';
		adder_b_valid <= '0';
		adder_result_ready <= '0';
		adder_a <= "0000000000000000000000000000000000000000000000000000000000000000";
		adder_b <= "0000000000000000000000000000000000000000000000000000000000000000";
		pixel_alu0 <= pixel_alu0;
		pixel_alu1 <= pixel_alu1;
		pixel_alu2 <= pixel_alu2;
		pixel_alu3 <= pixel_alu3;
		pixel_alu4 <= pixel_alu4;
		pixel_alu5 <= pixel_alu5;
		pixel_alu6 <= pixel_alu6;
		pixel_alu7 <= pixel_alu7; 
		re_alu0 <= re_alu0;
		im_alu0 <= im_alu0;
		re_alu1 <= re_alu1;
		im_alu1 <= im_alu1;
		re_alu2 <= re_alu2;
		im_alu2 <= im_alu2;
		re_alu3 <= re_alu3;
		im_alu3 <= im_alu3;
		re_alu4 <= re_alu4;
		im_alu4 <= im_alu4;
		re_alu5 <= re_alu5;
		im_alu5 <= im_alu5;
		re_alu6 <= re_alu6;
		im_alu6 <= im_alu6;
		re_alu7 <= re_alu7;
		im_alu7 <= im_alu7;
		current_re <= current_re;
		current_im <= current_im;
		llre <= llre;
		llim <= llim;
		case math_state is
			when idle => 
				picture_done <= '1';
				current_pixel <= 0;
				current_pixel_inc <= 1;
			when receive_llre => 
			when fetch_llre => 
				llre <= data;
				current_re <= data;
				re_received <= '1';
			when receive_llim => 
			when fetch_llim => 
				llim <= data;
				current_im <= data;
				im_received <= '1';
			when receive_zf => 
			when fetch_zf => 
				zf <= data;
				zf_received <= '1';
			when calc_next_pixel_im => --calc_next_pixel_re/im
				adder_a <= current_im;
				adder_a_valid <= '1';
				adder_b <= zf;
				adder_b_valid <= '1';
				adder_result_ready <= '1';
				current_re <= llre;
			when calc_next_pixel_re => --calc_next_pixel_re/im
				adder_a <= current_re;
				adder_a_valid <= '1';
				adder_b <= zf;
				adder_b_valid <= '1';
				adder_result_ready <= '1';
			when wait_for_re_value_ready => 
			when wait_for_im_value_ready => 
			when fetch_re => current_re <= adder_result;
			when fetch_im => current_im <= adder_result;
			when pixel_ready => 
			when run_alu0 => 
				re_alu0 <= current_re;
				im_alu0 <= current_im;
				start_alu0 <= '1';
				pixel_alu0 <= current_pixel;
			when run_alu1 => 
				re_alu1 <= current_re;
				im_alu1 <= current_im;
				start_alu1 <= '1';
				pixel_alu1 <= current_pixel;
			when run_alu2 => 
				re_alu2 <= current_re;
				im_alu2 <= current_im;
				start_alu2 <= '1';
				pixel_alu2 <= current_pixel;
			when run_alu3 => 
				re_alu3 <= current_re;
				im_alu3 <= current_im;
				start_alu3 <= '1';
				pixel_alu3 <= current_pixel;
			when run_alu4 => 
				re_alu4 <= current_re;
				im_alu4 <= current_im;
				start_alu4 <= '1';
				pixel_alu4 <= current_pixel;
			when run_alu5 => 
				re_alu5 <= current_re;
				im_alu5 <= current_im;
				start_alu5 <= '1';
				pixel_alu5 <= current_pixel;
			when run_alu6 => 
				re_alu6 <= current_re;
				im_alu6 <= current_im;
				start_alu6 <= '1';
				pixel_alu6 <= current_pixel;
			when run_alu7 => 
				re_alu7 <= current_re;
				im_alu7 <= current_im;
				start_alu7 <= '1';
				pixel_alu7 <= current_pixel;
			when inc_pixel => 
				current_pixel <= current_pixel_inc;
			when fetch_alu0 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu0;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu0, 13));
				received_alu0 <= '1';
			when fetch_alu1 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu1;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu1, 13));
				received_alu1 <= '1';
			when fetch_alu2 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu2;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu2, 13));
				received_alu2 <= '1';
			when fetch_alu3 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu3;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu3, 13));
				received_alu3 <= '1';
			when fetch_alu4 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu4;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu4, 13));
				received_alu4 <= '1';
			when fetch_alu5 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu5;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu5, 13));
				received_alu5 <= '1';
			when fetch_alu6 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu6;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu6, 13));
				received_alu6 <= '1';
			when fetch_alu7 => 
				pixel_done <= '1';
				result_data(22 downto 13) <= iteration_alu7;
				result_data(12 downto 0) <= std_logic_vector(to_unsigned(pixel_alu7, 13));
				received_alu7 <= '1';
			when wait_for_alus => 
		end case;
		current_pixel_inc <= current_pixel + 1;
	end process outputs;

	transitions : process (clk) is begin
		if rising_edge(clk) then
			math_state_next <= math_state; --loop
			case math_state is
				when idle => 
					if (run = '1') then
						math_state_next <= receive_llre;
					end if;
				when receive_llre => 
					if (re_ready = '1') then
						math_state_next <= fetch_llre;
					end if;
				when fetch_llre => 
					math_state_next <= receive_llim;
				when receive_llim => 
					if (im_ready = '1') then
						math_state_next <= fetch_llim;
					end if;
				when fetch_llim => 
					math_state_next <= receive_zf;
				when receive_zf => 
					if (zf_ready = '1') then
						math_state_next <= fetch_zf;
					end if;
				when fetch_zf => 
					math_state_next <= pixel_ready;
				when calc_next_pixel_re => if (adder_a_ready = '1' and adder_b_ready = '1') then
					math_state_next <= wait_for_re_value_ready;
				end if;
				when calc_next_pixel_im => 
					if (adder_a_ready = '1' and adder_b_ready = '1') then
						math_state_next <= wait_for_im_value_ready;
					end if;
				when wait_for_re_value_ready => 
					if (adder_result_valid = '1') then
						math_state_next <= fetch_re;
					end if;
				when wait_for_im_value_ready => 
					if (adder_result_valid = '1') then
						math_state_next <= fetch_im;
					end if;
				when fetch_re => 
					math_state_next <= pixel_ready;
				when fetch_im => 
					math_state_next <= pixel_ready;
				when pixel_ready => 
					if (done_alu0 = '1') then --find idle alus and give them work
						math_state_next <= fetch_alu0;
					elsif (idle_alu0 = '1') then
						math_state_next <= run_alu0;
					elsif (done_alu1 = '1') then
						math_state_next <= fetch_alu1;
					elsif (idle_alu1 = '1') then
						math_state_next <= run_alu1;
					elsif (done_alu2 = '1') then
						math_state_next <= fetch_alu2;
					elsif (idle_alu2 = '1') then
						math_state_next <= run_alu2;
					elsif (done_alu3 = '1') then
						math_state_next <= fetch_alu3;
					elsif (idle_alu3 = '1') then
						math_state_next <= run_alu3;
					elsif (done_alu4 = '1') then
						math_state_next <= fetch_alu4;
					elsif (idle_alu4 = '1') then
						math_state_next <= run_alu4;
					elsif (done_alu5 = '1') then
						math_state_next <= fetch_alu5;
					elsif (idle_alu5 = '1') then
						math_state_next <= run_alu5;
					elsif (done_alu6 = '1') then
						math_state_next <= fetch_alu6;
					elsif (idle_alu6 = '1') then
						math_state_next <= run_alu6;
					elsif (done_alu7 = '1') then
						math_state_next <= fetch_alu7;
					elsif (idle_alu7 = '1') then
						math_state_next <= run_alu7;
					end if;
				when inc_pixel => 
					if ((current_pixel mod display_width = 0) and current_pixel /= 6144) then --line break, increase im value
						math_state_next <= calc_next_pixel_im;
					elsif ((current_pixel mod display_width /= 0) and current_pixel /= 6144) then
						math_state_next <= calc_next_pixel_re;
					else
						math_state_next <= wait_for_alus;
					end if;
				when run_alu0 | run_alu1 | run_alu2 | run_alu3 | run_alu4 | run_alu5 | run_alu6 | run_alu7 => 
					math_state_next <= inc_pixel;
				when fetch_alu0 | fetch_alu1 | fetch_alu2 | fetch_alu3 | fetch_alu4 | fetch_alu5 | fetch_alu6 | fetch_alu7 => 
					if (current_pixel = 6144) then
						if (pixel_received = '1') then
							math_state_next <= wait_for_alus;
						end if;
					elsif (current_pixel < 6144) then
						if (pixel_received = '1') then
							math_state_next <= pixel_ready;
						end if;
					end if;
				when wait_for_alus => 
					if (done_alu0 = '1') then
						math_state_next <= fetch_alu0;
					elsif (done_alu1 = '1') then
						math_state_next <= fetch_alu1;
					elsif (done_alu2 = '1') then
						math_state_next <= fetch_alu2;
					elsif (done_alu3 = '1') then
						math_state_next <= fetch_alu3;
					elsif (done_alu4 = '1') then
						math_state_next <= fetch_alu4;
					elsif (done_alu5 = '1') then
						math_state_next <= fetch_alu5;
					elsif (done_alu6 = '1') then
						math_state_next <= fetch_alu6;
					elsif (done_alu7 = '1') then
						math_state_next <= fetch_alu7;
					end if;
					if ((idle_alu0 = '1') and (idle_alu1 = '1') and (idle_alu2 = '1') and (idle_alu3 = '1') and (idle_alu4 = '1') and (idle_alu5 = '1') and (idle_alu6 = '1') and (idle_alu7 = '1')) then
						math_state_next <= idle;
					end if;
			end case;
		end if;
	end process transitions;

end Behavioral;
 
