----------------------------------------------------------------------------------
-- Company:
-- Engineer: Meister Rados
--
-- Create Date: 02.05.2017 17:19:00
-- Design Name:
-- Module Name: math_module - Behavioral
-- Project Name: Bachelorarbeit
-- Target Devices: Artix-7
-- Tool Versions:
-- Description: Math-Modul der Bachelorarbeit
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;

ENTITY math_module IS
	PORT 
	(
		clk            : IN std_logic; --clock for math_module
		reset          : IN std_logic;
		data           : IN std_logic_vector (63 DOWNTO 0); --databus for re, im, zf values and result values
		run            : IN std_logic; --calc pictute
		re_ready       : IN std_logic;
		im_ready       : IN std_logic;
		zf_ready       : IN std_logic; --databus has valid data
		pixel_received : IN std_logic;
		re_received    : OUT std_logic := '0';
		im_received    : OUT std_logic := '0';
		zf_received    : OUT std_logic := '0'; --everything received
		result_data    : OUT std_logic_vector (22 DOWNTO 0);
		pixel_done     : OUT std_logic := '0';
		picture_done   : OUT std_logic
	);
END math_module;

ARCHITECTURE Behavioral OF math_module IS

	--signals for math FSM
	
	type math_states is (idle, fetch_llre, fetch_llim, fetch_zf, fetch_re, fetch_im, receive_llre, receive_llim,
	receive_zf, calc_next_pixel_im, calc_next_pixel_re, wait_for_re_value_ready,
	wait_for_im_value_ready, wait_for_alus, pixel_ready,
	fetch_alu0, run_alu0,
	inc_pixel);
	SIGNAL math_state      : math_states := idle;
	SIGNAL math_state_next : math_states;

	--signals for math_module in general
	SIGNAL llre, llim, zf, current_re, current_im : std_logic_vector (63 DOWNTO 0);
	SIGNAL current_pixel, current_pixel_inc       : NATURAL RANGE 0 TO 6145;
	CONSTANT display_width                        : INTEGER := 96;
	--signals for complex alus
	SIGNAL pixel_alu0       : INTEGER RANGE 0 TO 6143;
    SIGNAL re_alu0, im_alu0 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
    SIGNAL iteration_alu0   : std_logic_vector (9 DOWNTO 0) := "0000000000";
    SIGNAL start_alu0       : std_logic := '0';
    SIGNAL received_alu0    : std_logic;
    SIGNAL done_alu0        : std_logic;
    SIGNAL idle_alu0        : std_logic;

	--signals for adder ip core
	SIGNAL adder_a_valid, adder_b_valid, adder_result_ready : std_logic := '0';
	SIGNAL adder_a_ready, adder_b_ready, adder_result_valid : std_logic;
	SIGNAL adder_a, adder_b, adder_result                   : std_logic_vector (63 DOWNTO 0);

	COMPONENT complex_alu
		PORT 
		(
			re, im        : IN std_logic_vector (63 DOWNTO 0);
			iteration_out : OUT std_logic_vector (9 DOWNTO 0);
			start         : IN std_logic;
			clk           : IN std_logic;
			received      : IN std_logic;
			reset         : IN std_logic;
			done          : OUT std_logic;
			idle          : OUT std_logic
		);
	END COMPONENT;

	COMPONENT floating_point_adder
		PORT 
		(
			aclk                 : IN STD_LOGIC;
			s_axis_a_tvalid      : IN STD_LOGIC;
			s_axis_a_tready      : OUT STD_LOGIC;
			s_axis_a_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid      : IN STD_LOGIC;
			s_axis_b_tready      : OUT STD_LOGIC;
			s_axis_b_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata  : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);

	END COMPONENT;

BEGIN

	adder : floating_point_adder
	PORT MAP
	(
		aclk                 => clk, 
		s_axis_a_tvalid      => adder_a_valid, 
		s_axis_a_tready      => adder_a_ready, 
		s_axis_a_tdata       => adder_a, 
		s_axis_b_tvalid      => adder_b_valid, 
		s_axis_b_tready      => adder_b_ready, 
		s_axis_b_tdata       => adder_b, 
		m_axis_result_tvalid => adder_result_valid, 
		m_axis_result_tready => adder_result_ready, 
		m_axis_result_tdata  => adder_result
	);

	complex_alu_0 : complex_alu
	PORT MAP
	(
		re            => re_alu0, 
		im            => im_alu0, 
		iteration_out => iteration_alu0, 
		clk           => clk, 
		start         => start_alu0, 
		received      => received_alu0, 
		reset         => reset, 
		done          => done_alu0, 
		idle          => idle_alu0
	);
 
	--next state process
	next_state : PROCESS (clk) IS BEGIN
		IF rising_edge(clk) THEN
			IF (reset = '1') THEN
				math_state <= idle;
			ELSE
				math_state <= math_state_next;
			END IF;
		END IF;
	END PROCESS;

	--transitions
	outputs : PROCESS (math_state)
		IS BEGIN
		re_received  <= '0';
		im_received  <= '0';
		zf_received  <= '0';
		picture_done <= '0';
		pixel_done   <= '0';
		start_alu0   <= '0';
		received_alu0 <= '0';
		adder_a_valid      <= '0';
		adder_b_valid      <= '0';
		adder_result_ready <= '0';
		adder_a            <= "0000000000000000000000000000000000000000000000000000000000000000";
		adder_b            <= "0000000000000000000000000000000000000000000000000000000000000000";
		pixel_alu0         <= pixel_alu0;
		re_alu0 <= re_alu0;
		im_alu0 <= im_alu0;
		current_re <= current_re;
		current_im <= current_im;
		llre       <= llre; 
		llim       <= llim;
		CASE math_state IS
			WHEN idle => 
				picture_done      <= '1';
				current_pixel     <= 0;
				current_pixel_inc <= 1;
			WHEN receive_llre => 
			WHEN fetch_llre   => 
				llre        <= data;
				current_re  <= data;
				re_received <= '1';
			WHEN receive_llim => 
			WHEN fetch_llim   => 
				llim        <= data;
				current_im  <= data;
				im_received <= '1';
			WHEN receive_zf => 
			WHEN fetch_zf   => 
				zf          <= data;
				zf_received <= '1';
			WHEN calc_next_pixel_im => --calc_next_pixel_re/im
				adder_a            <= current_im;
				adder_a_valid      <= '1';
				adder_b            <= zf;
				adder_b_valid      <= '1';
				adder_result_ready <= '1';
				current_re         <= llre;
			WHEN calc_next_pixel_re => --calc_next_pixel_re/im
				adder_a            <= current_re;
				adder_a_valid      <= '1';
				adder_b            <= zf;
				adder_b_valid      <= '1';
				adder_result_ready <= '1';
			WHEN wait_for_re_value_ready => 
			WHEN wait_for_im_value_ready => 
			WHEN fetch_re => current_re <= adder_result;
			WHEN fetch_im => current_im <= adder_result;
			WHEN pixel_ready => 
			WHEN run_alu0    => 
				re_alu0    <= current_re;
				im_alu0    <= current_im;
				start_alu0 <= '1';
				pixel_alu0 <= current_pixel;
			WHEN inc_pixel => 
				current_pixel <= current_pixel_inc;
			WHEN fetch_alu0 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu0;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu0, 13));
				received_alu0             <= '1';
			WHEN wait_for_alus => 
		END CASE;
		current_pixel_inc <= current_pixel + 1; 
	END PROCESS outputs;

	transitions:process (clk) is begin
		IF rising_edge(clk) THEN
			math_state_next <= math_state; --loop
			CASE math_state IS
				WHEN idle => 
					IF (run = '1') THEN
						math_state_next <= receive_llre;
					END IF;
				WHEN receive_llre => 
					IF (re_ready = '1') THEN
						math_state_next <= fetch_llre;
					END IF;
				WHEN fetch_llre => 
					math_state_next <= receive_llim;
				WHEN receive_llim => 
					IF (im_ready = '1') THEN
						math_state_next <= fetch_llim;
					END IF;
				WHEN fetch_llim => 
					math_state_next <= receive_zf;
				WHEN receive_zf => 
					IF (zf_ready = '1') THEN
						math_state_next <= fetch_zf;
					END IF;
				WHEN fetch_zf => 
					math_state_next <= pixel_ready;
				WHEN calc_next_pixel_re => IF (adder_a_ready = '1' AND adder_b_ready = '1') THEN
					math_state_next <= wait_for_re_value_ready;
			        END IF;
				WHEN calc_next_pixel_im => 
				IF (adder_a_ready = '1' AND adder_b_ready = '1') THEN
					math_state_next <= wait_for_im_value_ready;
				END IF;
				WHEN wait_for_re_value_ready => 
				IF (adder_result_valid = '1') THEN
					math_state_next <= fetch_re;
				END IF;
				WHEN wait_for_im_value_ready => 
				IF (adder_result_valid = '1') THEN
					math_state_next <= fetch_im;
				END IF;
				WHEN fetch_re => 
				math_state_next <= pixel_ready;
				WHEN fetch_im => 
				math_state_next <= pixel_ready;
				WHEN pixel_ready => 
				IF (done_alu0 = '1') THEN --find idle alus and give them work
					math_state_next <= fetch_alu0; 
				ELSIF (idle_alu0 = '1') THEN
					math_state_next <= run_alu0;
				END IF;
				WHEN inc_pixel => 
				IF ((current_pixel MOD display_width = 0) AND current_pixel /= 6144) THEN --line break, increase im value
					math_state_next <= calc_next_pixel_im;
				ELSIF ((current_pixel MOD display_width /= 0) AND current_pixel /= 6144) THEN
					math_state_next <= calc_next_pixel_re;
				ELSE
					math_state_next <= wait_for_alus;
				END IF;
				WHEN run_alu0 => 
				math_state_next <= inc_pixel;
				WHEN fetch_alu0 => 
				IF (current_pixel = 6144) THEN
					IF (pixel_received = '1') THEN
						math_state_next <= wait_for_alus;
					END IF;
				ELSIF (current_pixel < 6144) THEN
					IF (pixel_received = '1') THEN
						math_state_next <= pixel_ready;
					END IF;
				END IF;
				WHEN wait_for_alus => 
				IF (done_alu0 = '1') THEN
					math_state_next <= fetch_alu0;
				END IF;
				if (idle_alu0 = '1') then
					math_state_next <= idle;
				END IF;
		END CASE;
	END IF;
END PROCESS transitions;

END Behavioral;
