----------------------------------------------------------------------------------
-- Company:
-- Engineer: Meister Rados
--
-- Create Date: 02.05.2017 17:19:00
-- Design Name:
-- Module Name: math_module - Behavioral
-- Project Name: Bachelorarbeit
-- Target Devices: Artix-7
-- Tool Versions:
-- Description: Math-Modul der Bachelorarbeit
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;

ENTITY math_module IS
	PORT 
	(
		clk            : IN std_logic; --clock for math_module
		reset          : IN std_logic;
		data           : IN std_logic_vector (63 DOWNTO 0); --databus for re, im, zf values and result values
		run            : IN std_logic; --calc pictute
		re_ready       : IN std_logic;
		im_ready       : IN std_logic;
		zf_ready       : IN std_logic; --databus has valid data
		pixel_received : IN std_logic;
		re_received    : OUT std_logic := '0';
		im_received    : OUT std_logic := '0';
		zf_received    : OUT std_logic := '0'; --everything received
		result_data    : OUT std_logic_vector (22 DOWNTO 0);
		pixel_done     : OUT std_logic := '0';
		picture_done   : OUT std_logic
	);
END math_module;

ARCHITECTURE Behavioral OF math_module IS

	--signals for math FSM

	TYPE math_states IS (idle, fetch_llre, fetch_llim, fetch_zf, fetch_re, fetch_im, receive_llre, receive_llim, 
	receive_zf, calc_next_pixel_im, calc_next_pixel_re, wait_for_re_value_ready, 
	wait_for_im_value_ready, wait_for_alus, pixel_ready, 
	fetch_alu0, run_alu0, fetch_alu1, run_alu1, fetch_alu2, run_alu2, fetch_alu3, run_alu3, 
	fetch_alu4, run_alu4, fetch_alu5, run_alu5, fetch_alu6, run_alu6, fetch_alu7, run_alu7, 
	fetch_alu8, run_alu8, fetch_alu9, run_alu9, fetch_alu10, run_alu10, fetch_alu11, run_alu11, 
	fetch_alu12, run_alu12, fetch_alu13, run_alu13, fetch_alu14, run_alu14, fetch_alu15, run_alu15, 
	inc_pixel);
	SIGNAL math_state      : math_states := idle;
	SIGNAL math_state_next : math_states;

	--signals for math_module in general
	SIGNAL llre, llim, zf, current_re, current_im : std_logic_vector (63 DOWNTO 0);
	SIGNAL current_pixel, current_pixel_inc       : NATURAL RANGE 0 TO 6145;
	CONSTANT display_width                        : INTEGER := 96;
	--signals for complex alus
	SIGNAL pixel_alu0         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu0, im_alu0   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu0     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu0         : std_logic := '0';
	SIGNAL received_alu0      : std_logic;
	SIGNAL done_alu0          : std_logic;
	SIGNAL idle_alu0          : std_logic;

	SIGNAL pixel_alu1         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu1, im_alu1   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu1     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu1         : std_logic := '0';
	SIGNAL received_alu1      : std_logic;
	SIGNAL done_alu1          : std_logic;
	SIGNAL idle_alu1          : std_logic;

	SIGNAL pixel_alu2         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu2, im_alu2   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu2     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu2         : std_logic := '0';
	SIGNAL received_alu2      : std_logic;
	SIGNAL done_alu2          : std_logic;
	SIGNAL idle_alu2          : std_logic;

	SIGNAL pixel_alu3         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu3, im_alu3   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu3     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu3         : std_logic := '0';
	SIGNAL received_alu3      : std_logic;
	SIGNAL done_alu3          : std_logic;
	SIGNAL idle_alu3          : std_logic;

	SIGNAL pixel_alu4         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu4, im_alu4   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu4     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu4         : std_logic := '0';
	SIGNAL received_alu4      : std_logic;
	SIGNAL done_alu4          : std_logic;
	SIGNAL idle_alu4          : std_logic;

	SIGNAL pixel_alu5         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu5, im_alu5   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu5     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu5         : std_logic := '0';
	SIGNAL received_alu5      : std_logic;
	SIGNAL done_alu5          : std_logic;
	SIGNAL idle_alu5          : std_logic;

	SIGNAL pixel_alu6         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu6, im_alu6   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu6     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu6         : std_logic := '0';
	SIGNAL received_alu6      : std_logic;
	SIGNAL done_alu6          : std_logic;
	SIGNAL idle_alu6          : std_logic;

	SIGNAL pixel_alu7         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu7, im_alu7   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu7     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu7         : std_logic := '0';
	SIGNAL received_alu7      : std_logic;
	SIGNAL done_alu7          : std_logic;
	SIGNAL idle_alu7          : std_logic;
 
	SIGNAL pixel_alu8         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu8, im_alu8   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu8     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu8         : std_logic := '0';
	SIGNAL received_alu8      : std_logic;
	SIGNAL done_alu8          : std_logic;
	SIGNAL idle_alu8          : std_logic;
 
	SIGNAL pixel_alu9         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu9, im_alu9   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu9     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu9         : std_logic := '0';
	SIGNAL received_alu9      : std_logic;
	SIGNAL done_alu9          : std_logic;
	SIGNAL idle_alu9          : std_logic;
 
	SIGNAL pixel_alu10        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu10, im_alu10 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu10    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu10        : std_logic := '0';
	SIGNAL received_alu10     : std_logic;
	SIGNAL done_alu10         : std_logic;
	SIGNAL idle_alu10         : std_logic;
 
	SIGNAL pixel_alu11        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu11, im_alu11 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu11    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu11        : std_logic := '0';
	SIGNAL received_alu11     : std_logic;
	SIGNAL done_alu11         : std_logic;
	SIGNAL idle_alu11         : std_logic;
 
	SIGNAL pixel_alu12        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu12, im_alu12 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu12    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu12        : std_logic := '0';
	SIGNAL received_alu12     : std_logic;
	SIGNAL done_alu12         : std_logic;
	SIGNAL idle_alu12         : std_logic;
 
	SIGNAL pixel_alu13        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu13, im_alu13 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu13    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu13        : std_logic := '0';
	SIGNAL received_alu13     : std_logic;
	SIGNAL done_alu13         : std_logic;
	SIGNAL idle_alu13         : std_logic;
 
	SIGNAL pixel_alu14        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu14, im_alu14 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu14    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu14        : std_logic := '0';
	SIGNAL received_alu14     : std_logic;
	SIGNAL done_alu14         : std_logic;
	SIGNAL idle_alu14         : std_logic;
 
	SIGNAL pixel_alu15        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu15, im_alu15 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu15    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu15        : std_logic := '0';
	SIGNAL received_alu15     : std_logic;
	SIGNAL done_alu15         : std_logic;
	SIGNAL idle_alu15         : std_logic;

	--signals for adder ip core
	SIGNAL adder_a_valid, adder_b_valid, adder_result_ready : std_logic := '0';
	SIGNAL adder_a_ready, adder_b_ready, adder_result_valid : std_logic;
	SIGNAL adder_a, adder_b, adder_result                   : std_logic_vector (63 DOWNTO 0);

	COMPONENT complex_alu
		PORT 
		(
			re, im        : IN std_logic_vector (63 DOWNTO 0);
			iteration_out : OUT std_logic_vector (9 DOWNTO 0);
			start         : IN std_logic;
			clk           : IN std_logic;
			received      : IN std_logic;
			reset         : IN std_logic;
			done          : OUT std_logic;
			idle          : OUT std_logic
		);
	END COMPONENT;

	COMPONENT floating_point_adder
		PORT 
		(
			aclk                 : IN STD_LOGIC;
			s_axis_a_tvalid      : IN STD_LOGIC;
			s_axis_a_tready      : OUT STD_LOGIC;
			s_axis_a_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid      : IN STD_LOGIC;
			s_axis_b_tready      : OUT STD_LOGIC;
			s_axis_b_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata  : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);

	END COMPONENT;

BEGIN
	adder : floating_point_adder
	PORT MAP
	(
		aclk                 => clk, 
		s_axis_a_tvalid      => adder_a_valid, 
		s_axis_a_tready      => adder_a_ready, 
		s_axis_a_tdata       => adder_a, 
		s_axis_b_tvalid      => adder_b_valid, 
		s_axis_b_tready      => adder_b_ready, 
		s_axis_b_tdata       => adder_b, 
		m_axis_result_tvalid => adder_result_valid, 
		m_axis_result_tready => adder_result_ready, 
		m_axis_result_tdata  => adder_result
	);

	complex_alu_0 : complex_alu
	PORT MAP
	(
		re            => re_alu0, 
		im            => im_alu0, 
		iteration_out => iteration_alu0, 
		clk           => clk, 
		start         => start_alu0, 
		received      => received_alu0, 
		reset         => reset, 
		done          => done_alu0, 
		idle          => idle_alu0
	);

	complex_alu_1 : complex_alu
	PORT MAP
	(
		re            => re_alu1, 
		im            => im_alu1, 
		iteration_out => iteration_alu1, 
		clk           => clk, 
		start         => start_alu1, 
		received      => received_alu1, 
		reset         => reset, 
		done          => done_alu1, 
		idle          => idle_alu1
	);

	complex_alu_2 : complex_alu
	PORT MAP
	(
		re            => re_alu2, 
		im            => im_alu2, 
		iteration_out => iteration_alu2, 
		clk           => clk, 
		start         => start_alu2, 
		received      => received_alu2, 
		reset         => reset, 
		done          => done_alu2, 
		idle          => idle_alu2
	);

	complex_alu_3 : complex_alu
	PORT MAP
	(
		re            => re_alu3, 
		im            => im_alu3, 
		iteration_out => iteration_alu3, 
		clk           => clk, 
		start         => start_alu3, 
		received      => received_alu3, 
		reset         => reset, 
		done          => done_alu3, 
		idle          => idle_alu3
	);

	complex_alu_4 : complex_alu
	PORT MAP
	(
		re            => re_alu4, 
		im            => im_alu4, 
		iteration_out => iteration_alu4, 
		clk           => clk, 
		start         => start_alu4, 
		received      => received_alu4, 
		reset         => reset, 
		done          => done_alu4, 
		idle          => idle_alu4
	);

	complex_alu_5 : complex_alu
	PORT MAP
	(
		re            => re_alu5, 
		im            => im_alu5, 
		iteration_out => iteration_alu5, 
		clk           => clk, 
		start         => start_alu5, 
		received      => received_alu5, 
		reset         => reset, 
		done          => done_alu5, 
		idle          => idle_alu5
	);

	complex_alu_6 : complex_alu
	PORT MAP
	(
		re            => re_alu6, 
		im            => im_alu6, 
		iteration_out => iteration_alu6, 
		clk           => clk, 
		start         => start_alu6, 
		received      => received_alu6, 
		reset         => reset, 
		done          => done_alu6, 
		idle          => idle_alu6
	);

	complex_alu_7 : complex_alu
	PORT MAP
	(
		re            => re_alu7, 
		im            => im_alu7, 
		iteration_out => iteration_alu7, 
		clk           => clk, 
		start         => start_alu7, 
		received      => received_alu7, 
		reset         => reset, 
		done          => done_alu7, 
		idle          => idle_alu7
	);
	complex_alu_8 : complex_alu
	PORT MAP
	(
		re            => re_alu8, 
		im            => im_alu8, 
		iteration_out => iteration_alu8, 
		clk           => clk, 
		start         => start_alu8, 
		received      => received_alu8, 
		reset         => reset, 
		done          => done_alu8, 
		idle          => idle_alu8
	);

	complex_alu_9 : complex_alu
	PORT MAP
	(
		re            => re_alu9, 
		im            => im_alu9, 
		iteration_out => iteration_alu9, 
		clk           => clk, 
		start         => start_alu9, 
		received      => received_alu9, 
		reset         => reset, 
		done          => done_alu9, 
		idle          => idle_alu9
	);

	complex_alu_10 : complex_alu
	PORT MAP
	(
		re            => re_alu10, 
		im            => im_alu10, 
		iteration_out => iteration_alu10, 
		clk           => clk, 
		start         => start_alu10, 
		received      => received_alu10, 
		reset         => reset, 
		done          => done_alu10, 
		idle          => idle_alu10
	);

	complex_alu_11 : complex_alu
	PORT MAP
	(
		re            => re_alu11, 
		im            => im_alu11, 
		iteration_out => iteration_alu11, 
		clk           => clk, 
		start         => start_alu11, 
		received      => received_alu11, 
		reset         => reset, 
		done          => done_alu11, 
		idle          => idle_alu11
	);

	complex_alu_12 : complex_alu
	PORT MAP
	(
		re            => re_alu12, 
		im            => im_alu12, 
		iteration_out => iteration_alu12, 
		clk           => clk, 
		start         => start_alu12, 
		received      => received_alu12, 
		reset         => reset, 
		done          => done_alu12, 
		idle          => idle_alu12
	);

	complex_alu_13 : complex_alu
	PORT MAP
	(
		re            => re_alu13, 
		im            => im_alu13, 
		iteration_out => iteration_alu13, 
		clk           => clk, 
		start         => start_alu13, 
		received      => received_alu13, 
		reset         => reset, 
		done          => done_alu13, 
		idle          => idle_alu13
	);

	complex_alu_14 : complex_alu
	PORT MAP
	(
		re            => re_alu14, 
		im            => im_alu14, 
		iteration_out => iteration_alu14, 
		clk           => clk, 
		start         => start_alu14, 
		received      => received_alu14, 
		reset         => reset, 
		done          => done_alu14, 
		idle          => idle_alu14
	);

	complex_alu_15 : complex_alu
	PORT MAP
	(
		re            => re_alu15, 
		im            => im_alu15, 
		iteration_out => iteration_alu15, 
		clk           => clk, 
		start         => start_alu15, 
		received      => received_alu15, 
		reset         => reset, 
		done          => done_alu15, 
		idle          => idle_alu15
	);

	--next state process
	next_state : PROCESS (clk) IS BEGIN
		IF rising_edge(clk) THEN
			IF (reset = '1') THEN
				math_state <= idle;
			ELSE
				math_state <= math_state_next;
			END IF;
		END IF;
	END PROCESS;

	--transitions
	outputs : PROCESS (math_state)
		IS BEGIN
		re_received        <= '0';
		im_received        <= '0';
		zf_received        <= '0';
		picture_done       <= '0';
		pixel_done         <= '0';
		start_alu0         <= '0';
		start_alu1         <= '0';
		start_alu2         <= '0';
		start_alu3         <= '0';
		start_alu4         <= '0';
		start_alu5         <= '0';
		start_alu6         <= '0';
		start_alu7         <= '0';
		received_alu0      <= '0';
		received_alu1      <= '0';
		received_alu2      <= '0';
		received_alu3      <= '0';
		received_alu4      <= '0';
		received_alu5      <= '0';
		received_alu6      <= '0';
		received_alu7      <= '0';
		start_alu8         <= '0';
		start_alu9         <= '0';
		start_alu10        <= '0';
		start_alu11        <= '0';
		start_alu12        <= '0';
		start_alu13        <= '0';
		start_alu14        <= '0';
		start_alu15        <= '0';
		received_alu8      <= '0';
		received_alu9      <= '0';
		received_alu10     <= '0';
		received_alu11     <= '0';
		received_alu12     <= '0';
		received_alu13     <= '0';
		received_alu14     <= '0';
		received_alu15     <= '0';
		adder_a_valid      <= '0';
		adder_b_valid      <= '0';
		adder_result_ready <= '0';
		adder_a            <= "0000000000000000000000000000000000000000000000000000000000000000";
		adder_b            <= "0000000000000000000000000000000000000000000000000000000000000000";
		pixel_alu0         <= pixel_alu0;
		pixel_alu1         <= pixel_alu1;
		pixel_alu2         <= pixel_alu2;
		pixel_alu3         <= pixel_alu3;
		pixel_alu4         <= pixel_alu4;
		pixel_alu5         <= pixel_alu5;
		pixel_alu6         <= pixel_alu6;
		pixel_alu7         <= pixel_alu7;
		re_alu0            <= re_alu0;
		im_alu0            <= im_alu0;
		re_alu1            <= re_alu1;
		im_alu1            <= im_alu1;
		re_alu2            <= re_alu2;
		im_alu2            <= im_alu2;
		re_alu3            <= re_alu3;
		im_alu3            <= im_alu3;
		re_alu4            <= re_alu4;
		im_alu4            <= im_alu4;
		re_alu5            <= re_alu5;
		im_alu5            <= im_alu5;
		re_alu6            <= re_alu6;
		im_alu6            <= im_alu6;
		re_alu7            <= re_alu7;
		im_alu7            <= im_alu7;
		pixel_alu8         <= pixel_alu8;
		pixel_alu9         <= pixel_alu9;
		pixel_alu10        <= pixel_alu10;
		pixel_alu11        <= pixel_alu11;
		pixel_alu12        <= pixel_alu12;
		pixel_alu13        <= pixel_alu13;
		pixel_alu14        <= pixel_alu14;
		pixel_alu15        <= pixel_alu15;
		re_alu8            <= re_alu8;
		im_alu8            <= im_alu8;
		re_alu9            <= re_alu9;
		im_alu9            <= im_alu9;
		re_alu10           <= re_alu10;
		im_alu10           <= im_alu10;
		re_alu11           <= re_alu11;
		im_alu11           <= im_alu11;
		re_alu12           <= re_alu12;
		im_alu12           <= im_alu12;
		re_alu13           <= re_alu13;
		im_alu13           <= im_alu13;
		re_alu14           <= re_alu14;
		im_alu14           <= im_alu14;
		re_alu15           <= re_alu15;
		im_alu15           <= im_alu15;
		current_re         <= current_re;
		current_im         <= current_im;
		llre               <= llre;
		llim               <= llim;
		CASE math_state IS
			WHEN idle => 
				picture_done      <= '1';
				current_pixel     <= 0;
				current_pixel_inc <= 1;
			WHEN receive_llre => 
			WHEN fetch_llre   => 
				llre        <= data;
				current_re  <= data;
				re_received <= '1';
			WHEN receive_llim => 
			WHEN fetch_llim   => 
				llim        <= data;
				current_im  <= data;
				im_received <= '1';
			WHEN receive_zf => 
			WHEN fetch_zf   => 
				zf          <= data;
				zf_received <= '1';
			WHEN calc_next_pixel_im => --calc_next_pixel_re/im
				adder_a            <= current_im;
				adder_a_valid      <= '1';
				adder_b            <= zf;
				adder_b_valid      <= '1';
				adder_result_ready <= '1';
				current_re         <= llre;
			WHEN calc_next_pixel_re => --calc_next_pixel_re/im
				adder_a            <= current_re;
				adder_a_valid      <= '1';
				adder_b            <= zf;
				adder_b_valid      <= '1';
				adder_result_ready <= '1';
			WHEN wait_for_re_value_ready => 
			WHEN wait_for_im_value_ready => 
			WHEN fetch_re => current_re <= adder_result;
			WHEN fetch_im => current_im <= adder_result;
			WHEN pixel_ready => 
			WHEN run_alu0    => 
				re_alu0    <= current_re;
				im_alu0    <= current_im;
				start_alu0 <= '1';
				pixel_alu0 <= current_pixel;
			WHEN run_alu1 => 
				re_alu1    <= current_re;
				im_alu1    <= current_im;
				start_alu1 <= '1';
				pixel_alu1 <= current_pixel;
			WHEN run_alu2 => 
				re_alu2    <= current_re;
				im_alu2    <= current_im;
				start_alu2 <= '1';
				pixel_alu2 <= current_pixel;
			WHEN run_alu3 => 
				re_alu3    <= current_re;
				im_alu3    <= current_im;
				start_alu3 <= '1';
				pixel_alu3 <= current_pixel;
			WHEN run_alu4 => 
				re_alu4    <= current_re;
				im_alu4    <= current_im;
				start_alu4 <= '1';
				pixel_alu4 <= current_pixel;
			WHEN run_alu5 => 
				re_alu5    <= current_re;
				im_alu5    <= current_im;
				start_alu5 <= '1';
				pixel_alu5 <= current_pixel;
			WHEN run_alu6 => 
				re_alu6    <= current_re;
				im_alu6    <= current_im;
				start_alu6 <= '1';
				pixel_alu6 <= current_pixel;
			WHEN run_alu7 => 
				re_alu7    <= current_re;
				im_alu7    <= current_im;
				start_alu7 <= '1';
				pixel_alu7 <= current_pixel;
 
			WHEN inc_pixel => 
				current_pixel <= current_pixel_inc;
			WHEN fetch_alu0 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu0;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu0, 13));
				received_alu0             <= '1';
			WHEN fetch_alu1 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu1;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu1, 13));
				received_alu1             <= '1';
			WHEN fetch_alu2 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu2;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu2, 13));
				received_alu2             <= '1';
			WHEN fetch_alu3 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu3;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu3, 13));
				received_alu3             <= '1';
			WHEN fetch_alu4 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu4;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu4, 13));
				received_alu4             <= '1';
			WHEN fetch_alu5 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu5;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu5, 13));
				received_alu5             <= '1';
			WHEN fetch_alu6 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu6;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu6, 13));
				received_alu6             <= '1';
			WHEN fetch_alu7 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu7;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu7, 13));
				received_alu7             <= '1';
			WHEN fetch_alu8 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu8;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu8, 13));
				received_alu8             <= '1';
			WHEN fetch_alu9 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu9;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu9, 13));
				received_alu9             <= '1';
			WHEN fetch_alu10 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu10;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu10, 13));
				received_alu10            <= '1';
			WHEN fetch_alu11 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu11;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu11, 13));
				received_alu11            <= '1';
			WHEN fetch_alu12 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu12;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu12, 13));
				received_alu12            <= '1';
			WHEN fetch_alu13 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu13;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu13, 13));
				received_alu13            <= '1';
			WHEN fetch_alu14 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu14;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu14, 13));
				received_alu14            <= '1';
			WHEN fetch_alu15 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu15;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu15, 13));
				received_alu15            <= '1';
			WHEN run_alu8 => 
				re_alu8    <= current_re;
				im_alu8    <= current_im;
				start_alu8 <= '1';
				pixel_alu8 <= current_pixel;
			WHEN run_alu9 => 
				re_alu9    <= current_re;
				im_alu9    <= current_im;
				start_alu9 <= '1';
				pixel_alu9 <= current_pixel;
			WHEN run_alu10 => 
				re_alu10    <= current_re;
				im_alu10    <= current_im;
				start_alu10 <= '1';
				pixel_alu10 <= current_pixel;
			WHEN run_alu11 => 
				re_alu11    <= current_re;
				im_alu11    <= current_im;
				start_alu11 <= '1';
				pixel_alu11 <= current_pixel;
			WHEN run_alu12 => 
				re_alu12    <= current_re;
				im_alu12    <= current_im;
				start_alu12 <= '1';
				pixel_alu12 <= current_pixel;
			WHEN run_alu13 => 
				re_alu13    <= current_re;
				im_alu13    <= current_im;
				start_alu13 <= '1';
				pixel_alu13 <= current_pixel;
			WHEN run_alu14 => 
				re_alu14    <= current_re;
				im_alu14    <= current_im;
				start_alu14 <= '1';
				pixel_alu14 <= current_pixel;
			WHEN run_alu15 => 
				re_alu15    <= current_re;
				im_alu15    <= current_im;
				start_alu15 <= '1';
				pixel_alu15 <= current_pixel;
			WHEN wait_for_alus => 
		END CASE;
		current_pixel_inc <= current_pixel + 1;
	END PROCESS outputs;

	transitions : PROCESS (clk) IS BEGIN
		IF rising_edge(clk) THEN
			math_state_next <= math_state; --loop
			CASE math_state IS
				WHEN idle => 
					IF (run = '1') THEN
						math_state_next <= receive_llre;
					END IF;
				WHEN receive_llre => 
					IF (re_ready = '1') THEN
						math_state_next <= fetch_llre;
					END IF;
				WHEN fetch_llre => 
					math_state_next <= receive_llim;
				WHEN receive_llim => 
					IF (im_ready = '1') THEN
						math_state_next <= fetch_llim;
					END IF;
				WHEN fetch_llim => 
					math_state_next <= receive_zf;
				WHEN receive_zf => 
					IF (zf_ready = '1') THEN
						math_state_next <= fetch_zf;
					END IF;
				WHEN fetch_zf => 
					math_state_next <= pixel_ready;
				WHEN calc_next_pixel_re => IF (adder_a_ready = '1' AND adder_b_ready = '1') THEN
					math_state_next <= wait_for_re_value_ready;
			END IF;
				WHEN calc_next_pixel_im => 
				IF (adder_a_ready = '1' AND adder_b_ready = '1') THEN
					math_state_next <= wait_for_im_value_ready;
				END IF;
				WHEN wait_for_re_value_ready => 
				IF (adder_result_valid = '1') THEN
					math_state_next <= fetch_re;
				END IF;
				WHEN wait_for_im_value_ready => 
				IF (adder_result_valid = '1') THEN
					math_state_next <= fetch_im;
				END IF;
				WHEN fetch_re => 
				math_state_next <= pixel_ready;
				WHEN fetch_im => 
				math_state_next <= pixel_ready;
				WHEN pixel_ready => 
				IF (done_alu0 = '1') THEN --find idle alus and give them work
					math_state_next <= fetch_alu0;
				ELSIF (idle_alu0 = '1') THEN
					math_state_next <= run_alu0;
				ELSIF (done_alu1 = '1') THEN
					math_state_next <= fetch_alu1;
				ELSIF (idle_alu1 = '1') THEN
					math_state_next <= run_alu1;
				ELSIF (done_alu2 = '1') THEN
					math_state_next <= fetch_alu2;
				ELSIF (idle_alu2 = '1') THEN
					math_state_next <= run_alu2;
				ELSIF (done_alu3 = '1') THEN
					math_state_next <= fetch_alu3;
				ELSIF (idle_alu3 = '1') THEN
					math_state_next <= run_alu3;
				ELSIF (done_alu4 = '1') THEN
					math_state_next <= fetch_alu4;
				ELSIF (idle_alu4 = '1') THEN
					math_state_next <= run_alu4;
				ELSIF (done_alu5 = '1') THEN
					math_state_next <= fetch_alu5;
				ELSIF (idle_alu5 = '1') THEN
					math_state_next <= run_alu5;
				ELSIF (done_alu6 = '1') THEN
					math_state_next <= fetch_alu6;
				ELSIF (idle_alu6 = '1') THEN
					math_state_next <= run_alu6;
				ELSIF (done_alu7 = '1') THEN
					math_state_next <= fetch_alu7;
				ELSIF (idle_alu7 = '1') THEN
					math_state_next <= run_alu7;
				ELSIF (done_alu8 = '1') THEN
					math_state_next <= fetch_alu8;
				ELSIF (idle_alu8 = '1') THEN
					math_state_next <= run_alu8;
				ELSIF (done_alu9 = '1') THEN
					math_state_next <= fetch_alu9;
				ELSIF (idle_alu9 = '1') THEN
					math_state_next <= run_alu9;
				ELSIF (done_alu10 = '1') THEN
					math_state_next <= fetch_alu10;
				ELSIF (idle_alu10 = '1') THEN
					math_state_next <= run_alu10;
				ELSIF (done_alu11 = '1') THEN
					math_state_next <= fetch_alu11;
				ELSIF (idle_alu11 = '1') THEN
					math_state_next <= run_alu11;
				ELSIF (done_alu12 = '1') THEN
					math_state_next <= fetch_alu12;
				ELSIF (idle_alu12 = '1') THEN
					math_state_next <= run_alu12;
				ELSIF (done_alu13 = '1') THEN
					math_state_next <= fetch_alu13;
				ELSIF (idle_alu13 = '1') THEN
					math_state_next <= run_alu13;
				ELSIF (done_alu14 = '1') THEN
					math_state_next <= fetch_alu14;
				ELSIF (idle_alu14 = '1') THEN
					math_state_next <= run_alu14;
				ELSIF (done_alu15 = '1') THEN
					math_state_next <= fetch_alu15;
				ELSIF (idle_alu15 = '1') THEN
					math_state_next <= run_alu15;
				END IF;
				WHEN inc_pixel => 
				IF ((current_pixel MOD display_width = 0) AND current_pixel /= 6144) THEN --line break, increase im value
					math_state_next <= calc_next_pixel_im;
				ELSIF ((current_pixel MOD display_width /= 0) AND current_pixel /= 6144) THEN
					math_state_next <= calc_next_pixel_re;
				ELSE
					math_state_next <= wait_for_alus;
				END IF;
				WHEN run_alu0 | run_alu1 | run_alu2 | run_alu3 | run_alu4 | run_alu5 | run_alu6 | run_alu7 | run_alu8 | run_alu9 | run_alu10 | run_alu11 | run_alu12 | run_alu13 | run_alu14 | run_alu15 => 
				math_state_next <= inc_pixel;
				WHEN fetch_alu0 | fetch_alu1 | fetch_alu2 | fetch_alu3 | fetch_alu4 | fetch_alu5 | fetch_alu6 | fetch_alu7 | fetch_alu8 | fetch_alu9 | fetch_alu10 | fetch_alu11 | fetch_alu12 | fetch_alu13 | fetch_alu14 | fetch_alu15 => 
				IF (current_pixel = 6144) THEN
					IF (pixel_received = '1') THEN
						math_state_next <= wait_for_alus;
					END IF;
				ELSIF (current_pixel < 6144) THEN
					IF (pixel_received = '1') THEN
						math_state_next <= pixel_ready;
					END IF;
				END IF;
				WHEN wait_for_alus => 
				IF (done_alu0 = '1') THEN
					math_state_next <= fetch_alu0;
				ELSIF (done_alu1 = '1') THEN
					math_state_next <= fetch_alu1;
				ELSIF (done_alu2 = '1') THEN
					math_state_next <= fetch_alu2;
				ELSIF (done_alu3 = '1') THEN
					math_state_next <= fetch_alu3;
				ELSIF (done_alu4 = '1') THEN
					math_state_next <= fetch_alu4;
				ELSIF (done_alu5 = '1') THEN
					math_state_next <= fetch_alu5;
				ELSIF (done_alu6 = '1') THEN
					math_state_next <= fetch_alu6;
				ELSIF (done_alu7 = '1') THEN
					math_state_next <= fetch_alu7;
				ELSIF (done_alu8 = '1') THEN
					math_state_next <= fetch_alu8;
				ELSIF (done_alu9 = '1') THEN
					math_state_next <= fetch_alu9;
				ELSIF (done_alu10 = '1') THEN
					math_state_next <= fetch_alu10;
				ELSIF (done_alu11 = '1') THEN
					math_state_next <= fetch_alu11;
				ELSIF (done_alu12 = '1') THEN
					math_state_next <= fetch_alu12;
				ELSIF (done_alu13 = '1') THEN
					math_state_next <= fetch_alu13;
				ELSIF (done_alu14 = '1') THEN
					math_state_next <= fetch_alu14;
				ELSIF (done_alu15 = '1') THEN
					math_state_next <= fetch_alu15;
				END IF;
				IF ((idle_alu0 = '1') AND (idle_alu1 = '1') AND (idle_alu2 = '1') AND (idle_alu3 = '1') AND (idle_alu4 = '1') AND (idle_alu5 = '1') AND (idle_alu6 = '1') AND (idle_alu7 = '1') AND (idle_alu8 = '1') AND (idle_alu9 = '1') AND (idle_alu10 = '1') AND (idle_alu11 = '1') AND (idle_alu12 = '1') AND (idle_alu13 = '1') AND (idle_alu14 = '1') AND (idle_alu15 = '1')) THEN
					math_state_next <= idle;
				END IF;
		END CASE;
	END IF;
END PROCESS transitions;

END Behavioral;
