----------------------------------------------------------------------------------
-- Company:
-- Engineer: Meister Rados
--
-- Create Date: 02.05.2017 17:19:00
-- Design Name:
-- Module Name: math_module - Behavioral
-- Project Name: Bachelorarbeit
-- Target Devices: Artix-7
-- Tool Versions:
-- Description: Math-Modul der Bachelorarbeit
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.NUMERIC_STD.ALL;

ENTITY math_module IS
	PORT 
	(
		clk            : IN std_logic; --clock for math_module
		reset          : IN std_logic;
		data           : IN std_logic_vector (63 DOWNTO 0); --databus for re, im, zf values and result values
		run            : IN std_logic; --calc pictute
		re_ready       : IN std_logic;
		im_ready       : IN std_logic;
		zf_ready       : IN std_logic; --databus has valid data
		pixel_received : IN std_logic;
		re_received    : OUT std_logic := '0';
		im_received    : OUT std_logic := '0';
		zf_received    : OUT std_logic := '0'; --everything received
		result_data    : OUT std_logic_vector (22 DOWNTO 0);
		pixel_done     : OUT std_logic := '0';
		picture_done   : OUT std_logic
	);
END math_module;

ARCHITECTURE Behavioral OF math_module IS

	--signals for math FSM

	TYPE math_states IS (idle, fetch_llre, fetch_llim, fetch_zf, fetch_re, fetch_im, receive_llre, receive_llim, 
	receive_zf, calc_next_pixel_im, calc_next_pixel_re, wait_for_re_value_ready, 
	wait_for_im_value_ready, wait_for_alus, pixel_ready, 
	fetch_alu0, run_alu0, fetch_alu1, run_alu1, fetch_alu2, run_alu2, fetch_alu3, run_alu3, 
	fetch_alu4, run_alu4, fetch_alu5, run_alu5, fetch_alu6, run_alu6, fetch_alu7, run_alu7, 
	fetch_alu8, run_alu8, fetch_alu9, run_alu9, fetch_alu10, run_alu10, fetch_alu11, run_alu11, 
	fetch_alu12, run_alu12, fetch_alu13, run_alu13, fetch_alu14, run_alu14, fetch_alu15, run_alu15, 
	fetch_alu16, run_alu16, fetch_alu17, run_alu17, fetch_alu18, run_alu18, fetch_alu19, run_alu19, 
	fetch_alu20, run_alu20, fetch_alu21, run_alu21, fetch_alu22, run_alu22, fetch_alu23, run_alu23, 
	fetch_alu24, run_alu24, fetch_alu25, run_alu25, fetch_alu26, run_alu26, fetch_alu27, run_alu27, 
	fetch_alu28, run_alu28, fetch_alu29, run_alu29, fetch_alu30, run_alu30, fetch_alu31, run_alu31, 
	fetch_alu32, run_alu32, fetch_alu33, run_alu33, fetch_alu34, run_alu34, fetch_alu35, run_alu35, 
	fetch_alu36, run_alu36, fetch_alu37, run_alu37, fetch_alu38, run_alu38, fetch_alu39, run_alu39, 
	fetch_alu40, run_alu40, fetch_alu41, run_alu41, fetch_alu42, run_alu42, fetch_alu43, run_alu43, 
	fetch_alu44, run_alu44, fetch_alu45, run_alu45, fetch_alu46, run_alu46, fetch_alu47, run_alu47, 
	fetch_alu48, run_alu48, fetch_alu49, run_alu49, fetch_alu50, run_alu50, fetch_alu51, run_alu51, 
	fetch_alu52, run_alu52, fetch_alu53, run_alu53, fetch_alu54, run_alu54, fetch_alu55, run_alu55, 
	fetch_alu56, run_alu56, fetch_alu57, run_alu57, fetch_alu58, run_alu58, fetch_alu59, run_alu59, 
	fetch_alu60, run_alu60, fetch_alu61, run_alu61, fetch_alu62, run_alu62, fetch_alu63, run_alu63,
	fetch_alu64, run_alu64, fetch_alu65, run_alu65, fetch_alu66, run_alu66, fetch_alu67, run_alu67, 
	fetch_alu68, run_alu68, fetch_alu69, run_alu69, fetch_alu70, run_alu70, fetch_alu71, run_alu71, 
	fetch_alu72, run_alu72, fetch_alu73, run_alu73, fetch_alu74, run_alu74, fetch_alu75, run_alu75, 
	fetch_alu76, run_alu76, fetch_alu77, run_alu77, fetch_alu78, run_alu78, fetch_alu79, run_alu79, 
	fetch_alu80, run_alu80, fetch_alu81, run_alu81, fetch_alu82, run_alu82, fetch_alu83, run_alu83, 
	fetch_alu84, run_alu84, fetch_alu85, run_alu85, fetch_alu86, run_alu86, fetch_alu87, run_alu87, 
	fetch_alu88, run_alu88, fetch_alu89, run_alu89, fetch_alu90, run_alu90, fetch_alu91, run_alu91, 
	fetch_alu92, run_alu92, fetch_alu93, run_alu93, fetch_alu94, run_alu94, fetch_alu95, run_alu95, 
	fetch_alu96, run_alu96, fetch_alu97, run_alu97, fetch_alu98, run_alu98, fetch_alu99, run_alu99, 
	fetch_alu100, run_alu100, fetch_alu101, run_alu101, fetch_alu102, run_alu102, fetch_alu103, run_alu103, 
	fetch_alu104, run_alu104, fetch_alu105, run_alu105, fetch_alu106, run_alu106, fetch_alu107, run_alu107, 
	fetch_alu108, run_alu108, fetch_alu109, run_alu109, fetch_alu110, run_alu110, fetch_alu111, run_alu111, 
	fetch_alu112, run_alu112, fetch_alu113, run_alu113, fetch_alu114, run_alu114, fetch_alu115, run_alu115, 
	fetch_alu116, run_alu116, fetch_alu117, run_alu117, fetch_alu118, run_alu118, fetch_alu119, run_alu119, 
	fetch_alu120, run_alu120, fetch_alu121, run_alu121, fetch_alu122, run_alu122, fetch_alu123, run_alu123, 
	fetch_alu124, run_alu124, fetch_alu125, run_alu125, fetch_alu126, run_alu126, fetch_alu127, run_alu127,
	inc_pixel);
	SIGNAL math_state      : math_states := idle;
	SIGNAL math_state_next : math_states;

	--signals for math_module in general
	SIGNAL llre, llim, zf, current_re, current_im : std_logic_vector (63 DOWNTO 0);
	SIGNAL current_pixel, current_pixel_inc       : NATURAL RANGE 0 TO 6145;
	CONSTANT display_width                        : INTEGER := 96;
	--signals for complex alus
	SIGNAL pixel_alu0         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu0, im_alu0   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu0     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu0         : std_logic := '0';
	SIGNAL received_alu0      : std_logic;
	SIGNAL done_alu0          : std_logic;
	SIGNAL idle_alu0          : std_logic;

	SIGNAL pixel_alu1         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu1, im_alu1   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu1     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu1         : std_logic := '0';
	SIGNAL received_alu1      : std_logic;
	SIGNAL done_alu1          : std_logic;
	SIGNAL idle_alu1          : std_logic;

	SIGNAL pixel_alu2         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu2, im_alu2   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu2     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu2         : std_logic := '0';
	SIGNAL received_alu2      : std_logic;
	SIGNAL done_alu2          : std_logic;
	SIGNAL idle_alu2          : std_logic;

	SIGNAL pixel_alu3         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu3, im_alu3   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu3     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu3         : std_logic := '0';
	SIGNAL received_alu3      : std_logic;
	SIGNAL done_alu3          : std_logic;
	SIGNAL idle_alu3          : std_logic;

	SIGNAL pixel_alu4         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu4, im_alu4   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu4     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu4         : std_logic := '0';
	SIGNAL received_alu4      : std_logic;
	SIGNAL done_alu4          : std_logic;
	SIGNAL idle_alu4          : std_logic;

	SIGNAL pixel_alu5         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu5, im_alu5   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu5     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu5         : std_logic := '0';
	SIGNAL received_alu5      : std_logic;
	SIGNAL done_alu5          : std_logic;
	SIGNAL idle_alu5          : std_logic;

	SIGNAL pixel_alu6         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu6, im_alu6   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu6     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu6         : std_logic := '0';
	SIGNAL received_alu6      : std_logic;
	SIGNAL done_alu6          : std_logic;
	SIGNAL idle_alu6          : std_logic;

	SIGNAL pixel_alu7         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu7, im_alu7   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu7     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu7         : std_logic := '0';
	SIGNAL received_alu7      : std_logic;
	SIGNAL done_alu7          : std_logic;
	SIGNAL idle_alu7          : std_logic;
 
	SIGNAL pixel_alu8         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu8, im_alu8   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu8     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu8         : std_logic := '0';
	SIGNAL received_alu8      : std_logic;
	SIGNAL done_alu8          : std_logic;
	SIGNAL idle_alu8          : std_logic;
 
	SIGNAL pixel_alu9         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu9, im_alu9   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu9     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu9         : std_logic := '0';
	SIGNAL received_alu9      : std_logic;
	SIGNAL done_alu9          : std_logic;
	SIGNAL idle_alu9          : std_logic;
 
	SIGNAL pixel_alu10        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu10, im_alu10 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu10    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu10        : std_logic := '0';
	SIGNAL received_alu10     : std_logic;
	SIGNAL done_alu10         : std_logic;
	SIGNAL idle_alu10         : std_logic;
 
	SIGNAL pixel_alu11        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu11, im_alu11 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu11    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu11        : std_logic := '0';
	SIGNAL received_alu11     : std_logic;
	SIGNAL done_alu11         : std_logic;
	SIGNAL idle_alu11         : std_logic;
 
	SIGNAL pixel_alu12        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu12, im_alu12 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu12    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu12        : std_logic := '0';
	SIGNAL received_alu12     : std_logic;
	SIGNAL done_alu12         : std_logic;
	SIGNAL idle_alu12         : std_logic;
 
	SIGNAL pixel_alu13        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu13, im_alu13 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu13    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu13        : std_logic := '0';
	SIGNAL received_alu13     : std_logic;
	SIGNAL done_alu13         : std_logic;
	SIGNAL idle_alu13         : std_logic;
 
	SIGNAL pixel_alu14        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu14, im_alu14 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu14    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu14        : std_logic := '0';
	SIGNAL received_alu14     : std_logic;
	SIGNAL done_alu14         : std_logic;
	SIGNAL idle_alu14         : std_logic;
 
	SIGNAL pixel_alu15        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu15, im_alu15 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu15    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu15        : std_logic := '0';
	SIGNAL received_alu15     : std_logic;
	SIGNAL done_alu15         : std_logic;
	SIGNAL idle_alu15         : std_logic;

	SIGNAL pixel_alu16        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu16, im_alu16 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu16    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu16        : std_logic := '0';
	SIGNAL received_alu16     : std_logic;
	SIGNAL done_alu16         : std_logic;
	SIGNAL idle_alu16         : std_logic;

	SIGNAL pixel_alu17        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu17, im_alu17 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu17    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu17        : std_logic := '0';
	SIGNAL received_alu17     : std_logic;
	SIGNAL done_alu17         : std_logic;
	SIGNAL idle_alu17         : std_logic;

	SIGNAL pixel_alu18        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu18, im_alu18 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu18    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu18        : std_logic := '0';
	SIGNAL received_alu18     : std_logic;
	SIGNAL done_alu18         : std_logic;
	SIGNAL idle_alu18         : std_logic;

	SIGNAL pixel_alu19        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu19, im_alu19 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu19    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu19        : std_logic := '0';
	SIGNAL received_alu19     : std_logic;
	SIGNAL done_alu19         : std_logic;
	SIGNAL idle_alu19         : std_logic;

	SIGNAL pixel_alu20        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu20, im_alu20 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu20    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu20        : std_logic := '0';
	SIGNAL received_alu20     : std_logic;
	SIGNAL done_alu20         : std_logic;
	SIGNAL idle_alu20         : std_logic;

	SIGNAL pixel_alu21        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu21, im_alu21 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu21    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu21        : std_logic := '0';
	SIGNAL received_alu21     : std_logic;
	SIGNAL done_alu21         : std_logic;
	SIGNAL idle_alu21         : std_logic;

	SIGNAL pixel_alu22        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu22, im_alu22 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu22    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu22        : std_logic := '0';
	SIGNAL received_alu22     : std_logic;
	SIGNAL done_alu22         : std_logic;
	SIGNAL idle_alu22         : std_logic;

	SIGNAL pixel_alu23        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu23, im_alu23 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu23    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu23        : std_logic := '0';
	SIGNAL received_alu23     : std_logic;
	SIGNAL done_alu23         : std_logic;
	SIGNAL idle_alu23         : std_logic;
 
	SIGNAL pixel_alu24        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu24, im_alu24 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu24    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu24        : std_logic := '0';
	SIGNAL received_alu24     : std_logic;
	SIGNAL done_alu24         : std_logic;
	SIGNAL idle_alu24         : std_logic;
 
	SIGNAL pixel_alu25        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu25, im_alu25 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu25    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu25        : std_logic := '0';
	SIGNAL received_alu25     : std_logic;
	SIGNAL done_alu25         : std_logic;
	SIGNAL idle_alu25         : std_logic;
 
	SIGNAL pixel_alu26        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu26, im_alu26 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu26    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu26        : std_logic := '0';
	SIGNAL received_alu26     : std_logic;
	SIGNAL done_alu26         : std_logic;
	SIGNAL idle_alu26         : std_logic;
 
	SIGNAL pixel_alu27        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu27, im_alu27 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu27    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu27        : std_logic := '0';
	SIGNAL received_alu27     : std_logic;
	SIGNAL done_alu27         : std_logic;
	SIGNAL idle_alu27         : std_logic;
 
	SIGNAL pixel_alu28        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu28, im_alu28 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu28    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu28        : std_logic := '0';
	SIGNAL received_alu28     : std_logic;
	SIGNAL done_alu28         : std_logic;
	SIGNAL idle_alu28         : std_logic;
 
	SIGNAL pixel_alu29        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu29, im_alu29 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu29    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu29        : std_logic := '0';
	SIGNAL received_alu29     : std_logic;
	SIGNAL done_alu29         : std_logic;
	SIGNAL idle_alu29         : std_logic;
 
	SIGNAL pixel_alu30        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu30, im_alu30 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu30    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu30        : std_logic := '0';
	SIGNAL received_alu30     : std_logic;
	SIGNAL done_alu30         : std_logic;
	SIGNAL idle_alu30         : std_logic;
 
	SIGNAL pixel_alu31        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu31, im_alu31 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu31    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu31        : std_logic := '0';
	SIGNAL received_alu31     : std_logic;
	SIGNAL done_alu31         : std_logic;
	SIGNAL idle_alu31         : std_logic;

	SIGNAL pixel_alu32         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu32, im_alu32   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu32     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu32         : std_logic := '0';
	SIGNAL received_alu32      : std_logic;
	SIGNAL done_alu32          : std_logic;
	SIGNAL idle_alu32          : std_logic;

	SIGNAL pixel_alu33         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu33, im_alu33   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu33     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu33         : std_logic := '0';
	SIGNAL received_alu33      : std_logic;
	SIGNAL done_alu33          : std_logic;
	SIGNAL idle_alu33          : std_logic;

	SIGNAL pixel_alu34         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu34, im_alu34   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu34     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu34         : std_logic := '0';
	SIGNAL received_alu34      : std_logic;
	SIGNAL done_alu34          : std_logic;
	SIGNAL idle_alu34          : std_logic;

	SIGNAL pixel_alu35         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu35, im_alu35   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu35     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu35         : std_logic := '0';
	SIGNAL received_alu35      : std_logic;
	SIGNAL done_alu35          : std_logic;
	SIGNAL idle_alu35          : std_logic;

	SIGNAL pixel_alu36         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu36, im_alu36   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu36     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu36         : std_logic := '0';
	SIGNAL received_alu36      : std_logic;
	SIGNAL done_alu36          : std_logic;
	SIGNAL idle_alu36          : std_logic;

	SIGNAL pixel_alu37         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu37, im_alu37   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu37     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu37         : std_logic := '0';
	SIGNAL received_alu37      : std_logic;
	SIGNAL done_alu37          : std_logic;
	SIGNAL idle_alu37          : std_logic;

	SIGNAL pixel_alu38         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu38, im_alu38   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu38     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu38         : std_logic := '0';
	SIGNAL received_alu38      : std_logic;
	SIGNAL done_alu38          : std_logic;
	SIGNAL idle_alu38          : std_logic;

	SIGNAL pixel_alu39         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu39, im_alu39   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu39     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu39         : std_logic := '0';
	SIGNAL received_alu39      : std_logic;
	SIGNAL done_alu39          : std_logic;
	SIGNAL idle_alu39          : std_logic;
 
	SIGNAL pixel_alu40         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu40, im_alu40   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu40     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu40         : std_logic := '0';
	SIGNAL received_alu40      : std_logic;
	SIGNAL done_alu40          : std_logic;
	SIGNAL idle_alu40          : std_logic;
 
	SIGNAL pixel_alu41         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu41, im_alu41   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu41     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu41         : std_logic := '0';
	SIGNAL received_alu41      : std_logic;
	SIGNAL done_alu41          : std_logic;
	SIGNAL idle_alu41          : std_logic;
 
	SIGNAL pixel_alu42        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu42, im_alu42 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu42    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu42        : std_logic := '0';
	SIGNAL received_alu42     : std_logic;
	SIGNAL done_alu42         : std_logic;
	SIGNAL idle_alu42         : std_logic;
 
	SIGNAL pixel_alu43        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu43, im_alu43 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu43    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu43        : std_logic := '0';
	SIGNAL received_alu43     : std_logic;
	SIGNAL done_alu43         : std_logic;
	SIGNAL idle_alu43         : std_logic;
 
	SIGNAL pixel_alu44        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu44, im_alu44 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu44    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu44        : std_logic := '0';
	SIGNAL received_alu44     : std_logic;
	SIGNAL done_alu44         : std_logic;
	SIGNAL idle_alu44         : std_logic;
 
	SIGNAL pixel_alu45        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu45, im_alu45 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu45    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu45        : std_logic := '0';
	SIGNAL received_alu45     : std_logic;
	SIGNAL done_alu45         : std_logic;
	SIGNAL idle_alu45         : std_logic;
 
	SIGNAL pixel_alu46        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu46, im_alu46 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu46    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu46        : std_logic := '0';
	SIGNAL received_alu46     : std_logic;
	SIGNAL done_alu46         : std_logic;
	SIGNAL idle_alu46         : std_logic;
 
	SIGNAL pixel_alu47        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu47, im_alu47 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu47    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu47        : std_logic := '0';
	SIGNAL received_alu47     : std_logic;
	SIGNAL done_alu47         : std_logic;
	SIGNAL idle_alu47         : std_logic;

	SIGNAL pixel_alu48        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu48, im_alu48 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu48    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu48        : std_logic := '0';
	SIGNAL received_alu48     : std_logic;
	SIGNAL done_alu48         : std_logic;
	SIGNAL idle_alu48         : std_logic;

	SIGNAL pixel_alu49        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu49, im_alu49 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu49    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu49        : std_logic := '0';
	SIGNAL received_alu49     : std_logic;
	SIGNAL done_alu49         : std_logic;
	SIGNAL idle_alu49         : std_logic;

	SIGNAL pixel_alu50        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu50, im_alu50 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu50    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu50        : std_logic := '0';
	SIGNAL received_alu50     : std_logic;
	SIGNAL done_alu50         : std_logic;
	SIGNAL idle_alu50         : std_logic;

	SIGNAL pixel_alu51        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu51, im_alu51 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu51    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu51        : std_logic := '0';
	SIGNAL received_alu51     : std_logic;
	SIGNAL done_alu51         : std_logic;
	SIGNAL idle_alu51         : std_logic;

	SIGNAL pixel_alu52        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu52, im_alu52 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu52    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu52        : std_logic := '0';
	SIGNAL received_alu52     : std_logic;
	SIGNAL done_alu52         : std_logic;
	SIGNAL idle_alu52         : std_logic;

	SIGNAL pixel_alu53        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu53, im_alu53 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu53    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu53        : std_logic := '0';
	SIGNAL received_alu53     : std_logic;
	SIGNAL done_alu53         : std_logic;
	SIGNAL idle_alu53         : std_logic;

	SIGNAL pixel_alu54        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu54, im_alu54 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu54    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu54        : std_logic := '0';
	SIGNAL received_alu54     : std_logic;
	SIGNAL done_alu54         : std_logic;
	SIGNAL idle_alu54         : std_logic;

	SIGNAL pixel_alu55        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu55, im_alu55 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu55    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu55        : std_logic := '0';
	SIGNAL received_alu55     : std_logic;
	SIGNAL done_alu55         : std_logic;
	SIGNAL idle_alu55         : std_logic;
 
	SIGNAL pixel_alu56        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu56, im_alu56 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu56    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu56        : std_logic := '0';
	SIGNAL received_alu56     : std_logic;
	SIGNAL done_alu56         : std_logic;
	SIGNAL idle_alu56         : std_logic;
 
	SIGNAL pixel_alu57        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu57, im_alu57 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu57    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu57        : std_logic := '0';
	SIGNAL received_alu57     : std_logic;
	SIGNAL done_alu57         : std_logic;
	SIGNAL idle_alu57         : std_logic;
 
	SIGNAL pixel_alu58        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu58, im_alu58 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu58    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu58        : std_logic := '0';
	SIGNAL received_alu58     : std_logic;
	SIGNAL done_alu58         : std_logic;
	SIGNAL idle_alu58         : std_logic;
 
	SIGNAL pixel_alu59        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu59, im_alu59 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu59    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu59        : std_logic := '0';
	SIGNAL received_alu59     : std_logic;
	SIGNAL done_alu59         : std_logic;
	SIGNAL idle_alu59         : std_logic;
 
	SIGNAL pixel_alu60        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu60, im_alu60 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu60    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu60        : std_logic := '0';
	SIGNAL received_alu60     : std_logic;
	SIGNAL done_alu60         : std_logic;
	SIGNAL idle_alu60         : std_logic;
 
	SIGNAL pixel_alu61        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu61, im_alu61 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu61    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu61        : std_logic := '0';
	SIGNAL received_alu61     : std_logic;
	SIGNAL done_alu61         : std_logic;
	SIGNAL idle_alu61         : std_logic;
 
	SIGNAL pixel_alu62        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu62, im_alu62 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu62    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu62        : std_logic := '0';
	SIGNAL received_alu62     : std_logic;
	SIGNAL done_alu62         : std_logic;
	SIGNAL idle_alu62         : std_logic;
 
	SIGNAL pixel_alu63        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu63, im_alu63 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu63    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu63        : std_logic := '0';
	SIGNAL received_alu63     : std_logic;
	SIGNAL done_alu63         : std_logic;
	SIGNAL idle_alu63         : std_logic;

	SIGNAL pixel_alu64         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu64, im_alu64   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu64     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu64         : std_logic := '0';
	SIGNAL received_alu64      : std_logic;
	SIGNAL done_alu64          : std_logic;
	SIGNAL idle_alu64          : std_logic;

	SIGNAL pixel_alu65         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu65, im_alu65   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu65     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu65         : std_logic := '0';
	SIGNAL received_alu65      : std_logic;
	SIGNAL done_alu65          : std_logic;
	SIGNAL idle_alu65          : std_logic;

	SIGNAL pixel_alu66         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu66, im_alu66   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu66     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu66         : std_logic := '0';
	SIGNAL received_alu66      : std_logic;
	SIGNAL done_alu66          : std_logic;
	SIGNAL idle_alu66          : std_logic;

	SIGNAL pixel_alu67         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu67, im_alu67   : std_logic_vector (667 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu67     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu67         : std_logic := '0';
	SIGNAL received_alu67      : std_logic;
	SIGNAL done_alu67          : std_logic;
	SIGNAL idle_alu67          : std_logic;

	SIGNAL pixel_alu68         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu68, im_alu68   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu68     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu68         : std_logic := '0';
	SIGNAL received_alu68      : std_logic;
	SIGNAL done_alu68          : std_logic;
	SIGNAL idle_alu68          : std_logic;

	SIGNAL pixel_alu69         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu69, im_alu69   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu69     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu69         : std_logic := '0';
	SIGNAL received_alu69      : std_logic;
	SIGNAL done_alu69          : std_logic;
	SIGNAL idle_alu69          : std_logic;

	SIGNAL pixel_alu70         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu70, im_alu70   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu70     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu70         : std_logic := '0';
	SIGNAL received_alu70      : std_logic;
	SIGNAL done_alu70          : std_logic;
	SIGNAL idle_alu70          : std_logic;

	SIGNAL pixel_alu71         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu71, im_alu71   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu71     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu71         : std_logic := '0';
	SIGNAL received_alu71      : std_logic;
	SIGNAL done_alu71          : std_logic;
	SIGNAL idle_alu71          : std_logic;
 
	SIGNAL pixel_alu72         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu72, im_alu72   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu72     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu72         : std_logic := '0';
	SIGNAL received_alu72      : std_logic;
	SIGNAL done_alu72          : std_logic;
	SIGNAL idle_alu72          : std_logic;
 
	SIGNAL pixel_alu73         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu73, im_alu73   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu73     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu73         : std_logic := '0';
	SIGNAL received_alu73      : std_logic;
	SIGNAL done_alu73          : std_logic;
	SIGNAL idle_alu73          : std_logic;
 
	SIGNAL pixel_alu74        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu74, im_alu74 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu74    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu74        : std_logic := '0';
	SIGNAL received_alu74     : std_logic;
	SIGNAL done_alu74         : std_logic;
	SIGNAL idle_alu74         : std_logic;
 
	SIGNAL pixel_alu75        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu75, im_alu75 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu75    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu75        : std_logic := '0';
	SIGNAL received_alu75     : std_logic;
	SIGNAL done_alu75         : std_logic;
	SIGNAL idle_alu75         : std_logic;
 
	SIGNAL pixel_alu76        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu76, im_alu76 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu76    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu76        : std_logic := '0';
	SIGNAL received_alu76     : std_logic;
	SIGNAL done_alu76         : std_logic;
	SIGNAL idle_alu76         : std_logic;
 
	SIGNAL pixel_alu77        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu77, im_alu77 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu77    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu77        : std_logic := '0';
	SIGNAL received_alu77     : std_logic;
	SIGNAL done_alu77         : std_logic;
	SIGNAL idle_alu77         : std_logic;
 
	SIGNAL pixel_alu78        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu78, im_alu78 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu78    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu78        : std_logic := '0';
	SIGNAL received_alu78     : std_logic;
	SIGNAL done_alu78         : std_logic;
	SIGNAL idle_alu78         : std_logic;
 
	SIGNAL pixel_alu79        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu79, im_alu79 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu79    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu79        : std_logic := '0';
	SIGNAL received_alu79     : std_logic;
	SIGNAL done_alu79         : std_logic;
	SIGNAL idle_alu79         : std_logic;

	SIGNAL pixel_alu80        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu80, im_alu80 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu80    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu80        : std_logic := '0';
	SIGNAL received_alu80     : std_logic;
	SIGNAL done_alu80         : std_logic;
	SIGNAL idle_alu80         : std_logic;

	SIGNAL pixel_alu81        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu81, im_alu81 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu81    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu81        : std_logic := '0';
	SIGNAL received_alu81     : std_logic;
	SIGNAL done_alu81         : std_logic;
	SIGNAL idle_alu81         : std_logic;

	SIGNAL pixel_alu82        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu82, im_alu82 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu82    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu82        : std_logic := '0';
	SIGNAL received_alu82     : std_logic;
	SIGNAL done_alu82         : std_logic;
	SIGNAL idle_alu82         : std_logic;

	SIGNAL pixel_alu83        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu83, im_alu83 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu83    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu83        : std_logic := '0';
	SIGNAL received_alu83     : std_logic;
	SIGNAL done_alu83         : std_logic;
	SIGNAL idle_alu83         : std_logic;

	SIGNAL pixel_alu84        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu84, im_alu84 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu84    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu84        : std_logic := '0';
	SIGNAL received_alu84     : std_logic;
	SIGNAL done_alu84         : std_logic;
	SIGNAL idle_alu84         : std_logic;

	SIGNAL pixel_alu85        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu85, im_alu85 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu85    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu85        : std_logic := '0';
	SIGNAL received_alu85     : std_logic;
	SIGNAL done_alu85         : std_logic;
	SIGNAL idle_alu85         : std_logic;

	SIGNAL pixel_alu86        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu86, im_alu86 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu86    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu86        : std_logic := '0';
	SIGNAL received_alu86     : std_logic;
	SIGNAL done_alu86         : std_logic;
	SIGNAL idle_alu86         : std_logic;

	SIGNAL pixel_alu87        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu87, im_alu87 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu87    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu87        : std_logic := '0';
	SIGNAL received_alu87     : std_logic;
	SIGNAL done_alu87         : std_logic;
	SIGNAL idle_alu87         : std_logic;
 
	SIGNAL pixel_alu88        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu88, im_alu88 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu88    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu88        : std_logic := '0';
	SIGNAL received_alu88     : std_logic;
	SIGNAL done_alu88         : std_logic;
	SIGNAL idle_alu88         : std_logic;
 
	SIGNAL pixel_alu89        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu89, im_alu89 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu89    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu89        : std_logic := '0';
	SIGNAL received_alu89     : std_logic;
	SIGNAL done_alu89         : std_logic;
	SIGNAL idle_alu89         : std_logic;
 
	SIGNAL pixel_alu90        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu90, im_alu90 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu90    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu90        : std_logic := '0';
	SIGNAL received_alu90     : std_logic;
	SIGNAL done_alu90         : std_logic;
	SIGNAL idle_alu90         : std_logic;
 
	SIGNAL pixel_alu91        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu91, im_alu91 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu91    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu91        : std_logic := '0';
	SIGNAL received_alu91     : std_logic;
	SIGNAL done_alu91         : std_logic;
	SIGNAL idle_alu91         : std_logic;
 
	SIGNAL pixel_alu92        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu92, im_alu92 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu92    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu92        : std_logic := '0';
	SIGNAL received_alu92     : std_logic;
	SIGNAL done_alu92         : std_logic;
	SIGNAL idle_alu92         : std_logic;
 
	SIGNAL pixel_alu93        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu93, im_alu93 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu93    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu93        : std_logic := '0';
	SIGNAL received_alu93     : std_logic;
	SIGNAL done_alu93         : std_logic;
	SIGNAL idle_alu93         : std_logic;
 
	SIGNAL pixel_alu94        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu94, im_alu94 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu94    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu94        : std_logic := '0';
	SIGNAL received_alu94     : std_logic;
	SIGNAL done_alu94         : std_logic;
	SIGNAL idle_alu94         : std_logic;
 
	SIGNAL pixel_alu95        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu95, im_alu95 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu95    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu95        : std_logic := '0';
	SIGNAL received_alu95     : std_logic;
	SIGNAL done_alu95         : std_logic;
	SIGNAL idle_alu95         : std_logic;

	SIGNAL pixel_alu96         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu96, im_alu96   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu96     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu96         : std_logic := '0';
	SIGNAL received_alu96      : std_logic;
	SIGNAL done_alu96          : std_logic;
	SIGNAL idle_alu96          : std_logic;

	SIGNAL pixel_alu97         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu97, im_alu97   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu97     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu97         : std_logic := '0';
	SIGNAL received_alu97      : std_logic;
	SIGNAL done_alu97          : std_logic;
	SIGNAL idle_alu97          : std_logic;

	SIGNAL pixel_alu98         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu98, im_alu98   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu98     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu98         : std_logic := '0';
	SIGNAL received_alu98      : std_logic;
	SIGNAL done_alu98          : std_logic;
	SIGNAL idle_alu98          : std_logic;

	SIGNAL pixel_alu99         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu99, im_alu99   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu99     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu99         : std_logic := '0';
	SIGNAL received_alu99      : std_logic;
	SIGNAL done_alu99          : std_logic;
	SIGNAL idle_alu99          : std_logic;

	SIGNAL pixel_alu100         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu100, im_alu100   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu100     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu100         : std_logic := '0';
	SIGNAL received_alu100      : std_logic;
	SIGNAL done_alu100          : std_logic;
	SIGNAL idle_alu100          : std_logic;

	SIGNAL pixel_alu101         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu101, im_alu101   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu101     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu101         : std_logic := '0';
	SIGNAL received_alu101      : std_logic;
	SIGNAL done_alu101          : std_logic;
	SIGNAL idle_alu101          : std_logic;

	SIGNAL pixel_alu102         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu102, im_alu102   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu102     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu102         : std_logic := '0';
	SIGNAL received_alu102      : std_logic;
	SIGNAL done_alu102          : std_logic;
	SIGNAL idle_alu102          : std_logic;

	SIGNAL pixel_alu103         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu103, im_alu103   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu103     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu103         : std_logic := '0';
	SIGNAL received_alu103      : std_logic;
	SIGNAL done_alu103          : std_logic;
	SIGNAL idle_alu103          : std_logic;
 
	SIGNAL pixel_alu104         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu104, im_alu104   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu104     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu104         : std_logic := '0';
	SIGNAL received_alu104      : std_logic;
	SIGNAL done_alu104          : std_logic;
	SIGNAL idle_alu104          : std_logic;
 
	SIGNAL pixel_alu105         : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu105, im_alu105   : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu105     : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu105         : std_logic := '0';
	SIGNAL received_alu105      : std_logic;
	SIGNAL done_alu105          : std_logic;
	SIGNAL idle_alu105          : std_logic;
 
	SIGNAL pixel_alu106        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu106, im_alu106 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu106    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu106        : std_logic := '0';
	SIGNAL received_alu106     : std_logic;
	SIGNAL done_alu106         : std_logic;
	SIGNAL idle_alu106         : std_logic;
 
	SIGNAL pixel_alu107        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu107, im_alu107 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu107    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu107        : std_logic := '0';
	SIGNAL received_alu107     : std_logic;
	SIGNAL done_alu107         : std_logic;
	SIGNAL idle_alu107         : std_logic;
 
	SIGNAL pixel_alu108        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu108, im_alu108 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu108    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu108        : std_logic := '0';
	SIGNAL received_alu108     : std_logic;
	SIGNAL done_alu108         : std_logic;
	SIGNAL idle_alu108         : std_logic;
 
	SIGNAL pixel_alu109        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu109, im_alu109 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu109    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu109        : std_logic := '0';
	SIGNAL received_alu109     : std_logic;
	SIGNAL done_alu109         : std_logic;
	SIGNAL idle_alu109         : std_logic;
 
	SIGNAL pixel_alu110        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu110, im_alu110 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu110    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu110        : std_logic := '0';
	SIGNAL received_alu110     : std_logic;
	SIGNAL done_alu110         : std_logic;
	SIGNAL idle_alu110         : std_logic;
 
	SIGNAL pixel_alu111        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu111, im_alu111 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu111    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu111        : std_logic := '0';
	SIGNAL received_alu111     : std_logic;
	SIGNAL done_alu111         : std_logic;
	SIGNAL idle_alu111         : std_logic;

	SIGNAL pixel_alu112        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu112, im_alu112 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu112    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu112        : std_logic := '0';
	SIGNAL received_alu112     : std_logic;
	SIGNAL done_alu112         : std_logic;
	SIGNAL idle_alu112         : std_logic;

	SIGNAL pixel_alu113        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu113, im_alu113 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu113    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu113        : std_logic := '0';
	SIGNAL received_alu113     : std_logic;
	SIGNAL done_alu113         : std_logic;
	SIGNAL idle_alu113         : std_logic;

	SIGNAL pixel_alu114        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu114, im_alu114 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu114    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu114        : std_logic := '0';
	SIGNAL received_alu114     : std_logic;
	SIGNAL done_alu114         : std_logic;
	SIGNAL idle_alu114         : std_logic;

	SIGNAL pixel_alu115        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu115, im_alu115 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu115    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu115        : std_logic := '0';
	SIGNAL received_alu115     : std_logic;
	SIGNAL done_alu115         : std_logic;
	SIGNAL idle_alu115         : std_logic;

	SIGNAL pixel_alu116        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu116, im_alu116 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu116    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu116        : std_logic := '0';
	SIGNAL received_alu116     : std_logic;
	SIGNAL done_alu116         : std_logic;
	SIGNAL idle_alu116         : std_logic;

	SIGNAL pixel_alu117        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu117, im_alu117 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu117    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu117        : std_logic := '0';
	SIGNAL received_alu117     : std_logic;
	SIGNAL done_alu117         : std_logic;
	SIGNAL idle_alu117         : std_logic;

	SIGNAL pixel_alu118        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu118, im_alu118 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu118    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu118        : std_logic := '0';
	SIGNAL received_alu118     : std_logic;
	SIGNAL done_alu118         : std_logic;
	SIGNAL idle_alu118         : std_logic;

	SIGNAL pixel_alu119        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu119, im_alu119 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu119    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu119        : std_logic := '0';
	SIGNAL received_alu119     : std_logic;
	SIGNAL done_alu119         : std_logic;
	SIGNAL idle_alu119         : std_logic;
 
	SIGNAL pixel_alu120        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu120, im_alu120 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu120    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu120        : std_logic := '0';
	SIGNAL received_alu120     : std_logic;
	SIGNAL done_alu120         : std_logic;
	SIGNAL idle_alu120         : std_logic;
 
	SIGNAL pixel_alu121        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu121, im_alu121 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu121    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu121        : std_logic := '0';
	SIGNAL received_alu121     : std_logic;
	SIGNAL done_alu121         : std_logic;
	SIGNAL idle_alu121         : std_logic;
 
	SIGNAL pixel_alu122        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu122, im_alu122 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu122    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu122        : std_logic := '0';
	SIGNAL received_alu122     : std_logic;
	SIGNAL done_alu122         : std_logic;
	SIGNAL idle_alu122         : std_logic;
 
	SIGNAL pixel_alu123        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu123, im_alu123 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu123    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu123        : std_logic := '0';
	SIGNAL received_alu123     : std_logic;
	SIGNAL done_alu123         : std_logic;
	SIGNAL idle_alu123         : std_logic;
 
	SIGNAL pixel_alu124        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu124, im_alu124 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu124    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu124        : std_logic := '0';
	SIGNAL received_alu124     : std_logic;
	SIGNAL done_alu124         : std_logic;
	SIGNAL idle_alu124         : std_logic;
 
	SIGNAL pixel_alu125        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu125, im_alu125 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu125    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu125        : std_logic := '0';
	SIGNAL received_alu125     : std_logic;
	SIGNAL done_alu125         : std_logic;
	SIGNAL idle_alu125         : std_logic;
 
	SIGNAL pixel_alu126        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu126, im_alu126 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu126    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu126        : std_logic := '0';
	SIGNAL received_alu126     : std_logic;
	SIGNAL done_alu126         : std_logic;
	SIGNAL idle_alu126         : std_logic;
 
	SIGNAL pixel_alu127        : INTEGER RANGE 0 TO 6143;
	SIGNAL re_alu127, im_alu127 : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration_alu127    : std_logic_vector (9 DOWNTO 0) := "0000000000";
	SIGNAL start_alu127        : std_logic := '0';
	SIGNAL received_alu127     : std_logic;
	SIGNAL done_alu127         : std_logic;
	SIGNAL idle_alu127         : std_logic;

	--signals for adder ip core
	SIGNAL adder_a_valid, adder_b_valid, adder_result_ready : std_logic := '0';
	SIGNAL adder_a_ready, adder_b_ready, adder_result_valid : std_logic;
	SIGNAL adder_a, adder_b, adder_result                   : std_logic_vector (63 DOWNTO 0);

	COMPONENT complex_alu
		PORT 
		(
			re, im        : IN std_logic_vector (63 DOWNTO 0);
			iteration_out : OUT std_logic_vector (9 DOWNTO 0);
			start         : IN std_logic;
			clk           : IN std_logic;
			received      : IN std_logic;
			reset         : IN std_logic;
			done          : OUT std_logic;
			idle          : OUT std_logic
		);
	END COMPONENT;

	COMPONENT floating_point_adder
		PORT 
		(
			aclk                 : IN STD_LOGIC;
			s_axis_a_tvalid      : IN STD_LOGIC;
			s_axis_a_tready      : OUT STD_LOGIC;
			s_axis_a_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid      : IN STD_LOGIC;
			s_axis_b_tready      : OUT STD_LOGIC;
			s_axis_b_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata  : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);

	END COMPONENT;

BEGIN
	adder : floating_point_adder
	PORT MAP
	(
		aclk                 => clk, 
		s_axis_a_tvalid      => adder_a_valid, 
		s_axis_a_tready      => adder_a_ready, 
		s_axis_a_tdata       => adder_a, 
		s_axis_b_tvalid      => adder_b_valid, 
		s_axis_b_tready      => adder_b_ready, 
		s_axis_b_tdata       => adder_b, 
		m_axis_result_tvalid => adder_result_valid, 
		m_axis_result_tready => adder_result_ready, 
		m_axis_result_tdata  => adder_result
	);

	complex_alu_0 : complex_alu
	PORT MAP
	(
		re            => re_alu0, 
		im            => im_alu0, 
		iteration_out => iteration_alu0, 
		clk           => clk, 
		start         => start_alu0, 
		received      => received_alu0, 
		reset         => reset, 
		done          => done_alu0, 
		idle          => idle_alu0
	);

	complex_alu_1 : complex_alu
	PORT MAP
	(
		re            => re_alu1, 
		im            => im_alu1, 
		iteration_out => iteration_alu1, 
		clk           => clk, 
		start         => start_alu1, 
		received      => received_alu1, 
		reset         => reset, 
		done          => done_alu1, 
		idle          => idle_alu1
	);

	complex_alu_2 : complex_alu
	PORT MAP
	(
		re            => re_alu2, 
		im            => im_alu2, 
		iteration_out => iteration_alu2, 
		clk           => clk, 
		start         => start_alu2, 
		received      => received_alu2, 
		reset         => reset, 
		done          => done_alu2, 
		idle          => idle_alu2
	);

	complex_alu_3 : complex_alu
	PORT MAP
	(
		re            => re_alu3, 
		im            => im_alu3, 
		iteration_out => iteration_alu3, 
		clk           => clk, 
		start         => start_alu3, 
		received      => received_alu3, 
		reset         => reset, 
		done          => done_alu3, 
		idle          => idle_alu3
	);

	complex_alu_4 : complex_alu
	PORT MAP
	(
		re            => re_alu4, 
		im            => im_alu4, 
		iteration_out => iteration_alu4, 
		clk           => clk, 
		start         => start_alu4, 
		received      => received_alu4, 
		reset         => reset, 
		done          => done_alu4, 
		idle          => idle_alu4
	);

	complex_alu_5 : complex_alu
	PORT MAP
	(
		re            => re_alu5, 
		im            => im_alu5, 
		iteration_out => iteration_alu5, 
		clk           => clk, 
		start         => start_alu5, 
		received      => received_alu5, 
		reset         => reset, 
		done          => done_alu5, 
		idle          => idle_alu5
	);

	complex_alu_6 : complex_alu
	PORT MAP
	(
		re            => re_alu6, 
		im            => im_alu6, 
		iteration_out => iteration_alu6, 
		clk           => clk, 
		start         => start_alu6, 
		received      => received_alu6, 
		reset         => reset, 
		done          => done_alu6, 
		idle          => idle_alu6
	);

	complex_alu_7 : complex_alu
	PORT MAP
	(
		re            => re_alu7, 
		im            => im_alu7, 
		iteration_out => iteration_alu7, 
		clk           => clk, 
		start         => start_alu7, 
		received      => received_alu7, 
		reset         => reset, 
		done          => done_alu7, 
		idle          => idle_alu7
	);
	complex_alu_8 : complex_alu
	PORT MAP
	(
		re            => re_alu8, 
		im            => im_alu8, 
		iteration_out => iteration_alu8, 
		clk           => clk, 
		start         => start_alu8, 
		received      => received_alu8, 
		reset         => reset, 
		done          => done_alu8, 
		idle          => idle_alu8
	);

	complex_alu_9 : complex_alu
	PORT MAP
	(
		re            => re_alu9, 
		im            => im_alu9, 
		iteration_out => iteration_alu9, 
		clk           => clk, 
		start         => start_alu9, 
		received      => received_alu9, 
		reset         => reset, 
		done          => done_alu9, 
		idle          => idle_alu9
	);

	complex_alu_10 : complex_alu
	PORT MAP
	(
		re            => re_alu10, 
		im            => im_alu10, 
		iteration_out => iteration_alu10, 
		clk           => clk, 
		start         => start_alu10, 
		received      => received_alu10, 
		reset         => reset, 
		done          => done_alu10, 
		idle          => idle_alu10
	);

	complex_alu_11 : complex_alu
	PORT MAP
	(
		re            => re_alu11, 
		im            => im_alu11, 
		iteration_out => iteration_alu11, 
		clk           => clk, 
		start         => start_alu11, 
		received      => received_alu11, 
		reset         => reset, 
		done          => done_alu11, 
		idle          => idle_alu11
	);

	complex_alu_12 : complex_alu
	PORT MAP
	(
		re            => re_alu12, 
		im            => im_alu12, 
		iteration_out => iteration_alu12, 
		clk           => clk, 
		start         => start_alu12, 
		received      => received_alu12, 
		reset         => reset, 
		done          => done_alu12, 
		idle          => idle_alu12
	);

	complex_alu_13 : complex_alu
	PORT MAP
	(
		re            => re_alu13, 
		im            => im_alu13, 
		iteration_out => iteration_alu13, 
		clk           => clk, 
		start         => start_alu13, 
		received      => received_alu13, 
		reset         => reset, 
		done          => done_alu13, 
		idle          => idle_alu13
	);

	complex_alu_14 : complex_alu
	PORT MAP
	(
		re            => re_alu14, 
		im            => im_alu14, 
		iteration_out => iteration_alu14, 
		clk           => clk, 
		start         => start_alu14, 
		received      => received_alu14, 
		reset         => reset, 
		done          => done_alu14, 
		idle          => idle_alu14
	);

	complex_alu_15 : complex_alu
	PORT MAP
	(
		re            => re_alu15, 
		im            => im_alu15, 
		iteration_out => iteration_alu15, 
		clk           => clk, 
		start         => start_alu15, 
		received      => received_alu15, 
		reset         => reset, 
		done          => done_alu15, 
		idle          => idle_alu15
	);


	complex_alu_16 : complex_alu
	PORT MAP
	(
		re            => re_alu16, 
		im            => im_alu16, 
		iteration_out => iteration_alu16, 
		clk           => clk, 
		start         => start_alu16, 
		received      => received_alu16, 
		reset         => reset, 
		done          => done_alu16, 
		idle          => idle_alu16
	);

	complex_alu_17 : complex_alu
	PORT MAP
	(
		re            => re_alu17, 
		im            => im_alu17, 
		iteration_out => iteration_alu17, 
		clk           => clk, 
		start         => start_alu17, 
		received      => received_alu17, 
		reset         => reset, 
		done          => done_alu17, 
		idle          => idle_alu17
	);

	complex_alu_18 : complex_alu
	PORT MAP
	(
		re            => re_alu18, 
		im            => im_alu18, 
		iteration_out => iteration_alu18, 
		clk           => clk, 
		start         => start_alu18, 
		received      => received_alu18, 
		reset         => reset, 
		done          => done_alu18, 
		idle          => idle_alu18
	);

	complex_alu_19 : complex_alu
	PORT MAP
	(
		re            => re_alu19, 
		im            => im_alu19, 
		iteration_out => iteration_alu19, 
		clk           => clk, 
		start         => start_alu19, 
		received      => received_alu19, 
		reset         => reset, 
		done          => done_alu19, 
		idle          => idle_alu19
	);

	complex_alu_20 : complex_alu
	PORT MAP
	(
		re            => re_alu20, 
		im            => im_alu20, 
		iteration_out => iteration_alu20, 
		clk           => clk, 
		start         => start_alu20, 
		received      => received_alu20, 
		reset         => reset, 
		done          => done_alu20, 
		idle          => idle_alu20
	);

	complex_alu_21 : complex_alu
	PORT MAP
	(
		re            => re_alu21, 
		im            => im_alu21, 
		iteration_out => iteration_alu21, 
		clk           => clk, 
		start         => start_alu21, 
		received      => received_alu21, 
		reset         => reset, 
		done          => done_alu21, 
		idle          => idle_alu21
	);

	complex_alu_22 : complex_alu
	PORT MAP
	(
		re            => re_alu22, 
		im            => im_alu22, 
		iteration_out => iteration_alu22, 
		clk           => clk, 
		start         => start_alu22, 
		received      => received_alu22, 
		reset         => reset, 
		done          => done_alu22, 
		idle          => idle_alu22
	);

	complex_alu_23 : complex_alu
	PORT MAP
	(
		re            => re_alu23, 
		im            => im_alu23, 
		iteration_out => iteration_alu23, 
		clk           => clk, 
		start         => start_alu23, 
		received      => received_alu23, 
		reset         => reset, 
		done          => done_alu23, 
		idle          => idle_alu23
	);

	complex_alu_24 : complex_alu
	PORT MAP
	(
		re            => re_alu24, 
		im            => im_alu24, 
		iteration_out => iteration_alu24, 
		clk           => clk, 
		start         => start_alu24, 
		received      => received_alu24, 
		reset         => reset, 
		done          => done_alu24, 
		idle          => idle_alu24
	);

	complex_alu_25 : complex_alu
	PORT MAP
	(
		re            => re_alu25, 
		im            => im_alu25, 
		iteration_out => iteration_alu25, 
		clk           => clk, 
		start         => start_alu25, 
		received      => received_alu25, 
		reset         => reset, 
		done          => done_alu25, 
		idle          => idle_alu25
	);

	complex_alu_26 : complex_alu
	PORT MAP
	(
		re            => re_alu26, 
		im            => im_alu26, 
		iteration_out => iteration_alu26, 
		clk           => clk, 
		start         => start_alu26, 
		received      => received_alu26, 
		reset         => reset, 
		done          => done_alu26, 
		idle          => idle_alu26
	);

	complex_alu_27 : complex_alu
	PORT MAP
	(
		re            => re_alu27, 
		im            => im_alu27, 
		iteration_out => iteration_alu27, 
		clk           => clk, 
		start         => start_alu27, 
		received      => received_alu27, 
		reset         => reset, 
		done          => done_alu27, 
		idle          => idle_alu27
	);

	complex_alu_28 : complex_alu
	PORT MAP
	(
		re            => re_alu28, 
		im            => im_alu28, 
		iteration_out => iteration_alu28, 
		clk           => clk, 
		start         => start_alu28, 
		received      => received_alu28, 
		reset         => reset, 
		done          => done_alu28, 
		idle          => idle_alu28
	);

	complex_alu_29 : complex_alu
	PORT MAP
	(
		re            => re_alu29, 
		im            => im_alu29, 
		iteration_out => iteration_alu29, 
		clk           => clk, 
		start         => start_alu29, 
		received      => received_alu29, 
		reset         => reset, 
		done          => done_alu29, 
		idle          => idle_alu29
	);

	complex_alu_30 : complex_alu
	PORT MAP
	(
		re            => re_alu30, 
		im            => im_alu30, 
		iteration_out => iteration_alu30, 
		clk           => clk, 
		start         => start_alu30, 
		received      => received_alu30, 
		reset         => reset, 
		done          => done_alu30, 
		idle          => idle_alu30
	);

	complex_alu_31 : complex_alu
	PORT MAP
	(
		re            => re_alu31, 
		im            => im_alu31, 
		iteration_out => iteration_alu31, 
		clk           => clk, 
		start         => start_alu31, 
		received      => received_alu31, 
		reset         => reset, 
		done          => done_alu31, 
		idle          => idle_alu31
	);

	complex_alu_32 : complex_alu
	PORT MAP
	(
		re            => re_alu32, 
		im            => im_alu32, 
		iteration_out => iteration_alu32, 
		clk           => clk, 
		start         => start_alu32, 
		received      => received_alu32, 
		reset         => reset, 
		done          => done_alu32, 
		idle          => idle_alu32
	);

	complex_alu_33 : complex_alu
	PORT MAP
	(
		re            => re_alu33, 
		im            => im_alu33, 
		iteration_out => iteration_alu33, 
		clk           => clk, 
		start         => start_alu33, 
		received      => received_alu33, 
		reset         => reset, 
		done          => done_alu33, 
		idle          => idle_alu33
	);

	complex_alu_34 : complex_alu
	PORT MAP
	(
		re            => re_alu34, 
		im            => im_alu34, 
		iteration_out => iteration_alu34, 
		clk           => clk, 
		start         => start_alu34, 
		received      => received_alu34, 
		reset         => reset, 
		done          => done_alu34, 
		idle          => idle_alu34
	);

	complex_alu_35 : complex_alu
	PORT MAP
	(
		re            => re_alu35, 
		im            => im_alu35, 
		iteration_out => iteration_alu35, 
		clk           => clk, 
		start         => start_alu35, 
		received      => received_alu35, 
		reset         => reset, 
		done          => done_alu35, 
		idle          => idle_alu35
	);

	complex_alu_36 : complex_alu
	PORT MAP
	(
		re            => re_alu36, 
		im            => im_alu36, 
		iteration_out => iteration_alu36, 
		clk           => clk, 
		start         => start_alu36, 
		received      => received_alu36, 
		reset         => reset, 
		done          => done_alu36, 
		idle          => idle_alu36
	);

	complex_alu_37 : complex_alu
	PORT MAP
	(
		re            => re_alu37, 
		im            => im_alu37, 
		iteration_out => iteration_alu37, 
		clk           => clk, 
		start         => start_alu37, 
		received      => received_alu37, 
		reset         => reset, 
		done          => done_alu37, 
		idle          => idle_alu37
	);

	complex_alu_38 : complex_alu
	PORT MAP
	(
		re            => re_alu38, 
		im            => im_alu38, 
		iteration_out => iteration_alu38, 
		clk           => clk, 
		start         => start_alu38, 
		received      => received_alu38, 
		reset         => reset, 
		done          => done_alu38, 
		idle          => idle_alu38
	);

	complex_alu_39 : complex_alu
	PORT MAP
	(
		re            => re_alu39, 
		im            => im_alu39, 
		iteration_out => iteration_alu39, 
		clk           => clk, 
		start         => start_alu39, 
		received      => received_alu39, 
		reset         => reset, 
		done          => done_alu39, 
		idle          => idle_alu39
	);
	complex_alu_40 : complex_alu
	PORT MAP
	(
		re            => re_alu40, 
		im            => im_alu40, 
		iteration_out => iteration_alu40, 
		clk           => clk, 
		start         => start_alu40, 
		received      => received_alu40, 
		reset         => reset, 
		done          => done_alu40, 
		idle          => idle_alu40
	);

	complex_alu_41 : complex_alu
	PORT MAP
	(
		re            => re_alu41, 
		im            => im_alu41, 
		iteration_out => iteration_alu41, 
		clk           => clk, 
		start         => start_alu41, 
		received      => received_alu41, 
		reset         => reset, 
		done          => done_alu41, 
		idle          => idle_alu41
	);

	complex_alu_42 : complex_alu
	PORT MAP
	(
		re            => re_alu42, 
		im            => im_alu42, 
		iteration_out => iteration_alu42, 
		clk           => clk, 
		start         => start_alu42, 
		received      => received_alu42, 
		reset         => reset, 
		done          => done_alu42, 
		idle          => idle_alu42
	);

	complex_alu_43 : complex_alu
	PORT MAP
	(
		re            => re_alu43, 
		im            => im_alu43, 
		iteration_out => iteration_alu43, 
		clk           => clk, 
		start         => start_alu43, 
		received      => received_alu43, 
		reset         => reset, 
		done          => done_alu43, 
		idle          => idle_alu43
	);

	complex_alu_44 : complex_alu
	PORT MAP
	(
		re            => re_alu44, 
		im            => im_alu44, 
		iteration_out => iteration_alu44, 
		clk           => clk, 
		start         => start_alu44, 
		received      => received_alu44, 
		reset         => reset, 
		done          => done_alu44, 
		idle          => idle_alu44
	);

	complex_alu_45 : complex_alu
	PORT MAP
	(
		re            => re_alu45, 
		im            => im_alu45, 
		iteration_out => iteration_alu45, 
		clk           => clk, 
		start         => start_alu45, 
		received      => received_alu45, 
		reset         => reset, 
		done          => done_alu45, 
		idle          => idle_alu45
	);

	complex_alu_46 : complex_alu
	PORT MAP
	(
		re            => re_alu46, 
		im            => im_alu46, 
		iteration_out => iteration_alu46, 
		clk           => clk, 
		start         => start_alu46, 
		received      => received_alu46, 
		reset         => reset, 
		done          => done_alu46, 
		idle          => idle_alu46
	);

	complex_alu_47 : complex_alu
	PORT MAP
	(
		re            => re_alu47, 
		im            => im_alu47, 
		iteration_out => iteration_alu47, 
		clk           => clk, 
		start         => start_alu47, 
		received      => received_alu47, 
		reset         => reset, 
		done          => done_alu47, 
		idle          => idle_alu47
	);


	complex_alu_48 : complex_alu
	PORT MAP
	(
		re            => re_alu48, 
		im            => im_alu48, 
		iteration_out => iteration_alu48, 
		clk           => clk, 
		start         => start_alu48, 
		received      => received_alu48, 
		reset         => reset, 
		done          => done_alu48, 
		idle          => idle_alu48
	);

	complex_alu_49 : complex_alu
	PORT MAP
	(
		re            => re_alu49, 
		im            => im_alu49, 
		iteration_out => iteration_alu49, 
		clk           => clk, 
		start         => start_alu49, 
		received      => received_alu49, 
		reset         => reset, 
		done          => done_alu49, 
		idle          => idle_alu49
	);

	complex_alu_50 : complex_alu
	PORT MAP
	(
		re            => re_alu50, 
		im            => im_alu50, 
		iteration_out => iteration_alu50, 
		clk           => clk, 
		start         => start_alu50, 
		received      => received_alu50, 
		reset         => reset, 
		done          => done_alu50, 
		idle          => idle_alu50
	);

	complex_alu_51 : complex_alu
	PORT MAP
	(
		re            => re_alu51, 
		im            => im_alu51, 
		iteration_out => iteration_alu51, 
		clk           => clk, 
		start         => start_alu51, 
		received      => received_alu51, 
		reset         => reset, 
		done          => done_alu51, 
		idle          => idle_alu51
	);

	complex_alu_52 : complex_alu
	PORT MAP
	(
		re            => re_alu52, 
		im            => im_alu52, 
		iteration_out => iteration_alu52, 
		clk           => clk, 
		start         => start_alu52, 
		received      => received_alu52, 
		reset         => reset, 
		done          => done_alu52, 
		idle          => idle_alu52
	);

	complex_alu_53 : complex_alu
	PORT MAP
	(
		re            => re_alu53, 
		im            => im_alu53, 
		iteration_out => iteration_alu53, 
		clk           => clk, 
		start         => start_alu53, 
		received      => received_alu53, 
		reset         => reset, 
		done          => done_alu53, 
		idle          => idle_alu53
	);

	complex_alu_54 : complex_alu
	PORT MAP
	(
		re            => re_alu54, 
		im            => im_alu54, 
		iteration_out => iteration_alu54, 
		clk           => clk, 
		start         => start_alu54, 
		received      => received_alu54, 
		reset         => reset, 
		done          => done_alu54, 
		idle          => idle_alu54
	);

	complex_alu_55 : complex_alu
	PORT MAP
	(
		re            => re_alu55, 
		im            => im_alu55, 
		iteration_out => iteration_alu55, 
		clk           => clk, 
		start         => start_alu55, 
		received      => received_alu55, 
		reset         => reset, 
		done          => done_alu55, 
		idle          => idle_alu55
	);

	complex_alu_56 : complex_alu
	PORT MAP
	(
		re            => re_alu56, 
		im            => im_alu56, 
		iteration_out => iteration_alu56, 
		clk           => clk, 
		start         => start_alu56, 
		received      => received_alu56, 
		reset         => reset, 
		done          => done_alu56, 
		idle          => idle_alu56
	);

	complex_alu_57 : complex_alu
	PORT MAP
	(
		re            => re_alu57, 
		im            => im_alu57, 
		iteration_out => iteration_alu57, 
		clk           => clk, 
		start         => start_alu57, 
		received      => received_alu57, 
		reset         => reset, 
		done          => done_alu57, 
		idle          => idle_alu57
	);

	complex_alu_58 : complex_alu
	PORT MAP
	(
		re            => re_alu58, 
		im            => im_alu58, 
		iteration_out => iteration_alu58, 
		clk           => clk, 
		start         => start_alu58, 
		received      => received_alu58, 
		reset         => reset, 
		done          => done_alu58, 
		idle          => idle_alu58
	);

	complex_alu_59 : complex_alu
	PORT MAP
	(
		re            => re_alu59, 
		im            => im_alu59, 
		iteration_out => iteration_alu59, 
		clk           => clk, 
		start         => start_alu59, 
		received      => received_alu59, 
		reset         => reset, 
		done          => done_alu59, 
		idle          => idle_alu59
	);

	complex_alu_60 : complex_alu
	PORT MAP
	(
		re            => re_alu60, 
		im            => im_alu60, 
		iteration_out => iteration_alu60, 
		clk           => clk, 
		start         => start_alu60, 
		received      => received_alu60, 
		reset         => reset, 
		done          => done_alu60, 
		idle          => idle_alu60
	);

	complex_alu_61 : complex_alu
	PORT MAP
	(
		re            => re_alu61, 
		im            => im_alu61, 
		iteration_out => iteration_alu61, 
		clk           => clk, 
		start         => start_alu61, 
		received      => received_alu61, 
		reset         => reset, 
		done          => done_alu61, 
		idle          => idle_alu61
	);

	complex_alu_62 : complex_alu
	PORT MAP
	(
		re            => re_alu62, 
		im            => im_alu62, 
		iteration_out => iteration_alu62, 
		clk           => clk, 
		start         => start_alu62, 
		received      => received_alu62, 
		reset         => reset, 
		done          => done_alu62, 
		idle          => idle_alu62
	);

	complex_alu_63 : complex_alu
	PORT MAP
	(
		re            => re_alu63, 
		im            => im_alu63, 
		iteration_out => iteration_alu63, 
		clk           => clk, 
		start         => start_alu63, 
		received      => received_alu63, 
		reset         => reset, 
		done          => done_alu63, 
		idle          => idle_alu63
	);


	complex_alu_64 : complex_alu
	PORT MAP
	(
		re            => re_alu64, 
		im            => im_alu64, 
		iteration_out => iteration_alu64, 
		clk           => clk, 
		start         => start_alu64, 
		received      => received_alu64, 
		reset         => reset, 
		done          => done_alu64, 
		idle          => idle_alu64
	);

	complex_alu_65 : complex_alu
	PORT MAP
	(
		re            => re_alu65, 
		im            => im_alu65, 
		iteration_out => iteration_alu65, 
		clk           => clk, 
		start         => start_alu65, 
		received      => received_alu65, 
		reset         => reset, 
		done          => done_alu65, 
		idle          => idle_alu65
	);

	complex_alu_66 : complex_alu
	PORT MAP
	(
		re            => re_alu66, 
		im            => im_alu66, 
		iteration_out => iteration_alu66, 
		clk           => clk, 
		start         => start_alu66, 
		received      => received_alu66, 
		reset         => reset, 
		done          => done_alu66, 
		idle          => idle_alu66
	);

	complex_alu_67 : complex_alu
	PORT MAP
	(
		re            => re_alu67, 
		im            => im_alu67, 
		iteration_out => iteration_alu67, 
		clk           => clk, 
		start         => start_alu67, 
		received      => received_alu67, 
		reset         => reset, 
		done          => done_alu67, 
		idle          => idle_alu76
	);

	complex_alu_68 : complex_alu
	PORT MAP
	(
		re            => re_alu68, 
		im            => im_alu68, 
		iteration_out => iteration_alu68, 
		clk           => clk, 
		start         => start_alu68, 
		received      => received_alu68, 
		reset         => reset, 
		done          => done_alu68, 
		idle          => idle_alu68
	);

	complex_alu_69 : complex_alu
	PORT MAP
	(
		re            => re_alu69, 
		im            => im_alu69, 
		iteration_out => iteration_alu69, 
		clk           => clk, 
		start         => start_alu69, 
		received      => received_alu69, 
		reset         => reset, 
		done          => done_alu69, 
		idle          => idle_alu69
	);

	complex_alu_70 : complex_alu
	PORT MAP
	(
		re            => re_alu70, 
		im            => im_alu70, 
		iteration_out => iteration_alu70, 
		clk           => clk, 
		start         => start_alu70, 
		received      => received_alu70, 
		reset         => reset, 
		done          => done_alu70, 
		idle          => idle_alu70
	);

	complex_alu_71 : complex_alu
	PORT MAP
	(
		re            => re_alu71, 
		im            => im_alu71, 
		iteration_out => iteration_alu71, 
		clk           => clk, 
		start         => start_alu71, 
		received      => received_alu71, 
		reset         => reset, 
		done          => done_alu71, 
		idle          => idle_alu71
	);
	complex_alu_72 : complex_alu
	PORT MAP
	(
		re            => re_alu72, 
		im            => im_alu72, 
		iteration_out => iteration_alu72, 
		clk           => clk, 
		start         => start_alu72, 
		received      => received_alu72, 
		reset         => reset, 
		done          => done_alu72, 
		idle          => idle_alu72
	);

	complex_alu_73 : complex_alu
	PORT MAP
	(
		re            => re_alu73, 
		im            => im_alu73, 
		iteration_out => iteration_alu73, 
		clk           => clk, 
		start         => start_alu73, 
		received      => received_alu73, 
		reset         => reset, 
		done          => done_alu73, 
		idle          => idle_alu73
	);

	complex_alu_74 : complex_alu
	PORT MAP
	(
		re            => re_alu74, 
		im            => im_alu74, 
		iteration_out => iteration_alu74, 
		clk           => clk, 
		start         => start_alu74, 
		received      => received_alu74, 
		reset         => reset, 
		done          => done_alu74, 
		idle          => idle_alu74
	);

	complex_alu_75 : complex_alu
	PORT MAP
	(
		re            => re_alu75, 
		im            => im_alu75, 
		iteration_out => iteration_alu75, 
		clk           => clk, 
		start         => start_alu75, 
		received      => received_alu75, 
		reset         => reset, 
		done          => done_alu75, 
		idle          => idle_alu75
	);

	complex_alu_76 : complex_alu
	PORT MAP
	(
		re            => re_alu76, 
		im            => im_alu76, 
		iteration_out => iteration_alu76, 
		clk           => clk, 
		start         => start_alu76, 
		received      => received_alu76, 
		reset         => reset, 
		done          => done_alu76, 
		idle          => idle_alu76
	);

	complex_alu_77 : complex_alu
	PORT MAP
	(
		re            => re_alu77, 
		im            => im_alu77, 
		iteration_out => iteration_alu77, 
		clk           => clk, 
		start         => start_alu77, 
		received      => received_alu77, 
		reset         => reset, 
		done          => done_alu77, 
		idle          => idle_alu77
	);

	complex_alu_78 : complex_alu
	PORT MAP
	(
		re            => re_alu78, 
		im            => im_alu78, 
		iteration_out => iteration_alu78, 
		clk           => clk, 
		start         => start_alu78, 
		received      => received_alu78, 
		reset         => reset, 
		done          => done_alu78, 
		idle          => idle_alu78
	);

	complex_alu_79 : complex_alu
	PORT MAP
	(
		re            => re_alu79, 
		im            => im_alu79, 
		iteration_out => iteration_alu79, 
		clk           => clk, 
		start         => start_alu79, 
		received      => received_alu79, 
		reset         => reset, 
		done          => done_alu79, 
		idle          => idle_alu79
	);


	complex_alu_80 : complex_alu
	PORT MAP
	(
		re            => re_alu80, 
		im            => im_alu80, 
		iteration_out => iteration_alu80, 
		clk           => clk, 
		start         => start_alu80, 
		received      => received_alu80, 
		reset         => reset, 
		done          => done_alu80, 
		idle          => idle_alu80
	);

	complex_alu_81 : complex_alu
	PORT MAP
	(
		re            => re_alu81, 
		im            => im_alu81, 
		iteration_out => iteration_alu81, 
		clk           => clk, 
		start         => start_alu81, 
		received      => received_alu81, 
		reset         => reset, 
		done          => done_alu81, 
		idle          => idle_alu81
	);

	complex_alu_82 : complex_alu
	PORT MAP
	(
		re            => re_alu82, 
		im            => im_alu82, 
		iteration_out => iteration_alu82, 
		clk           => clk, 
		start         => start_alu82, 
		received      => received_alu82, 
		reset         => reset, 
		done          => done_alu82, 
		idle          => idle_alu82
	);

	complex_alu_83 : complex_alu
	PORT MAP
	(
		re            => re_alu83, 
		im            => im_alu83, 
		iteration_out => iteration_alu83, 
		clk           => clk, 
		start         => start_alu83, 
		received      => received_alu83, 
		reset         => reset, 
		done          => done_alu83, 
		idle          => idle_alu83
	);

	complex_alu_84 : complex_alu
	PORT MAP
	(
		re            => re_alu84, 
		im            => im_alu84, 
		iteration_out => iteration_alu84, 
		clk           => clk, 
		start         => start_alu84, 
		received      => received_alu84, 
		reset         => reset, 
		done          => done_alu84, 
		idle          => idle_alu84
	);

	complex_alu_85 : complex_alu
	PORT MAP
	(
		re            => re_alu85, 
		im            => im_alu85, 
		iteration_out => iteration_alu85, 
		clk           => clk, 
		start         => start_alu85, 
		received      => received_alu85, 
		reset         => reset, 
		done          => done_alu85, 
		idle          => idle_alu85
	);

	complex_alu_86 : complex_alu
	PORT MAP
	(
		re            => re_alu86, 
		im            => im_alu86, 
		iteration_out => iteration_alu86, 
		clk           => clk, 
		start         => start_alu86, 
		received      => received_alu86, 
		reset         => reset, 
		done          => done_alu86, 
		idle          => idle_alu86
	);

	complex_alu_87 : complex_alu
	PORT MAP
	(
		re            => re_alu87, 
		im            => im_alu87, 
		iteration_out => iteration_alu87, 
		clk           => clk, 
		start         => start_alu87, 
		received      => received_alu87, 
		reset         => reset, 
		done          => done_alu87, 
		idle          => idle_alu87
	);

	complex_alu_88 : complex_alu
	PORT MAP
	(
		re            => re_alu88, 
		im            => im_alu88, 
		iteration_out => iteration_alu88, 
		clk           => clk, 
		start         => start_alu88, 
		received      => received_alu88, 
		reset         => reset, 
		done          => done_alu88, 
		idle          => idle_alu88
	);

	complex_alu_89 : complex_alu
	PORT MAP
	(
		re            => re_alu89, 
		im            => im_alu89, 
		iteration_out => iteration_alu89, 
		clk           => clk, 
		start         => start_alu89, 
		received      => received_alu89, 
		reset         => reset, 
		done          => done_alu89, 
		idle          => idle_alu89
	);

	complex_alu_90 : complex_alu
	PORT MAP
	(
		re            => re_alu90, 
		im            => im_alu90, 
		iteration_out => iteration_alu90, 
		clk           => clk, 
		start         => start_alu90, 
		received      => received_alu90, 
		reset         => reset, 
		done          => done_alu90, 
		idle          => idle_alu90
	);

	complex_alu_91 : complex_alu
	PORT MAP
	(
		re            => re_alu91, 
		im            => im_alu91, 
		iteration_out => iteration_alu91, 
		clk           => clk, 
		start         => start_alu91, 
		received      => received_alu91, 
		reset         => reset, 
		done          => done_alu91, 
		idle          => idle_alu91
	);

	complex_alu_92 : complex_alu
	PORT MAP
	(
		re            => re_alu92, 
		im            => im_alu92, 
		iteration_out => iteration_alu92, 
		clk           => clk, 
		start         => start_alu92, 
		received      => received_alu92, 
		reset         => reset, 
		done          => done_alu92, 
		idle          => idle_alu82
	);

	complex_alu_93 : complex_alu
	PORT MAP
	(
		re            => re_alu93, 
		im            => im_alu93, 
		iteration_out => iteration_alu93, 
		clk           => clk, 
		start         => start_alu93, 
		received      => received_alu93, 
		reset         => reset, 
		done          => done_alu93, 
		idle          => idle_alu93
	);

	complex_alu_94 : complex_alu
	PORT MAP
	(
		re            => re_alu94, 
		im            => im_alu94, 
		iteration_out => iteration_alu94, 
		clk           => clk, 
		start         => start_alu94, 
		received      => received_alu94, 
		reset         => reset, 
		done          => done_alu94, 
		idle          => idle_alu94
	);

	complex_alu_95 : complex_alu
	PORT MAP
	(
		re            => re_alu95, 
		im            => im_alu95, 
		iteration_out => iteration_alu95, 
		clk           => clk, 
		start         => start_alu95, 
		received      => received_alu95, 
		reset         => reset, 
		done          => done_alu95, 
		idle          => idle_alu95
	);

	complex_alu_96 : complex_alu
	PORT MAP
	(
		re            => re_alu96, 
		im            => im_alu96, 
		iteration_out => iteration_alu96, 
		clk           => clk, 
		start         => start_alu96, 
		received      => received_alu96, 
		reset         => reset, 
		done          => done_alu96, 
		idle          => idle_alu96
	);

	complex_alu_97 : complex_alu
	PORT MAP
	(
		re            => re_alu97, 
		im            => im_alu97, 
		iteration_out => iteration_alu97, 
		clk           => clk, 
		start         => start_alu97, 
		received      => received_alu97, 
		reset         => reset, 
		done          => done_alu97, 
		idle          => idle_alu97
	);

	complex_alu_98 : complex_alu
	PORT MAP
	(
		re            => re_alu98, 
		im            => im_alu98, 
		iteration_out => iteration_alu98, 
		clk           => clk, 
		start         => start_alu98, 
		received      => received_alu98, 
		reset         => reset, 
		done          => done_alu98, 
		idle          => idle_alu98
	);

	complex_alu_99 : complex_alu
	PORT MAP
	(
		re            => re_alu99, 
		im            => im_alu99, 
		iteration_out => iteration_alu99, 
		clk           => clk, 
		start         => start_alu99, 
		received      => received_alu99, 
		reset         => reset, 
		done          => done_alu99, 
		idle          => idle_alu99
	);

	complex_alu_100 : complex_alu
	PORT MAP
	(
		re            => re_alu100, 
		im            => im_alu100, 
		iteration_out => iteration_alu100, 
		clk           => clk, 
		start         => start_alu100, 
		received      => received_alu100, 
		reset         => reset, 
		done          => done_alu100, 
		idle          => idle_alu100
	);

	complex_alu_101 : complex_alu
	PORT MAP
	(
		re            => re_alu101, 
		im            => im_alu101, 
		iteration_out => iteration_alu101, 
		clk           => clk, 
		start         => start_alu101, 
		received      => received_alu101, 
		reset         => reset, 
		done          => done_alu101, 
		idle          => idle_alu101
	);

	complex_alu_102 : complex_alu
	PORT MAP
	(
		re            => re_alu102, 
		im            => im_alu102, 
		iteration_out => iteration_alu102, 
		clk           => clk, 
		start         => start_alu102, 
		received      => received_alu102, 
		reset         => reset, 
		done          => done_alu102, 
		idle          => idle_alu102
	);

	complex_alu_103 : complex_alu
	PORT MAP
	(
		re            => re_alu103, 
		im            => im_alu103, 
		iteration_out => iteration_alu103, 
		clk           => clk, 
		start         => start_alu103, 
		received      => received_alu103, 
		reset         => reset, 
		done          => done_alu103, 
		idle          => idle_alu103
	);
	complex_alu_104 : complex_alu
	PORT MAP
	(
		re            => re_alu104, 
		im            => im_alu104, 
		iteration_out => iteration_alu104, 
		clk           => clk, 
		start         => start_alu104, 
		received      => received_alu104, 
		reset         => reset, 
		done          => done_alu104, 
		idle          => idle_alu104
	);

	complex_alu_105 : complex_alu
	PORT MAP
	(
		re            => re_alu105, 
		im            => im_alu105, 
		iteration_out => iteration_alu105, 
		clk           => clk, 
		start         => start_alu105, 
		received      => received_alu105, 
		reset         => reset, 
		done          => done_alu105, 
		idle          => idle_alu105
	);

	complex_alu_106 : complex_alu
	PORT MAP
	(
		re            => re_alu106, 
		im            => im_alu106, 
		iteration_out => iteration_alu106, 
		clk           => clk, 
		start         => start_alu106, 
		received      => received_alu106, 
		reset         => reset, 
		done          => done_alu106, 
		idle          => idle_alu106
	);

	complex_alu_107 : complex_alu
	PORT MAP
	(
		re            => re_alu107, 
		im            => im_alu107, 
		iteration_out => iteration_alu107, 
		clk           => clk, 
		start         => start_alu107, 
		received      => received_alu107, 
		reset         => reset, 
		done          => done_alu107, 
		idle          => idle_alu107
	);

	complex_alu_108 : complex_alu
	PORT MAP
	(
		re            => re_alu108, 
		im            => im_alu108, 
		iteration_out => iteration_alu108, 
		clk           => clk, 
		start         => start_alu108, 
		received      => received_alu108, 
		reset         => reset, 
		done          => done_alu108, 
		idle          => idle_alu108
	);

	complex_alu_109 : complex_alu
	PORT MAP
	(
		re            => re_alu109, 
		im            => im_alu109, 
		iteration_out => iteration_alu109, 
		clk           => clk, 
		start         => start_alu109, 
		received      => received_alu109, 
		reset         => reset, 
		done          => done_alu109, 
		idle          => idle_alu109
	);

	complex_alu_110 : complex_alu
	PORT MAP
	(
		re            => re_alu110, 
		im            => im_alu110, 
		iteration_out => iteration_alu110, 
		clk           => clk, 
		start         => start_alu110, 
		received      => received_alu110, 
		reset         => reset, 
		done          => done_alu110, 
		idle          => idle_alu110
	);

	complex_alu_111 : complex_alu
	PORT MAP
	(
		re            => re_alu111, 
		im            => im_alu111, 
		iteration_out => iteration_alu111, 
		clk           => clk, 
		start         => start_alu111, 
		received      => received_alu111, 
		reset         => reset, 
		done          => done_alu111, 
		idle          => idle_alu111
	);


	complex_alu_112 : complex_alu
	PORT MAP
	(
		re            => re_alu112, 
		im            => im_alu112, 
		iteration_out => iteration_alu112, 
		clk           => clk, 
		start         => start_alu112, 
		received      => received_alu112, 
		reset         => reset, 
		done          => done_alu112, 
		idle          => idle_alu112
	);

	complex_alu_113 : complex_alu
	PORT MAP
	(
		re            => re_alu113, 
		im            => im_alu113, 
		iteration_out => iteration_alu113, 
		clk           => clk, 
		start         => start_alu113, 
		received      => received_alu113, 
		reset         => reset, 
		done          => done_alu113, 
		idle          => idle_alu113
	);

	complex_alu_114 : complex_alu
	PORT MAP
	(
		re            => re_alu114, 
		im            => im_alu114, 
		iteration_out => iteration_alu114, 
		clk           => clk, 
		start         => start_alu114, 
		received      => received_alu114, 
		reset         => reset, 
		done          => done_alu114, 
		idle          => idle_alu114
	);

	complex_alu_115 : complex_alu
	PORT MAP
	(
		re            => re_alu115, 
		im            => im_alu115, 
		iteration_out => iteration_alu115, 
		clk           => clk, 
		start         => start_alu115, 
		received      => received_alu115, 
		reset         => reset, 
		done          => done_alu115, 
		idle          => idle_alu115
	);

	complex_alu_116 : complex_alu
	PORT MAP
	(
		re            => re_alu116, 
		im            => im_alu116, 
		iteration_out => iteration_alu116, 
		clk           => clk, 
		start         => start_alu116, 
		received      => received_alu116, 
		reset         => reset, 
		done          => done_alu116, 
		idle          => idle_alu116
	);

	complex_alu_117 : complex_alu
	PORT MAP
	(
		re            => re_alu117, 
		im            => im_alu117, 
		iteration_out => iteration_alu117, 
		clk           => clk, 
		start         => start_alu117, 
		received      => received_alu117, 
		reset         => reset, 
		done          => done_alu117, 
		idle          => idle_alu117
	);

	complex_alu_118 : complex_alu
	PORT MAP
	(
		re            => re_alu118, 
		im            => im_alu118, 
		iteration_out => iteration_alu118, 
		clk           => clk, 
		start         => start_alu118, 
		received      => received_alu118, 
		reset         => reset, 
		done          => done_alu118, 
		idle          => idle_alu118
	);

	complex_alu_119 : complex_alu
	PORT MAP
	(
		re            => re_alu119, 
		im            => im_alu119, 
		iteration_out => iteration_alu119, 
		clk           => clk, 
		start         => start_alu119, 
		received      => received_alu119, 
		reset         => reset, 
		done          => done_alu119, 
		idle          => idle_alu119
	);

	complex_alu_120 : complex_alu
	PORT MAP
	(
		re            => re_alu120, 
		im            => im_alu120, 
		iteration_out => iteration_alu120, 
		clk           => clk, 
		start         => start_alu120, 
		received      => received_alu120, 
		reset         => reset, 
		done          => done_alu120, 
		idle          => idle_alu120
	);

	complex_alu_121 : complex_alu
	PORT MAP
	(
		re            => re_alu121, 
		im            => im_alu121, 
		iteration_out => iteration_alu121, 
		clk           => clk, 
		start         => start_alu121, 
		received      => received_alu121, 
		reset         => reset, 
		done          => done_alu121, 
		idle          => idle_alu121
	);

	complex_alu_122 : complex_alu
	PORT MAP
	(
		re            => re_alu122, 
		im            => im_alu122, 
		iteration_out => iteration_alu122, 
		clk           => clk, 
		start         => start_alu122, 
		received      => received_alu122, 
		reset         => reset, 
		done          => done_alu122, 
		idle          => idle_alu112
	);

	complex_alu_123 : complex_alu
	PORT MAP
	(
		re            => re_alu123, 
		im            => im_alu123, 
		iteration_out => iteration_alu123, 
		clk           => clk, 
		start         => start_alu123, 
		received      => received_alu123, 
		reset         => reset, 
		done          => done_alu123, 
		idle          => idle_alu123
	);

	complex_alu_124 : complex_alu
	PORT MAP
	(
		re            => re_alu124, 
		im            => im_alu124, 
		iteration_out => iteration_alu124, 
		clk           => clk, 
		start         => start_alu124, 
		received      => received_alu124, 
		reset         => reset, 
		done          => done_alu124, 
		idle          => idle_alu124
	);

	complex_alu_125 : complex_alu
	PORT MAP
	(
		re            => re_alu125, 
		im            => im_alu125, 
		iteration_out => iteration_alu125, 
		clk           => clk, 
		start         => start_alu125, 
		received      => received_alu125, 
		reset         => reset, 
		done          => done_alu125, 
		idle          => idle_alu125
	);

	complex_alu_126 : complex_alu
	PORT MAP
	(
		re            => re_alu126, 
		im            => im_alu126, 
		iteration_out => iteration_alu126, 
		clk           => clk, 
		start         => start_alu126, 
		received      => received_alu126, 
		reset         => reset, 
		done          => done_alu126, 
		idle          => idle_alu126
	);

	complex_alu_127 : complex_alu
	PORT MAP
	(
		re            => re_alu127, 
		im            => im_alu127, 
		iteration_out => iteration_alu127, 
		clk           => clk, 
		start         => start_alu127, 
		received      => received_alu127, 
		reset         => reset, 
		done          => done_alu127, 
		idle          => idle_alu127
	);

	--next state process
	next_state : PROCESS (clk) IS BEGIN
		IF rising_edge(clk) THEN
			IF (reset = '1') THEN
				math_state <= idle;
			ELSE
				math_state <= math_state_next;
			END IF;
		END IF;
	END PROCESS;

	--transitions
	outputs : PROCESS (math_state)
		IS BEGIN
		re_received        <= '0';
		im_received        <= '0';
		zf_received        <= '0';
		picture_done       <= '0';
		pixel_done         <= '0';
		start_alu0         <= '0';
		start_alu1         <= '0';
		start_alu2         <= '0';
		start_alu3         <= '0';
		start_alu4         <= '0';
		start_alu5         <= '0';
		start_alu6         <= '0';
		start_alu7         <= '0';
		start_alu8         <= '0';
		start_alu9         <= '0';
		start_alu10        <= '0';
		start_alu11        <= '0';
		start_alu12        <= '0';
		start_alu13        <= '0';
		start_alu14        <= '0';
		start_alu15        <= '0';
		start_alu16        <= '0';
		start_alu17        <= '0';
		start_alu18        <= '0';
		start_alu19        <= '0';
		start_alu20        <= '0';
		start_alu21        <= '0';
		start_alu22        <= '0';
		start_alu23        <= '0';
		start_alu24        <= '0';
		start_alu25        <= '0';
		start_alu26        <= '0';
		start_alu27        <= '0';
		start_alu28        <= '0';
		start_alu29        <= '0';
		start_alu30        <= '0';
		start_alu31        <= '0';
		start_alu32         <= '0';
		start_alu33         <= '0';
		start_alu34         <= '0';
		start_alu35         <= '0';
		start_alu36         <= '0';
		start_alu37         <= '0';
		start_alu38         <= '0';
		start_alu39         <= '0';
		start_alu40         <= '0';
		start_alu41         <= '0';
		start_alu42        <= '0';
		start_alu43        <= '0';
		start_alu44        <= '0';
		start_alu45        <= '0';
		start_alu46        <= '0';
		start_alu47        <= '0';
		start_alu48        <= '0';
		start_alu49        <= '0';
		start_alu50        <= '0';
		start_alu51        <= '0';
		start_alu52        <= '0';
		start_alu53        <= '0';
		start_alu54        <= '0';
		start_alu55        <= '0';
		start_alu56        <= '0';
		start_alu57        <= '0';
		start_alu58        <= '0';
		start_alu59        <= '0';
		start_alu60        <= '0';
		start_alu61        <= '0';
		start_alu62        <= '0';
		start_alu63        <= '0';
		start_alu64         <= '0';
		start_alu65         <= '0';
		start_alu66         <= '0';
		start_alu67         <= '0';
		start_alu68         <= '0';
		start_alu69         <= '0';
		start_alu70         <= '0';
		start_alu71         <= '0';
		start_alu72         <= '0';
		start_alu73         <= '0';
		start_alu74        <= '0';
		start_alu75        <= '0';
		start_alu76        <= '0';
		start_alu77        <= '0';
		start_alu78        <= '0';
		start_alu79        <= '0';
		start_alu80        <= '0';
		start_alu81        <= '0';
		start_alu82        <= '0';
		start_alu83        <= '0';
		start_alu84        <= '0';
		start_alu85        <= '0';
		start_alu86        <= '0';
		start_alu87        <= '0';
		start_alu88        <= '0';
		start_alu89        <= '0';
		start_alu90        <= '0';
		start_alu91        <= '0';
		start_alu92        <= '0';
		start_alu93        <= '0';
		start_alu94        <= '0';
		start_alu95        <= '0';
		start_alu96         <= '0';
		start_alu97         <= '0';
		start_alu98         <= '0';
		start_alu99         <= '0';
		start_alu100         <= '0';
		start_alu101         <= '0';
		start_alu102         <= '0';
		start_alu103         <= '0';
		start_alu104         <= '0';
		start_alu105         <= '0';
		start_alu106        <= '0';
		start_alu107        <= '0';
		start_alu108        <= '0';
		start_alu109        <= '0';
		start_alu110        <= '0';
		start_alu111        <= '0';
		start_alu112        <= '0';
		start_alu113        <= '0';
		start_alu114        <= '0';
		start_alu115        <= '0';
		start_alu116        <= '0';
		start_alu117        <= '0';
		start_alu118        <= '0';
		start_alu119        <= '0';
		start_alu120        <= '0';
		start_alu121        <= '0';
		start_alu122        <= '0';
		start_alu123        <= '0';
		start_alu124        <= '0';
		start_alu125        <= '0';
		start_alu126        <= '0';
		start_alu127        <= '0';
		received_alu0      <= '0';
		received_alu1      <= '0';
		received_alu2      <= '0';
		received_alu3      <= '0';
		received_alu4      <= '0';
		received_alu5      <= '0';
		received_alu6      <= '0';
		received_alu7      <= '0';
		received_alu8      <= '0';
		received_alu9      <= '0';
		received_alu10     <= '0';
		received_alu11     <= '0';
		received_alu12     <= '0';
		received_alu13     <= '0';
		received_alu14     <= '0';
		received_alu15     <= '0';
		received_alu16     <= '0';
		received_alu17     <= '0';
		received_alu18     <= '0';
		received_alu19     <= '0';
		received_alu20     <= '0';
		received_alu21     <= '0';
		received_alu22     <= '0';
		received_alu23     <= '0';
		received_alu24     <= '0';
		received_alu25     <= '0';
		received_alu26     <= '0';
		received_alu27     <= '0';
		received_alu28     <= '0';
		received_alu29     <= '0';
		received_alu30     <= '0';
		received_alu31     <= '0';
		received_alu32      <= '0';
		received_alu33      <= '0';
		received_alu34      <= '0';
		received_alu35      <= '0';
		received_alu36      <= '0';
		received_alu37      <= '0';
		received_alu38      <= '0';
		received_alu39      <= '0';
		received_alu40      <= '0';
		received_alu41      <= '0';
		received_alu42     <= '0';
		received_alu43     <= '0';
		received_alu44     <= '0';
		received_alu45     <= '0';
		received_alu46     <= '0';
		received_alu47     <= '0';
		received_alu48     <= '0';
		received_alu49     <= '0';
		received_alu50     <= '0';
		received_alu51     <= '0';
		received_alu52     <= '0';
		received_alu53     <= '0';
		received_alu54     <= '0';
		received_alu55     <= '0';
		received_alu56     <= '0';
		received_alu57     <= '0';
		received_alu58     <= '0';
		received_alu59     <= '0';
		received_alu60     <= '0';
		received_alu61     <= '0';
		received_alu62     <= '0';
		received_alu63     <= '0';
		received_alu64      <= '0';
		received_alu65      <= '0';
		received_alu66      <= '0';
		received_alu67      <= '0';
		received_alu68      <= '0';
		received_alu69      <= '0';
		received_alu70      <= '0';
		received_alu71      <= '0';
		received_alu72      <= '0';
		received_alu73      <= '0';
		received_alu74     <= '0';
		received_alu75     <= '0';
		received_alu76     <= '0';
		received_alu77     <= '0';
		received_alu78     <= '0';
		received_alu79     <= '0';
		received_alu80     <= '0';
		received_alu81     <= '0';
		received_alu82     <= '0';
		received_alu83     <= '0';
		received_alu84     <= '0';
		received_alu85     <= '0';
		received_alu86     <= '0';
		received_alu87     <= '0';
		received_alu88     <= '0';
		received_alu89     <= '0';
		received_alu90     <= '0';
		received_alu91     <= '0';
		received_alu92     <= '0';
		received_alu93     <= '0';
		received_alu94     <= '0';
		received_alu95     <= '0';
		received_alu96      <= '0';
		received_alu97      <= '0';
		received_alu98      <= '0';
		received_alu99      <= '0';
		received_alu100      <= '0';
		received_alu101      <= '0';
		received_alu102      <= '0';
		received_alu103      <= '0';
		received_alu104      <= '0';
		received_alu105      <= '0';
		received_alu106     <= '0';
		received_alu107     <= '0';
		received_alu108     <= '0';
		received_alu109     <= '0';
		received_alu110     <= '0';
		received_alu111     <= '0';
		received_alu112     <= '0';
		received_alu113     <= '0';
		received_alu114     <= '0';
		received_alu115     <= '0';
		received_alu116     <= '0';
		received_alu117     <= '0';
		received_alu118     <= '0';
		received_alu119     <= '0';
		received_alu120     <= '0';
		received_alu121     <= '0';
		received_alu122     <= '0';
		received_alu123     <= '0';
		received_alu124     <= '0';
		received_alu125     <= '0';
		received_alu126     <= '0';
		received_alu127     <= '0';
		pixel_alu0         <= pixel_alu0;
		pixel_alu1         <= pixel_alu1;
		pixel_alu2         <= pixel_alu2;
		pixel_alu3         <= pixel_alu3;
		pixel_alu4         <= pixel_alu4;
		pixel_alu5         <= pixel_alu5;
		pixel_alu6         <= pixel_alu6;
		pixel_alu7         <= pixel_alu7;
		pixel_alu8         <= pixel_alu8;
		pixel_alu9         <= pixel_alu9;
		pixel_alu10        <= pixel_alu10;
		pixel_alu11        <= pixel_alu11;
		pixel_alu12        <= pixel_alu12;
		pixel_alu13        <= pixel_alu13;
		pixel_alu14        <= pixel_alu14;
		pixel_alu15        <= pixel_alu15;
		pixel_alu16        <= pixel_alu16;
		pixel_alu17        <= pixel_alu17;
		pixel_alu18        <= pixel_alu18;
		pixel_alu19        <= pixel_alu19;
		pixel_alu20        <= pixel_alu20;
		pixel_alu21        <= pixel_alu21;
		pixel_alu22        <= pixel_alu22;
		pixel_alu23        <= pixel_alu23;
		pixel_alu24        <= pixel_alu24;
		pixel_alu25        <= pixel_alu25;
		pixel_alu26        <= pixel_alu26;
		pixel_alu27        <= pixel_alu27;
		pixel_alu28        <= pixel_alu28;
		pixel_alu29        <= pixel_alu29;
		pixel_alu30        <= pixel_alu30;
		pixel_alu31        <= pixel_alu31;
		pixel_alu32         <= pixel_alu32;
		pixel_alu33         <= pixel_alu33;
		pixel_alu34         <= pixel_alu34;
		pixel_alu35         <= pixel_alu35;
		pixel_alu36         <= pixel_alu36;
		pixel_alu37         <= pixel_alu37;
		pixel_alu38         <= pixel_alu38;
		pixel_alu39         <= pixel_alu39;
		pixel_alu40         <= pixel_alu40;
		pixel_alu41         <= pixel_alu41;
		pixel_alu42        <= pixel_alu42;
		pixel_alu43        <= pixel_alu43;
		pixel_alu44        <= pixel_alu44;
		pixel_alu45        <= pixel_alu45;
		pixel_alu46        <= pixel_alu46;
		pixel_alu47        <= pixel_alu47;
		pixel_alu48        <= pixel_alu48;
		pixel_alu49        <= pixel_alu49;
		pixel_alu50        <= pixel_alu50;
		pixel_alu51        <= pixel_alu51;
		pixel_alu52        <= pixel_alu52;
		pixel_alu53        <= pixel_alu53;
		pixel_alu54        <= pixel_alu54;
		pixel_alu55        <= pixel_alu55;
		pixel_alu56        <= pixel_alu56;
		pixel_alu57        <= pixel_alu57;
		pixel_alu58        <= pixel_alu58;
		pixel_alu59        <= pixel_alu59;
		pixel_alu60        <= pixel_alu60;
		pixel_alu61        <= pixel_alu61;
		pixel_alu62        <= pixel_alu62;
		pixel_alu63        <= pixel_alu63;

		pixel_alu64         <= pixel_alu64;
		pixel_alu65         <= pixel_alu65;
		pixel_alu66         <= pixel_alu66;
		pixel_alu67         <= pixel_alu67;
		pixel_alu68         <= pixel_alu68;
		pixel_alu69         <= pixel_alu69;
		pixel_alu70         <= pixel_alu70;
		pixel_alu71         <= pixel_alu71;
		pixel_alu72         <= pixel_alu72;
		pixel_alu73         <= pixel_alu73;
		pixel_alu74        <= pixel_alu74;
		pixel_alu75        <= pixel_alu75;
		pixel_alu76        <= pixel_alu76;
		pixel_alu77        <= pixel_alu77;
		pixel_alu78        <= pixel_alu78;
		pixel_alu79        <= pixel_alu79;
		pixel_alu80        <= pixel_alu80;
		pixel_alu81        <= pixel_alu81;
		pixel_alu82        <= pixel_alu82;
		pixel_alu83        <= pixel_alu83;
		pixel_alu84        <= pixel_alu84;
		pixel_alu85        <= pixel_alu85;
		pixel_alu86        <= pixel_alu86;
		pixel_alu87        <= pixel_alu87;
		pixel_alu88        <= pixel_alu88;
		pixel_alu89        <= pixel_alu89;
		pixel_alu90        <= pixel_alu90;
		pixel_alu91        <= pixel_alu91;
		pixel_alu92        <= pixel_alu92;
		pixel_alu93        <= pixel_alu93;
		pixel_alu94        <= pixel_alu94;
		pixel_alu95        <= pixel_alu95;
		pixel_alu96         <= pixel_alu96;
		pixel_alu97         <= pixel_alu97;
		pixel_alu98         <= pixel_alu98;
		pixel_alu99         <= pixel_alu99;
		pixel_alu100         <= pixel_alu100;
		pixel_alu101         <= pixel_alu101;
		pixel_alu102         <= pixel_alu102;
		pixel_alu103         <= pixel_alu103;
		pixel_alu104         <= pixel_alu104;
		pixel_alu105         <= pixel_alu105;
		pixel_alu106        <= pixel_alu106;
		pixel_alu107        <= pixel_alu107;
		pixel_alu108        <= pixel_alu108;
		pixel_alu109        <= pixel_alu109;
		pixel_alu110        <= pixel_alu110;
		pixel_alu111        <= pixel_alu111;
		pixel_alu112        <= pixel_alu112;
		pixel_alu113        <= pixel_alu113;
		pixel_alu114        <= pixel_alu114;
		pixel_alu115        <= pixel_alu115;
		pixel_alu116        <= pixel_alu116;
		pixel_alu117        <= pixel_alu117;
		pixel_alu118        <= pixel_alu118;
		pixel_alu119        <= pixel_alu119;
		pixel_alu120        <= pixel_alu120;
		pixel_alu121        <= pixel_alu121;
		pixel_alu122        <= pixel_alu122;
		pixel_alu123        <= pixel_alu123;
		pixel_alu124        <= pixel_alu124;
		pixel_alu125        <= pixel_alu125;
		pixel_alu126        <= pixel_alu126;
		pixel_alu127        <= pixel_alu127;
		re_alu0            <= re_alu0;
		im_alu0            <= im_alu0;
		re_alu1            <= re_alu1;
		im_alu1            <= im_alu1;
		re_alu2            <= re_alu2;
		im_alu2            <= im_alu2;
		re_alu3            <= re_alu3;
		im_alu3            <= im_alu3;
		re_alu4            <= re_alu4;
		im_alu4            <= im_alu4;
		re_alu5            <= re_alu5;
		im_alu5            <= im_alu5;
		re_alu6            <= re_alu6;
		im_alu6            <= im_alu6;
		re_alu7            <= re_alu7;
		im_alu7            <= im_alu7;
		re_alu8            <= re_alu8;
		im_alu8            <= im_alu8;
		re_alu9            <= re_alu9;
		im_alu9            <= im_alu9;
		re_alu10           <= re_alu10;
		im_alu10           <= im_alu10;
		re_alu11           <= re_alu11;
		im_alu11           <= im_alu11;
		re_alu12           <= re_alu12;
		im_alu12           <= im_alu12;
		re_alu13           <= re_alu13;
		im_alu13           <= im_alu13;
		re_alu14           <= re_alu14;
		im_alu14           <= im_alu14;
		re_alu15           <= re_alu15;
		im_alu15           <= im_alu15;
		re_alu16           <= re_alu16;
		im_alu16           <= im_alu16;
		re_alu17           <= re_alu17;
		im_alu17           <= im_alu17;
		re_alu18           <= re_alu18;
		im_alu18           <= im_alu18;
		re_alu19           <= re_alu19;
		im_alu19           <= im_alu19;
		re_alu20           <= re_alu20;
		im_alu20           <= im_alu20;
		re_alu21           <= re_alu21;
		im_alu21           <= im_alu21;
		re_alu22           <= re_alu22;
		im_alu22           <= im_alu22;
		re_alu23           <= re_alu23;
		im_alu23           <= im_alu23;
		re_alu24           <= re_alu24;
		im_alu24           <= im_alu24;
		re_alu25           <= re_alu25;
		im_alu25           <= im_alu25;
		re_alu26           <= re_alu26;
		im_alu26           <= im_alu26;
		re_alu27           <= re_alu27;
		im_alu27           <= im_alu27;
		re_alu28           <= re_alu28;
		im_alu28           <= im_alu28;
		re_alu29           <= re_alu29;
		im_alu29           <= im_alu29;
		re_alu30           <= re_alu30;
		im_alu30           <= im_alu30;
		re_alu31           <= re_alu31;
		im_alu31           <= im_alu31;
		re_alu32            <= re_alu32;
		im_alu32            <= im_alu32;
		re_alu33            <= re_alu33;
		im_alu33            <= im_alu33;
		re_alu34            <= re_alu34;
		im_alu34            <= im_alu34;
		re_alu35            <= re_alu35;
		im_alu35            <= im_alu35;
		re_alu36            <= re_alu36;
		im_alu36            <= im_alu36;
		re_alu37            <= re_alu37;
		im_alu37            <= im_alu37;
		re_alu38            <= re_alu38;
		im_alu38            <= im_alu38;
		re_alu39            <= re_alu39;
		im_alu39            <= im_alu39;
		re_alu40            <= re_alu40;
		im_alu40            <= im_alu40;
		re_alu41            <= re_alu41;
		im_alu41            <= im_alu41;
		re_alu42           <= re_alu42;
		im_alu42           <= im_alu42;
		re_alu43           <= re_alu43;
		im_alu43           <= im_alu43;
		re_alu44           <= re_alu44;
		im_alu44           <= im_alu44;
		re_alu45           <= re_alu45;
		im_alu45           <= im_alu45;
		re_alu46           <= re_alu46;
		im_alu46           <= im_alu46;
		re_alu47           <= re_alu47;
		im_alu47           <= im_alu47;
		re_alu48           <= re_alu48;
		im_alu48           <= im_alu48;
		re_alu49           <= re_alu49;
		im_alu49           <= im_alu49;
		re_alu50           <= re_alu50;
		im_alu50           <= im_alu50;
		re_alu51           <= re_alu51;
		im_alu51           <= im_alu51;
		re_alu52           <= re_alu52;
		im_alu52           <= im_alu52;
		re_alu53           <= re_alu53;
		im_alu53           <= im_alu53;
		re_alu54           <= re_alu54;
		im_alu54           <= im_alu54;
		re_alu55           <= re_alu55;
		im_alu55           <= im_alu55;
		re_alu56           <= re_alu56;
		im_alu56           <= im_alu56;
		re_alu57           <= re_alu57;
		im_alu57           <= im_alu57;
		re_alu58           <= re_alu58;
		im_alu58           <= im_alu58;
		re_alu59           <= re_alu59;
		im_alu59           <= im_alu59;
		re_alu60           <= re_alu60;
		im_alu60           <= im_alu60;
		re_alu61           <= re_alu61;
		im_alu61           <= im_alu61;
		re_alu62           <= re_alu62;
		im_alu62           <= im_alu62;
		re_alu63           <= re_alu63;
		im_alu63           <= im_alu63;
		re_alu64            <= re_alu64;
		im_alu64            <= im_alu64;
		re_alu65            <= re_alu65;
		im_alu65            <= im_alu65;
		re_alu66            <= re_alu66;
		im_alu66            <= im_alu66;
		re_alu67            <= re_alu67;
		im_alu67            <= im_alu67;
		re_alu68            <= re_alu68;
		im_alu68            <= im_alu68;
		re_alu69            <= re_alu69;
		im_alu69            <= im_alu69;
		re_alu70            <= re_alu70;
		im_alu70            <= im_alu70;
		re_alu71             <= re_alu71;
		im_alu71            <= im_alu71;
		re_alu72            <= re_alu72;
		im_alu72            <= im_alu72;
		re_alu73            <= re_alu73;
		im_alu73            <= im_alu73;
		re_alu74           <= re_alu74;
		im_alu74           <= im_alu74;
		re_alu75           <= re_alu75;
		im_alu75           <= im_alu75;
		re_alu76           <= re_alu76;
		im_alu76           <= im_alu76;
		re_alu77           <= re_alu77;
		im_alu77           <= im_alu77;
		re_alu78           <= re_alu78;
		im_alu78           <= im_alu78;
		re_alu79           <= re_alu79;
		im_alu79           <= im_alu79;
		re_alu80           <= re_alu80;
		im_alu80           <= im_alu80;
		re_alu81           <= re_alu81;
		im_alu81           <= im_alu81;
		re_alu82           <= re_alu82;
		im_alu82           <= im_alu82;
		re_alu83           <= re_alu83;
		im_alu83           <= im_alu83;
		re_alu84           <= re_alu84;
		im_alu84           <= im_alu84;
		re_alu85           <= re_alu85;
		im_alu85           <= im_alu85;
		re_alu86           <= re_alu86;
		im_alu86           <= im_alu86;
		re_alu87           <= re_alu87;
		im_alu87           <= im_alu87;
		re_alu88           <= re_alu88;
		im_alu88           <= im_alu88;
		re_alu89           <= re_alu89;
		im_alu89           <= im_alu89;
		re_alu90           <= re_alu90;
		im_alu90           <= im_alu90;
		re_alu91           <= re_alu91;
		im_alu91           <= im_alu91;
		re_alu92           <= re_alu92;
		im_alu92           <= im_alu92;
		re_alu93           <= re_alu93;
		im_alu93           <= im_alu93;
		re_alu94           <= re_alu94;
		im_alu94           <= im_alu94;
		re_alu95           <= re_alu95;
		im_alu95           <= im_alu95;
		re_alu96            <= re_alu96;
		im_alu96            <= im_alu96;
		re_alu97            <= re_alu97;
		im_alu97            <= im_alu97;
		re_alu98            <= re_alu98;
		im_alu98            <= im_alu98;
		re_alu99            <= re_alu99;
		im_alu99            <= im_alu99;
		re_alu100            <= re_alu100;
		im_alu100            <= im_alu100;
		re_alu101            <= re_alu101;
		im_alu101            <= im_alu101;
		re_alu102            <= re_alu102;
		im_alu102            <= im_alu102;
		re_alu103            <= re_alu103;
		im_alu103            <= im_alu103;
		re_alu104            <= re_alu104;
		im_alu104            <= im_alu104;
		re_alu105            <= re_alu105;
		im_alu105            <= im_alu105;
		re_alu106           <= re_alu106;
		im_alu106           <= im_alu106;
		re_alu107           <= re_alu107;
		im_alu107           <= im_alu107;
		re_alu108           <= re_alu108;
		im_alu108           <= im_alu108;
		re_alu109           <= re_alu109;
		im_alu109           <= im_alu109;
		re_alu110           <= re_alu110;
		im_alu110           <= im_alu110;
		re_alu111           <= re_alu111;
		im_alu111           <= im_alu111;
		re_alu112           <= re_alu112;
		im_alu112           <= im_alu112;
		re_alu113           <= re_alu113;
		im_alu113           <= im_alu113;
		re_alu114           <= re_alu114;
		im_alu114           <= im_alu114;
		re_alu115           <= re_alu115;
		im_alu115           <= im_alu115;
		re_alu116           <= re_alu116;
		im_alu116           <= im_alu116;
		re_alu117           <= re_alu117;
		im_alu117           <= im_alu117;
		re_alu118           <= re_alu118;
		im_alu118           <= im_alu118;
		re_alu119           <= re_alu119;
		im_alu119           <= im_alu119;
		re_alu120           <= re_alu120;
		im_alu120           <= im_alu120;
		re_alu121           <= re_alu121;
		im_alu121           <= im_alu121;
		re_alu122           <= re_alu122;
		im_alu122           <= im_alu122;
		re_alu123           <= re_alu123;
		im_alu123           <= im_alu123;
		re_alu124           <= re_alu124;
		im_alu124           <= im_alu124;
		re_alu125           <= re_alu125;
		im_alu125           <= im_alu125;
		re_alu126           <= re_alu126;
		im_alu126           <= im_alu126;
		re_alu127           <= re_alu127;
		im_alu127           <= im_alu127;


		adder_a_valid      <= '0';
		adder_b_valid      <= '0';
		adder_result_ready <= '0';
		adder_a            <= "0000000000000000000000000000000000000000000000000000000000000000";
		adder_b            <= "0000000000000000000000000000000000000000000000000000000000000000";
		current_re         <= current_re;
		current_im         <= current_im;
		llre               <= llre;
		llim               <= llim;
		CASE math_state IS
			WHEN idle => 
				picture_done      <= '1';
				current_pixel     <= 0;
				current_pixel_inc <= 1;
			WHEN receive_llre => 
			WHEN fetch_llre   => 
				llre        <= data;
				current_re  <= data;
				re_received <= '1';
			WHEN receive_llim => 
			WHEN fetch_llim   => 
				llim        <= data;
				current_im  <= data;
				im_received <= '1';
			WHEN receive_zf => 
			WHEN fetch_zf   => 
				zf          <= data;
				zf_received <= '1';
			WHEN calc_next_pixel_im => --calc_next_pixel_re/im
				adder_a            <= current_im;
				adder_a_valid      <= '1';
				adder_b            <= zf;
				adder_b_valid      <= '1';
				adder_result_ready <= '1';
				current_re         <= llre;
			WHEN calc_next_pixel_re => --calc_next_pixel_re/im
				adder_a            <= current_re;
				adder_a_valid      <= '1';
				adder_b            <= zf;
				adder_b_valid      <= '1';
				adder_result_ready <= '1';
			WHEN wait_for_re_value_ready => 
			WHEN wait_for_im_value_ready => 
			WHEN fetch_re => current_re <= adder_result;
			WHEN fetch_im => current_im <= adder_result;
			WHEN pixel_ready => 
			WHEN run_alu0    => 
				re_alu0    <= current_re;
				im_alu0    <= current_im;
				start_alu0 <= '1';
				pixel_alu0 <= current_pixel;
			WHEN run_alu1 => 
				re_alu1    <= current_re;
				im_alu1    <= current_im;
				start_alu1 <= '1';
				pixel_alu1 <= current_pixel;
			WHEN run_alu2 => 
				re_alu2    <= current_re;
				im_alu2    <= current_im;
				start_alu2 <= '1';
				pixel_alu2 <= current_pixel;
			WHEN run_alu3 => 
				re_alu3    <= current_re;
				im_alu3    <= current_im;
				start_alu3 <= '1';
				pixel_alu3 <= current_pixel;
			WHEN run_alu4 => 
				re_alu4    <= current_re;
				im_alu4    <= current_im;
				start_alu4 <= '1';
				pixel_alu4 <= current_pixel;
			WHEN run_alu5 => 
				re_alu5    <= current_re;
				im_alu5    <= current_im;
				start_alu5 <= '1';
				pixel_alu5 <= current_pixel;
			WHEN run_alu6 => 
				re_alu6    <= current_re;
				im_alu6    <= current_im;
				start_alu6 <= '1';
				pixel_alu6 <= current_pixel;
			WHEN run_alu7 => 
				re_alu7    <= current_re;
				im_alu7    <= current_im;
				start_alu7 <= '1';
				pixel_alu7 <= current_pixel;
 			WHEN run_alu8 => 
				re_alu8    <= current_re;
				im_alu8    <= current_im;
				start_alu8 <= '1';
				pixel_alu8 <= current_pixel;
			WHEN run_alu9 => 
				re_alu9    <= current_re;
				im_alu9    <= current_im;
				start_alu9 <= '1';
				pixel_alu9 <= current_pixel;
			WHEN run_alu10 => 
				re_alu10    <= current_re;
				im_alu10    <= current_im;
				start_alu10 <= '1';
				pixel_alu10 <= current_pixel;
			WHEN run_alu11 => 
				re_alu11    <= current_re;
				im_alu11    <= current_im;
				start_alu11 <= '1';
				pixel_alu11 <= current_pixel;
			WHEN run_alu12 => 
				re_alu12    <= current_re;
				im_alu12    <= current_im;
				start_alu12 <= '1';
				pixel_alu12 <= current_pixel;
			WHEN run_alu13 => 
				re_alu13    <= current_re;
				im_alu13    <= current_im;
				start_alu13 <= '1';
				pixel_alu13 <= current_pixel;
			WHEN run_alu14 => 
				re_alu14    <= current_re;
				im_alu14    <= current_im;
				start_alu14 <= '1';
				pixel_alu14 <= current_pixel;
			WHEN run_alu15 => 
				re_alu15    <= current_re;
				im_alu15    <= current_im;
				start_alu15 <= '1';
				pixel_alu15 <= current_pixel;
			WHEN run_alu16    => 
				re_alu16    <= current_re;
				im_alu16    <= current_im;
				start_alu16 <= '1';
				pixel_alu16 <= current_pixel;
			WHEN run_alu17 => 
				re_alu17    <= current_re;
				im_alu17    <= current_im;
				start_alu17 <= '1';
				pixel_alu17 <= current_pixel;
			WHEN run_alu18 => 
				re_alu18    <= current_re;
				im_alu18    <= current_im;
				start_alu18 <= '1';
				pixel_alu18 <= current_pixel;
			WHEN run_alu19 => 
				re_alu19    <= current_re;
				im_alu19    <= current_im;
				start_alu19 <= '1';
				pixel_alu19 <= current_pixel;
			WHEN run_alu20 => 
				re_alu20    <= current_re;
				im_alu20    <= current_im;
				start_alu20 <= '1';
				pixel_alu20 <= current_pixel;
			WHEN run_alu21 => 
				re_alu21    <= current_re;
				im_alu21    <= current_im;
				start_alu21 <= '1';
				pixel_alu21 <= current_pixel;
			WHEN run_alu22 => 
				re_alu22    <= current_re;
				im_alu22    <= current_im;
				start_alu22 <= '1';
				pixel_alu22 <= current_pixel;
			WHEN run_alu23 => 
				re_alu23    <= current_re;
				im_alu23    <= current_im;
				start_alu23 <= '1';
				pixel_alu23 <= current_pixel;
 			WHEN run_alu24 => 
				re_alu24    <= current_re;
				im_alu24    <= current_im;
				start_alu24 <= '1';
				pixel_alu24 <= current_pixel;
			WHEN run_alu25 => 
				re_alu25    <= current_re;
				im_alu25    <= current_im;
				start_alu25 <= '1';
				pixel_alu25 <= current_pixel;
			WHEN run_alu26 => 
				re_alu26    <= current_re;
				im_alu26    <= current_im;
				start_alu26 <= '1';
				pixel_alu26 <= current_pixel;
			WHEN run_alu27 => 
				re_alu27    <= current_re;
				im_alu27    <= current_im;
				start_alu27 <= '1';
				pixel_alu27 <= current_pixel;
			WHEN run_alu28 => 
				re_alu28    <= current_re;
				im_alu28    <= current_im;
				start_alu28 <= '1';
				pixel_alu28 <= current_pixel;
			WHEN run_alu29 => 
				re_alu29    <= current_re;
				im_alu29    <= current_im;
				start_alu29 <= '1';
				pixel_alu29 <= current_pixel;
			WHEN run_alu30 => 
				re_alu30    <= current_re;
				im_alu30    <= current_im;
				start_alu30 <= '1';
				pixel_alu30 <= current_pixel;
			WHEN run_alu31 => 
				re_alu31    <= current_re;
				im_alu31    <= current_im;
				start_alu31 <= '1';
				pixel_alu31 <= current_pixel;
			WHEN run_alu32    => 
				re_alu32    <= current_re;
				im_alu32    <= current_im;
				start_alu32 <= '1';
				pixel_alu32 <= current_pixel;
			WHEN run_alu33 => 
				re_alu33    <= current_re;
				im_alu33    <= current_im;
				start_alu33 <= '1';
				pixel_alu33 <= current_pixel;
			WHEN run_alu34 => 
				re_alu34    <= current_re;
				im_alu34    <= current_im;
				start_alu34 <= '1';
				pixel_alu34 <= current_pixel;
			WHEN run_alu35 => 
				re_alu35    <= current_re;
				im_alu35    <= current_im;
				start_alu35 <= '1';
				pixel_alu35 <= current_pixel;
			WHEN run_alu36 => 
				re_alu36    <= current_re;
				im_alu36    <= current_im;
				start_alu36 <= '1';
				pixel_alu36 <= current_pixel;
			WHEN run_alu37 => 
				re_alu37    <= current_re;
				im_alu37    <= current_im;
				start_alu37 <= '1';
				pixel_alu37 <= current_pixel;
			WHEN run_alu38 => 
				re_alu38    <= current_re;
				im_alu38    <= current_im;
				start_alu38 <= '1';
				pixel_alu38 <= current_pixel;
			WHEN run_alu39 => 
				re_alu39    <= current_re;
				im_alu39    <= current_im;
				start_alu39 <= '1';
				pixel_alu39 <= current_pixel;
 			WHEN run_alu40 => 
				re_alu40    <= current_re;
				im_alu40    <= current_im;
				start_alu40 <= '1';
				pixel_alu40 <= current_pixel;
			WHEN run_alu41 => 
				re_alu41    <= current_re;
				im_alu41    <= current_im;
				start_alu41 <= '1';
				pixel_alu41 <= current_pixel;
			WHEN run_alu42 => 
				re_alu42    <= current_re;
				im_alu42    <= current_im;
				start_alu42 <= '1';
				pixel_alu42 <= current_pixel;
			WHEN run_alu43 => 
				re_alu43    <= current_re;
				im_alu43    <= current_im;
				start_alu43 <= '1';
				pixel_alu43 <= current_pixel;
			WHEN run_alu44 => 
				re_alu44    <= current_re;
				im_alu44    <= current_im;
				start_alu44 <= '1';
				pixel_alu44 <= current_pixel;
			WHEN run_alu45 => 
				re_alu45    <= current_re;
				im_alu45    <= current_im;
				start_alu45 <= '1';
				pixel_alu45 <= current_pixel;
			WHEN run_alu46 => 
				re_alu46    <= current_re;
				im_alu46    <= current_im;
				start_alu46 <= '1';
				pixel_alu46 <= current_pixel;
			WHEN run_alu47 => 
				re_alu47    <= current_re;
				im_alu47    <= current_im;
				start_alu47 <= '1';
				pixel_alu47 <= current_pixel;
			WHEN run_alu48    => 
				re_alu48    <= current_re;
				im_alu48    <= current_im;
				start_alu48 <= '1';
				pixel_alu48 <= current_pixel;
			WHEN run_alu49 => 
				re_alu49    <= current_re;
				im_alu49    <= current_im;
				start_alu49 <= '1';
				pixel_alu49 <= current_pixel;
			WHEN run_alu50 => 
				re_alu50    <= current_re;
				im_alu50    <= current_im;
				start_alu50 <= '1';
				pixel_alu50 <= current_pixel;
			WHEN run_alu51 => 
				re_alu51    <= current_re;
				im_alu51    <= current_im;
				start_alu51 <= '1';
				pixel_alu51 <= current_pixel;
			WHEN run_alu52 => 
				re_alu52    <= current_re;
				im_alu52    <= current_im;
				start_alu52 <= '1';
				pixel_alu52 <= current_pixel;
			WHEN run_alu53 => 
				re_alu53    <= current_re;
				im_alu53    <= current_im;
				start_alu53 <= '1';
				pixel_alu53 <= current_pixel;
			WHEN run_alu54 => 
				re_alu54    <= current_re;
				im_alu54    <= current_im;
				start_alu54 <= '1';
				pixel_alu54 <= current_pixel;
			WHEN run_alu55 => 
				re_alu55    <= current_re;
				im_alu55    <= current_im;
				start_alu55 <= '1';
				pixel_alu55 <= current_pixel;
 			WHEN run_alu56 => 
				re_alu56    <= current_re;
				im_alu56    <= current_im;
				start_alu56 <= '1';
				pixel_alu56 <= current_pixel;
			WHEN run_alu57 => 
				re_alu57    <= current_re;
				im_alu57    <= current_im;
				start_alu57 <= '1';
				pixel_alu57 <= current_pixel;
			WHEN run_alu58 => 
				re_alu58    <= current_re;
				im_alu58    <= current_im;
				start_alu58 <= '1';
				pixel_alu58 <= current_pixel;
			WHEN run_alu59 => 
				re_alu59    <= current_re;
				im_alu59    <= current_im;
				start_alu59 <= '1';
				pixel_alu59 <= current_pixel;
			WHEN run_alu60 => 
				re_alu60    <= current_re;
				im_alu60    <= current_im;
				start_alu60 <= '1';
				pixel_alu60 <= current_pixel;
			WHEN run_alu61 => 
				re_alu61    <= current_re;
				im_alu61    <= current_im;
				start_alu61 <= '1';
				pixel_alu61 <= current_pixel;
			WHEN run_alu62 => 
				re_alu62    <= current_re;
				im_alu62    <= current_im;
				start_alu62 <= '1';
				pixel_alu62 <= current_pixel;
			WHEN run_alu63 => 
				re_alu63    <= current_re;
				im_alu63    <= current_im;
				start_alu63 <= '1';
				pixel_alu63 <= current_pixel;
			WHEN run_alu64    => 
				re_alu64    <= current_re;
				im_alu64    <= current_im;
				start_alu64 <= '1';
				pixel_alu64 <= current_pixel;
			WHEN run_alu65 => 
				re_alu65    <= current_re;
				im_alu65    <= current_im;
				start_alu65 <= '1';
				pixel_alu65 <= current_pixel;
			WHEN run_alu2 => 
				re_alu2    <= current_re;
				im_alu2    <= current_im;
				start_alu2 <= '1';
				pixel_alu66 <= current_pixel;
			WHEN run_alu67 => 
				re_alu67    <= current_re;
				im_alu67    <= current_im;
				start_alu67 <= '1';
				pixel_alu67 <= current_pixel;
			WHEN run_alu68 => 
				re_alu68    <= current_re;
				im_alu68    <= current_im;
				start_alu68 <= '1';
				pixel_alu68 <= current_pixel;
			WHEN run_alu69 => 
				re_alu69    <= current_re;
				im_alu69    <= current_im;
				start_alu69 <= '1';
				pixel_alu69 <= current_pixel;
			WHEN run_alu70 => 
				re_alu70    <= current_re;
				im_alu70    <= current_im;
				start_alu70 <= '1';
				pixel_alu70 <= current_pixel;
			WHEN run_alu71 => 
				re_alu71    <= current_re;
				im_alu71    <= current_im;
				start_alu71 <= '1';
				pixel_alu71 <= current_pixel;
 			WHEN run_alu72 => 
				re_alu72    <= current_re;
				im_alu72    <= current_im;
				start_alu72 <= '1';
				pixel_alu72 <= current_pixel;
			WHEN run_alu73 => 
				re_alu73    <= current_re;
				im_alu73    <= current_im;
				start_alu73 <= '1';
				pixel_alu73 <= current_pixel;
			WHEN run_alu74 => 
				re_alu74    <= current_re;
				im_alu74    <= current_im;
				start_alu74 <= '1';
				pixel_alu74 <= current_pixel;
			WHEN run_alu75 => 
				re_alu75    <= current_re;
				im_alu75    <= current_im;
				start_alu75 <= '1';
				pixel_alu75 <= current_pixel;
			WHEN run_alu76 => 
				re_alu76    <= current_re;
				im_alu76    <= current_im;
				start_alu76 <= '1';
				pixel_alu76 <= current_pixel;
			WHEN run_alu77 => 
				re_alu77    <= current_re;
				im_alu77    <= current_im;
				start_alu77 <= '1';
				pixel_alu77 <= current_pixel;
			WHEN run_alu78 => 
				re_alu78    <= current_re;
				im_alu78    <= current_im;
				start_alu78 <= '1';
				pixel_alu78 <= current_pixel;
			WHEN run_alu79 => 
				re_alu79    <= current_re;
				im_alu79    <= current_im;
				start_alu79 <= '1';
				pixel_alu79 <= current_pixel;
			WHEN run_alu80    => 
				re_alu80    <= current_re;
				im_alu80    <= current_im;
				start_alu80 <= '1';
				pixel_alu80 <= current_pixel;
			WHEN run_alu81 => 
				re_alu81    <= current_re;
				im_alu81    <= current_im;
				start_alu81 <= '1';
				pixel_alu81 <= current_pixel;
			WHEN run_alu82 => 
				re_alu82    <= current_re;
				im_alu82    <= current_im;
				start_alu82 <= '1';
				pixel_alu82 <= current_pixel;
			WHEN run_alu83 => 
				re_alu83    <= current_re;
				im_alu83    <= current_im;
				start_alu83 <= '1';
				pixel_alu83 <= current_pixel;
			WHEN run_alu84 => 
				re_alu84    <= current_re;
				im_alu84    <= current_im;
				start_alu84 <= '1';
				pixel_alu84 <= current_pixel;
			WHEN run_alu85 => 
				re_alu85    <= current_re;
				im_alu85    <= current_im;
				start_alu85 <= '1';
				pixel_alu85 <= current_pixel;
			WHEN run_alu86 => 
				re_alu86    <= current_re;
				im_alu86    <= current_im;
				start_alu86 <= '1';
				pixel_alu86 <= current_pixel;
			WHEN run_alu87 => 
				re_alu87    <= current_re;
				im_alu87    <= current_im;
				start_alu87 <= '1';
				pixel_alu87 <= current_pixel;
 			WHEN run_alu88 => 
				re_alu88    <= current_re;
				im_alu88    <= current_im;
				start_alu88 <= '1';
				pixel_alu88 <= current_pixel;
			WHEN run_alu89 => 
				re_alu89    <= current_re;
				im_alu89    <= current_im;
				start_alu89 <= '1';
				pixel_alu89 <= current_pixel;
			WHEN run_alu90 => 
				re_alu90    <= current_re;
				im_alu90    <= current_im;
				start_alu90 <= '1';
				pixel_alu90 <= current_pixel;
			WHEN run_alu91 => 
				re_alu91    <= current_re;
				im_alu91    <= current_im;
				start_alu91 <= '1';
				pixel_alu91 <= current_pixel;
			WHEN run_alu92 => 
				re_alu92    <= current_re;
				im_alu92    <= current_im;
				start_alu92 <= '1';
				pixel_alu92 <= current_pixel;
			WHEN run_alu93 => 
				re_alu93    <= current_re;
				im_alu93    <= current_im;
				start_alu93 <= '1';
				pixel_alu93 <= current_pixel;
			WHEN run_alu94 => 
				re_alu94    <= current_re;
				im_alu94    <= current_im;
				start_alu94 <= '1';
				pixel_alu94 <= current_pixel;
			WHEN run_alu95 => 
				re_alu95    <= current_re;
				im_alu95    <= current_im;
				start_alu95 <= '1';
				pixel_alu95 <= current_pixel;
			WHEN run_alu96    => 
				re_alu96    <= current_re;
				im_alu96    <= current_im;
				start_alu96 <= '1';
				pixel_alu96 <= current_pixel;
			WHEN run_alu97 => 
				re_alu97    <= current_re;
				im_alu97    <= current_im;
				start_alu97 <= '1';
				pixel_alu97 <= current_pixel;
			WHEN run_alu98 => 
				re_alu98    <= current_re;
				im_alu98    <= current_im;
				start_alu98 <= '1';
				pixel_alu98 <= current_pixel;
			WHEN run_alu99 => 
				re_alu99    <= current_re;
				im_alu99    <= current_im;
				start_alu99 <= '1';
				pixel_alu99 <= current_pixel;
			WHEN run_alu100 => 
				re_alu100    <= current_re;
				im_alu100    <= current_im;
				start_alu100 <= '1';
				pixel_alu100 <= current_pixel;
			WHEN run_alu101 => 
				re_alu101    <= current_re;
				im_alu101    <= current_im;
				start_alu101 <= '1';
				pixel_alu101 <= current_pixel;
			WHEN run_alu102 => 
				re_alu102    <= current_re;
				im_alu102    <= current_im;
				start_alu102 <= '1';
				pixel_alu102 <= current_pixel;
			WHEN run_alu103 => 
				re_alu103    <= current_re;
				im_alu103    <= current_im;
				start_alu103 <= '1';
				pixel_alu103 <= current_pixel;
 			WHEN run_alu104 => 
				re_alu104    <= current_re;
				im_alu104    <= current_im;
				start_alu104 <= '1';
				pixel_alu104 <= current_pixel;
			WHEN run_alu105 => 
				re_alu105    <= current_re;
				im_alu105    <= current_im;
				start_alu105 <= '1';
				pixel_alu105 <= current_pixel;
			WHEN run_alu106 => 
				re_alu106    <= current_re;
				im_alu106    <= current_im;
				start_alu106 <= '1';
				pixel_alu106 <= current_pixel;
			WHEN run_alu107 => 
				re_alu107    <= current_re;
				im_alu107    <= current_im;
				start_alu107 <= '1';
				pixel_alu107 <= current_pixel;
			WHEN run_alu108 => 
				re_alu108    <= current_re;
				im_alu108    <= current_im;
				start_alu108 <= '1';
				pixel_alu108 <= current_pixel;
			WHEN run_alu109 => 
				re_alu109    <= current_re;
				im_alu109    <= current_im;
				start_alu109 <= '1';
				pixel_alu109 <= current_pixel;
			WHEN run_alu110 => 
				re_alu110    <= current_re;
				im_alu110    <= current_im;
				start_alu110 <= '1';
				pixel_alu110 <= current_pixel;
			WHEN run_alu111 => 
				re_alu111    <= current_re;
				im_alu111    <= current_im;
				start_alu111 <= '1';
				pixel_alu111 <= current_pixel;
			WHEN run_alu112    => 
				re_alu112    <= current_re;
				im_alu112    <= current_im;
				start_alu112 <= '1';
				pixel_alu112 <= current_pixel;
			WHEN run_alu113 => 
				re_alu113    <= current_re;
				im_alu113    <= current_im;
				start_alu113 <= '1';
				pixel_alu113 <= current_pixel;
			WHEN run_alu114 => 
				re_alu114    <= current_re;
				im_alu114    <= current_im;
				start_alu114 <= '1';
				pixel_alu114 <= current_pixel;
			WHEN run_alu115 => 
				re_alu115    <= current_re;
				im_alu115    <= current_im;
				start_alu115 <= '1';
				pixel_alu115 <= current_pixel;
			WHEN run_alu116 => 
				re_alu116    <= current_re;
				im_alu116    <= current_im;
				start_alu116 <= '1';
				pixel_alu116 <= current_pixel;
			WHEN run_alu117 => 
				re_alu117    <= current_re;
				im_alu117    <= current_im;
				start_alu117 <= '1';
				pixel_alu117 <= current_pixel;
			WHEN run_alu118 => 
				re_alu118    <= current_re;
				im_alu118    <= current_im;
				start_alu118 <= '1';
				pixel_alu118 <= current_pixel;
			WHEN run_alu119 => 
				re_alu119    <= current_re;
				im_alu119    <= current_im;
				start_alu119 <= '1';
				pixel_alu119 <= current_pixel;
 			WHEN run_alu120 => 
				re_alu120    <= current_re;
				im_alu120    <= current_im;
				start_alu120 <= '1';
				pixel_alu120 <= current_pixel;
			WHEN run_alu121 => 
				re_alu121    <= current_re;
				im_alu121    <= current_im;
				start_alu121 <= '1';
				pixel_alu121 <= current_pixel;
			WHEN run_alu122 => 
				re_alu122    <= current_re;
				im_alu122    <= current_im;
				start_alu122 <= '1';
				pixel_alu122 <= current_pixel;
			WHEN run_alu123 => 
				re_alu123    <= current_re;
				im_alu123    <= current_im;
				start_alu123 <= '1';
				pixel_alu123 <= current_pixel;
			WHEN run_alu124 => 
				re_alu124    <= current_re;
				im_alu124    <= current_im;
				start_alu124 <= '1';
				pixel_alu124 <= current_pixel;
			WHEN run_alu125 => 
				re_alu125    <= current_re;
				im_alu125    <= current_im;
				start_alu125 <= '1';
				pixel_alu125 <= current_pixel;
			WHEN run_alu126 => 
				re_alu126    <= current_re;
				im_alu126    <= current_im;
				start_alu126 <= '1';
				pixel_alu126 <= current_pixel;
			WHEN run_alu127 => 
				re_alu127    <= current_re;
				im_alu127    <= current_im;
				start_alu127 <= '1';
				pixel_alu127 <= current_pixel;
			WHEN inc_pixel => 
				current_pixel <= current_pixel_inc;
			WHEN fetch_alu0 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu0;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu0, 13));
				received_alu0             <= '1';
			WHEN fetch_alu1 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu1;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu1, 13));
				received_alu1             <= '1';
			WHEN fetch_alu2 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu2;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu2, 13));
				received_alu2             <= '1';
			WHEN fetch_alu3 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu3;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu3, 13));
				received_alu3             <= '1';
			WHEN fetch_alu4 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu4;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu4, 13));
				received_alu4             <= '1';
			WHEN fetch_alu5 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu5;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu5, 13));
				received_alu5             <= '1';
			WHEN fetch_alu6 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu6;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu6, 13));
				received_alu6             <= '1';
			WHEN fetch_alu7 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu7;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu7, 13));
				received_alu7             <= '1';
			WHEN fetch_alu8 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu8;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu8, 13));
				received_alu8             <= '1';
			WHEN fetch_alu9 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu9;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu9, 13));
				received_alu9             <= '1';
			WHEN fetch_alu10 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu10;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu10, 13));
				received_alu10            <= '1';
			WHEN fetch_alu11 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu11;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu11, 13));
				received_alu11            <= '1';
			WHEN fetch_alu12 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu12;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu12, 13));
				received_alu12            <= '1';
			WHEN fetch_alu13 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu13;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu13, 13));
				received_alu13            <= '1';
			WHEN fetch_alu14 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu14;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu14, 13));
				received_alu14            <= '1';
			WHEN fetch_alu15 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu15;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu15, 13));
				received_alu15            <= '1';
			WHEN fetch_alu16 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu16;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu16, 13));
				received_alu16             <= '1';
			WHEN fetch_alu17 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu17;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu17, 13));
				received_alu17             <= '1';
			WHEN fetch_alu18 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu18;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu18, 13));
				received_alu18             <= '1';
			WHEN fetch_alu19 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu19;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu19, 13));
				received_alu19             <= '1';
			WHEN fetch_alu20 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu20;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu20, 13));
				received_alu20             <= '1';
			WHEN fetch_alu21 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu21;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu21, 13));
				received_alu21             <= '1';
			WHEN fetch_alu22 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu22;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu22, 13));
				received_alu22             <= '1';
			WHEN fetch_alu23 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu23;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu23, 13));
				received_alu23             <= '1';
			WHEN fetch_alu24 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu24;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu24, 13));
				received_alu24             <= '1';
			WHEN fetch_alu25 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu25;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu25, 13));
				received_alu25             <= '1';
			WHEN fetch_alu26 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu26;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu26, 13));
				received_alu26            <= '1';
			WHEN fetch_alu27 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu27;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu27, 13));
				received_alu27            <= '1';
			WHEN fetch_alu28 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu28;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu28, 13));
				received_alu28            <= '1';
			WHEN fetch_alu29 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu29;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu29, 13));
				received_alu29            <= '1';
			WHEN fetch_alu30 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu30;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu30, 13));
				received_alu30            <= '1';
			WHEN fetch_alu31 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu31;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu31, 13));
				received_alu31            <= '1';
			WHEN fetch_alu32 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu32;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu32, 13));
				received_alu32             <= '1';
			WHEN fetch_alu33 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu33;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu33, 13));
				received_alu33             <= '1';
			WHEN fetch_alu34 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu34;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu34, 13));
				received_alu34             <= '1';
			WHEN fetch_alu35 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu35;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu35, 13));
				received_alu35             <= '1';
			WHEN fetch_alu36 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu36;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu36, 13));
				received_alu36             <= '1';
			WHEN fetch_alu37 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu37;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu37, 13));
				received_alu37             <= '1';
			WHEN fetch_alu38 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu38;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu38, 13));
				received_alu38             <= '1';
			WHEN fetch_alu39 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu39;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu39, 13));
				received_alu39             <= '1';
			WHEN fetch_alu40 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu40;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu40, 13));
				received_alu40             <= '1';
			WHEN fetch_alu41 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu41;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu41, 13));
				received_alu41             <= '1';
			WHEN fetch_alu42 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu42;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu42, 13));
				received_alu42            <= '1';
			WHEN fetch_alu43 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu43;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu43, 13));
				received_alu43            <= '1';
			WHEN fetch_alu44 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu44;
				result_data(44 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu44, 13));
				received_alu44            <= '1';
			WHEN fetch_alu45 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu45;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu45, 13));
				received_alu45            <= '1';
			WHEN fetch_alu46 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu46;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu46, 13));
				received_alu46            <= '1';
			WHEN fetch_alu47 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu47;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu47, 13));
				received_alu47            <= '1';
			WHEN fetch_alu48 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu48;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu48, 13));
				received_alu48             <= '1';
			WHEN fetch_alu49 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu49;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu49, 13));
				received_alu49             <= '1';
			WHEN fetch_alu50 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu50;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu50, 13));
				received_alu50             <= '1';
			WHEN fetch_alu51 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu51;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu51, 13));
				received_alu51             <= '1';
			WHEN fetch_alu52 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu52;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu52, 13));
				received_alu52             <= '1';
			WHEN fetch_alu53 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu53;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu53, 13));
				received_alu53             <= '1';
			WHEN fetch_alu54 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu54;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu54, 13));
				received_alu54             <= '1';
			WHEN fetch_alu55 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu55;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu55, 13));
				received_alu55             <= '1';
			WHEN fetch_alu56 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu56;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu56, 13));
				received_alu56             <= '1';
			WHEN fetch_alu57 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu57;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu57, 13));
				received_alu57             <= '1';
			WHEN fetch_alu58 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu58;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu58, 13));
				received_alu58            <= '1';
			WHEN fetch_alu59 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu59;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu59, 13));
				received_alu59            <= '1';
			WHEN fetch_alu60 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu60;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu60, 13));
				received_alu60            <= '1';
			WHEN fetch_alu61 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu61;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu61, 13));
				received_alu61            <= '1';
			WHEN fetch_alu62 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu62;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu62, 13));
				received_alu62            <= '1';
			WHEN fetch_alu63 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu63;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu63, 13));
				received_alu63            <= '1';
			WHEN fetch_alu64 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu64;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu64, 13));
				received_alu64             <= '1';
			WHEN fetch_alu65 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu65;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu65, 13));
				received_alu65             <= '1';
			WHEN fetch_alu66 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu66;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu66, 13));
				received_alu66             <= '1';
			WHEN fetch_alu67 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu67;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu67, 13));
				received_alu67             <= '1';
			WHEN fetch_alu68 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu68;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu68, 13));
				received_alu68             <= '1';
			WHEN fetch_alu69 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu69;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu69, 13));
				received_alu69             <= '1';
			WHEN fetch_alu70 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu70;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu70, 13));
				received_alu70             <= '1';
			WHEN fetch_alu71 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu71;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu71, 13));
				received_alu71             <= '1';
			WHEN fetch_alu72 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu72;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu72, 13));
				received_alu72             <= '1';
			WHEN fetch_alu73 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu73;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu73, 13));
				received_alu73             <= '1';
			WHEN fetch_alu74 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu74;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu74, 13));
				received_alu74            <= '1';
			WHEN fetch_alu75 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu75;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu75, 13));
				received_alu75            <= '1';
			WHEN fetch_alu76 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu76;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu76, 13));
				received_alu76            <= '1';
			WHEN fetch_alu77 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu77;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu77, 13));
				received_alu77            <= '1';
			WHEN fetch_alu78 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu78;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu78, 13));
				received_alu78            <= '1';
			WHEN fetch_alu79 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu79;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu79, 13));
				received_alu79            <= '1';
			WHEN fetch_alu80 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu80;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu80, 13));
				received_alu80             <= '1';
			WHEN fetch_alu81 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu81;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu81, 13));
				received_alu81             <= '1';
			WHEN fetch_alu82 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu82;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu82, 13));
				received_alu82             <= '1';
			WHEN fetch_alu83 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu83;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu83, 13));
				received_alu83             <= '1';
			WHEN fetch_alu84 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu84;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu84, 13));
				received_alu84             <= '1';
			WHEN fetch_alu85 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu85;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu85, 13));
				received_alu85             <= '1';
			WHEN fetch_alu86 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu86;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu86, 13));
				received_alu86             <= '1';
			WHEN fetch_alu87 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu87;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu87, 13));
				received_alu87             <= '1';
			WHEN fetch_alu88 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu88;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu88, 13));
				received_alu88             <= '1';
			WHEN fetch_alu89 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu89;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu89, 13));
				received_alu89             <= '1';
			WHEN fetch_alu90 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu90;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu90, 13));
				received_alu90            <= '1';
			WHEN fetch_alu91 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu91;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu91, 13));
				received_alu91            <= '1';
			WHEN fetch_alu92 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu92;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu92, 13));
				received_alu92            <= '1';
			WHEN fetch_alu93 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu93;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu93, 13));
				received_alu93            <= '1';
			WHEN fetch_alu94 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu94;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu94, 13));
				received_alu94            <= '1';
			WHEN fetch_alu95 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu95;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu95, 13));
				received_alu95            <= '1';
			WHEN fetch_alu96 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu96;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu96, 13));
				received_alu96             <= '1';
			WHEN fetch_alu97 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu97;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu97, 13));
				received_alu97             <= '1';
			WHEN fetch_alu98 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu98;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu98, 13));
				received_alu98             <= '1';
			WHEN fetch_alu99 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu99;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu99, 13));
				received_alu99             <= '1';
			WHEN fetch_alu100 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu100;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu100, 13));
				received_alu100             <= '1';
			WHEN fetch_alu101 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu101;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu101, 13));
				received_alu101             <= '1';
			WHEN fetch_alu102 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu102;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu102, 13));
				received_alu102             <= '1';
			WHEN fetch_alu103 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu103;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu103, 13));
				received_alu103             <= '1';
			WHEN fetch_alu104 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu104;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu104, 13));
				received_alu104             <= '1';
			WHEN fetch_alu105 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu105;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu105, 13));
				received_alu105             <= '1';
			WHEN fetch_alu106 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu106;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu106, 13));
				received_alu106            <= '1';
			WHEN fetch_alu107 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu107;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu107, 13));
				received_alu107            <= '1';
			WHEN fetch_alu108 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu108;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu108, 13));
				received_alu108            <= '1';
			WHEN fetch_alu109 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu109;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu109, 13));
				received_alu109            <= '1';
			WHEN fetch_alu110 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu110;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu110, 13));
				received_alu110            <= '1';
			WHEN fetch_alu111 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu111;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu111, 13));
				received_alu111            <= '1';
			WHEN fetch_alu112 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu112;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu112, 13));
				received_alu112             <= '1';
			WHEN fetch_alu113 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu113;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu113, 13));
				received_alu113             <= '1';
			WHEN fetch_alu114 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu114;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu114, 13));
				received_alu114             <= '1';
			WHEN fetch_alu115 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu115;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu115, 13));
				received_alu115             <= '1';
			WHEN fetch_alu116 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu116;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu116, 13));
				received_alu116             <= '1';
			WHEN fetch_alu117 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu117;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu117, 13));
				received_alu117             <= '1';
			WHEN fetch_alu118 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu118;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu118, 13));
				received_alu118             <= '1';
			WHEN fetch_alu119 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu119;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu119, 13));
				received_alu119             <= '1';
			WHEN fetch_alu120 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu120;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu120, 13));
				received_alu120             <= '1';
			WHEN fetch_alu121 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu121;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu121, 13));
				received_alu121             <= '1';
			WHEN fetch_alu122 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu122;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu122, 13));
				received_alu122            <= '1';
			WHEN fetch_alu123 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu123;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu123, 13));
				received_alu123            <= '1';
			WHEN fetch_alu124 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu124;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu124, 13));
				received_alu124            <= '1';
			WHEN fetch_alu125 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu125;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu125, 13));
				received_alu125            <= '1';
			WHEN fetch_alu126 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu126;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu126, 13));
				received_alu126            <= '1';
			WHEN fetch_alu127 => 
				pixel_done                <= '1';
				result_data(22 DOWNTO 13) <= iteration_alu127;
				result_data(12 DOWNTO 0)  <= std_logic_vector(to_unsigned(pixel_alu127, 13));
				received_alu127            <= '1';
			WHEN wait_for_alus => 
		END CASE;
		current_pixel_inc <= current_pixel + 1;
	END PROCESS outputs;

	transitions : PROCESS (clk) IS BEGIN
		IF rising_edge(clk) THEN
			math_state_next <= math_state; --loop
			CASE math_state IS
				WHEN idle => 
					IF (run = '1') THEN
						math_state_next <= receive_llre;
					END IF;
				WHEN receive_llre => 
					IF (re_ready = '1') THEN
						math_state_next <= fetch_llre;
					END IF;
				WHEN fetch_llre => 
					math_state_next <= receive_llim;
				WHEN receive_llim => 
					IF (im_ready = '1') THEN
						math_state_next <= fetch_llim;
					END IF;
				WHEN fetch_llim => 
					math_state_next <= receive_zf;
				WHEN receive_zf => 
					IF (zf_ready = '1') THEN
						math_state_next <= fetch_zf;
					END IF;
				WHEN fetch_zf => 
					math_state_next <= pixel_ready;
				WHEN calc_next_pixel_re => IF (adder_a_ready = '1' AND adder_b_ready = '1') THEN
					math_state_next <= wait_for_re_value_ready;
			END IF;
				WHEN calc_next_pixel_im => 
				IF (adder_a_ready = '1' AND adder_b_ready = '1') THEN
					math_state_next <= wait_for_im_value_ready;
				END IF;
				WHEN wait_for_re_value_ready => 
				IF (adder_result_valid = '1') THEN
					math_state_next <= fetch_re;
				END IF;
				WHEN wait_for_im_value_ready => 
				IF (adder_result_valid = '1') THEN
					math_state_next <= fetch_im;
				END IF;
				WHEN fetch_re => 
				math_state_next <= pixel_ready;
				WHEN fetch_im => 
				math_state_next <= pixel_ready;
				WHEN pixel_ready => 
				IF (done_alu0 = '1') THEN --find idle alus and give them work
					math_state_next <= fetch_alu0;
				ELSIF (idle_alu0 = '1') THEN
					math_state_next <= run_alu0;
				ELSIF (done_alu1 = '1') THEN
					math_state_next <= fetch_alu1;
				ELSIF (idle_alu1 = '1') THEN
					math_state_next <= run_alu1;
				ELSIF (done_alu2 = '1') THEN
					math_state_next <= fetch_alu2;
				ELSIF (idle_alu2 = '1') THEN
					math_state_next <= run_alu2;
				ELSIF (done_alu3 = '1') THEN
					math_state_next <= fetch_alu3;
				ELSIF (idle_alu3 = '1') THEN
					math_state_next <= run_alu3;
				ELSIF (done_alu4 = '1') THEN
					math_state_next <= fetch_alu4;
				ELSIF (idle_alu4 = '1') THEN
					math_state_next <= run_alu4;
				ELSIF (done_alu5 = '1') THEN
					math_state_next <= fetch_alu5;
				ELSIF (idle_alu5 = '1') THEN
					math_state_next <= run_alu5;
				ELSIF (done_alu6 = '1') THEN
					math_state_next <= fetch_alu6;
				ELSIF (idle_alu6 = '1') THEN
					math_state_next <= run_alu6;
				ELSIF (done_alu7 = '1') THEN
					math_state_next <= fetch_alu7;
				ELSIF (idle_alu7 = '1') THEN
					math_state_next <= run_alu7;
				ELSIF (done_alu8 = '1') THEN
					math_state_next <= fetch_alu8;
				ELSIF (idle_alu8 = '1') THEN
					math_state_next <= run_alu8;
				ELSIF (done_alu9 = '1') THEN
					math_state_next <= fetch_alu9;
				ELSIF (idle_alu9 = '1') THEN
					math_state_next <= run_alu9;
				ELSIF (done_alu10 = '1') THEN
					math_state_next <= fetch_alu10;
				ELSIF (idle_alu10 = '1') THEN
					math_state_next <= run_alu10;
				ELSIF (done_alu11 = '1') THEN
					math_state_next <= fetch_alu11;
				ELSIF (idle_alu11 = '1') THEN
					math_state_next <= run_alu11;
				ELSIF (done_alu12 = '1') THEN
					math_state_next <= fetch_alu12;
				ELSIF (idle_alu12 = '1') THEN
					math_state_next <= run_alu12;
				ELSIF (done_alu13 = '1') THEN
					math_state_next <= fetch_alu13;
				ELSIF (idle_alu13 = '1') THEN
					math_state_next <= run_alu13;
				ELSIF (done_alu14 = '1') THEN
					math_state_next <= fetch_alu14;
				ELSIF (idle_alu14 = '1') THEN
					math_state_next <= run_alu14;
				ELSIF (done_alu15 = '1') THEN
					math_state_next <= fetch_alu15;
				ELSIF (idle_alu15 = '1') THEN
					math_state_next <= run_alu15;
				ELSIF (done_alu16 = '1') THEN
					math_state_next <= fetch_alu16;
				ELSIF (idle_alu16 = '1') THEN
					math_state_next <= run_alu16;
				ELSIF (done_alu17 = '1') THEN
					math_state_next <= fetch_alu17;
				ELSIF (idle_alu17 = '1') THEN
					math_state_next <= run_alu17;
				ELSIF (done_alu18 = '1') THEN
					math_state_next <= fetch_alu18;
				ELSIF (idle_alu18 = '1') THEN
					math_state_next <= run_alu18;
				ELSIF (done_alu19 = '1') THEN
					math_state_next <= fetch_alu19;
				ELSIF (idle_alu19 = '1') THEN
					math_state_next <= run_alu19;
				ELSIF (done_alu20 = '1') THEN
					math_state_next <= fetch_alu20;
				ELSIF (idle_alu20 = '1') THEN
					math_state_next <= run_alu20;
				ELSIF (done_alu21 = '1') THEN
					math_state_next <= fetch_alu21;
				ELSIF (idle_alu21 = '1') THEN
					math_state_next <= run_alu21;
				ELSIF (done_alu22 = '1') THEN
					math_state_next <= fetch_alu22;
				ELSIF (idle_alu22 = '1') THEN
					math_state_next <= run_alu22;
				ELSIF (done_alu23 = '1') THEN
					math_state_next <= fetch_alu23;
				ELSIF (idle_alu23 = '1') THEN
					math_state_next <= run_alu23;
				ELSIF (done_alu24 = '1') THEN
					math_state_next <= fetch_alu24;
				ELSIF (idle_alu24 = '1') THEN
					math_state_next <= run_alu24;
				ELSIF (done_alu25 = '1') THEN
					math_state_next <= fetch_alu25;
				ELSIF (idle_alu25 = '1') THEN
					math_state_next <= run_alu25;
				ELSIF (done_alu26 = '1') THEN
					math_state_next <= fetch_alu26;
				ELSIF (idle_alu26 = '1') THEN
					math_state_next <= run_alu26;
				ELSIF (done_alu27 = '1') THEN
					math_state_next <= fetch_alu27;
				ELSIF (idle_alu27 = '1') THEN
					math_state_next <= run_alu27;
				ELSIF (done_alu28 = '1') THEN
					math_state_next <= fetch_alu28;
				ELSIF (idle_alu28 = '1') THEN
					math_state_next <= run_alu28;
				ELSIF (done_alu29 = '1') THEN
					math_state_next <= fetch_alu29;
				ELSIF (idle_alu29 = '1') THEN
					math_state_next <= run_alu29;
				ELSIF (done_alu30 = '1') THEN
					math_state_next <= fetch_alu30;
				ELSIF (idle_alu30 = '1') THEN
					math_state_next <= run_alu30;
				ELSIF (done_alu31 = '1') THEN
					math_state_next <= fetch_alu31;
				ELSIF (idle_alu31 = '1') THEN
					math_state_next <= run_alu31;
				ELSIF (done_alu32 = '1') THEN
					math_state_next <= fetch_alu32;
				ELSIF (idle_alu32 = '1') THEN
					math_state_next <= run_alu32;
				ELSIF (done_alu33 = '1') THEN
					math_state_next <= fetch_alu33;
				ELSIF (idle_alu33 = '1') THEN
					math_state_next <= run_alu33;
				ELSIF (done_alu34 = '1') THEN
					math_state_next <= fetch_alu34;
				ELSIF (idle_alu34 = '1') THEN
					math_state_next <= run_alu34;
				ELSIF (done_alu35 = '1') THEN
					math_state_next <= fetch_alu35;
				ELSIF (idle_alu35 = '1') THEN
					math_state_next <= run_alu35;
				ELSIF (done_alu36 = '1') THEN
					math_state_next <= fetch_alu36;
				ELSIF (idle_alu36 = '1') THEN
					math_state_next <= run_alu36;
				ELSIF (done_alu37 = '1') THEN
					math_state_next <= fetch_alu37;
				ELSIF (idle_alu37 = '1') THEN
					math_state_next <= run_alu37;
				ELSIF (done_alu38 = '1') THEN
					math_state_next <= fetch_alu38;
				ELSIF (idle_alu38 = '1') THEN
					math_state_next <= run_alu38;
				ELSIF (done_alu39 = '1') THEN
					math_state_next <= fetch_alu39;
				ELSIF (idle_alu39 = '1') THEN
					math_state_next <= run_alu39;
				ELSIF (done_alu40 = '1') THEN
					math_state_next <= fetch_alu40;
				ELSIF (idle_alu40 = '1') THEN
					math_state_next <= run_alu40;
				ELSIF (done_alu41 = '1') THEN
					math_state_next <= fetch_alu41;
				ELSIF (idle_alu41 = '1') THEN
					math_state_next <= run_alu41;
				ELSIF (done_alu42 = '1') THEN
					math_state_next <= fetch_alu42;
				ELSIF (idle_alu42 = '1') THEN
					math_state_next <= run_alu42;
				ELSIF (done_alu43 = '1') THEN
					math_state_next <= fetch_alu43;
				ELSIF (idle_alu43 = '1') THEN
					math_state_next <= run_alu43;
				ELSIF (done_alu44 = '1') THEN
					math_state_next <= fetch_alu44;
				ELSIF (idle_alu44 = '1') THEN
					math_state_next <= run_alu4;
				ELSIF (done_alu45 = '1') THEN
					math_state_next <= fetch_alu45;
				ELSIF (idle_alu45 = '1') THEN
					math_state_next <= run_alu45;
				ELSIF (done_alu46 = '1') THEN
					math_state_next <= fetch_alu46;
				ELSIF (idle_alu46 = '1') THEN
					math_state_next <= run_alu46;
				ELSIF (done_alu47 = '1') THEN
					math_state_next <= fetch_alu47;
				ELSIF (idle_alu47 = '1') THEN
					math_state_next <= run_alu47;
				ELSIF (done_alu48 = '1') THEN
					math_state_next <= fetch_alu48;
				ELSIF (idle_alu48 = '1') THEN
					math_state_next <= run_alu48;
				ELSIF (done_alu49 = '1') THEN
					math_state_next <= fetch_alu49;
				ELSIF (idle_alu49 = '1') THEN
					math_state_next <= run_alu49;
				ELSIF (done_alu50 = '1') THEN
					math_state_next <= fetch_alu50;
				ELSIF (idle_alu50 = '1') THEN
					math_state_next <= run_alu50;
				ELSIF (done_alu51 = '1') THEN
					math_state_next <= fetch_alu51;
				ELSIF (idle_alu51 = '1') THEN
					math_state_next <= run_alu51;
				ELSIF (done_alu52 = '1') THEN
					math_state_next <= fetch_alu52;
				ELSIF (idle_alu52 = '1') THEN
					math_state_next <= run_alu52;
				ELSIF (done_alu53 = '1') THEN
					math_state_next <= fetch_alu53;
				ELSIF (idle_alu53 = '1') THEN
					math_state_next <= run_alu53;
				ELSIF (done_alu54 = '1') THEN
					math_state_next <= fetch_alu54;
				ELSIF (idle_alu54 = '1') THEN
					math_state_next <= run_alu54;
				ELSIF (done_alu55 = '1') THEN
					math_state_next <= fetch_alu55;
				ELSIF (idle_alu55 = '1') THEN
					math_state_next <= run_alu55;
				ELSIF (done_alu56 = '1') THEN
					math_state_next <= fetch_alu56;
				ELSIF (idle_alu56 = '1') THEN
					math_state_next <= run_alu56;
				ELSIF (done_alu57 = '1') THEN
					math_state_next <= fetch_alu57;
				ELSIF (idle_alu57 = '1') THEN
					math_state_next <= run_alu57;
				ELSIF (done_alu58 = '1') THEN
					math_state_next <= fetch_alu58;
				ELSIF (idle_alu58 = '1') THEN
					math_state_next <= run_alu58;
				ELSIF (done_alu59 = '1') THEN
					math_state_next <= fetch_alu59;
				ELSIF (idle_alu59 = '1') THEN
					math_state_next <= run_alu59;
				ELSIF (done_alu60 = '1') THEN
					math_state_next <= fetch_alu60;
				ELSIF (idle_alu60 = '1') THEN
					math_state_next <= run_alu60;
				ELSIF (done_alu61 = '1') THEN
					math_state_next <= fetch_alu61;
				ELSIF (idle_alu61 = '1') THEN
					math_state_next <= run_alu61;
				ELSIF (done_alu62 = '1') THEN
					math_state_next <= fetch_alu62;
				ELSIF (idle_alu62 = '1') THEN
					math_state_next <= run_alu62;
				ELSIF (done_alu63 = '1') THEN
					math_state_next <= fetch_alu63;
				ELSIF (idle_alu63 = '1') THEN
					math_state_next <= run_alu63;
				ELSIF (done_alu64 = '1') THEN
					math_state_next <= fetch_alu64;
				ELSIF (idle_alu64 = '1') THEN
					math_state_next <= run_alu64;
				ELSIF (done_alu65 = '1') THEN
					math_state_next <= fetch_alu65;
				ELSIF (idle_alu65 = '1') THEN
					math_state_next <= run_alu65;
				ELSIF (done_alu66 = '1') THEN
					math_state_next <= fetch_alu66;
				ELSIF (idle_alu66 = '1') THEN
					math_state_next <= run_alu66;
				ELSIF (done_alu67 = '1') THEN
					math_state_next <= fetch_alu67;
				ELSIF (idle_alu67 = '1') THEN
					math_state_next <= run_alu67;
				ELSIF (done_alu68 = '1') THEN
					math_state_next <= fetch_alu68;
				ELSIF (idle_alu68 = '1') THEN
					math_state_next <= run_alu68;
				ELSIF (done_alu69 = '1') THEN
					math_state_next <= fetch_alu69;
				ELSIF (idle_alu69 = '1') THEN
					math_state_next <= run_alu69;
				ELSIF (done_alu70 = '1') THEN
					math_state_next <= fetch_alu70;
				ELSIF (idle_alu70 = '1') THEN
					math_state_next <= run_alu70;
				ELSIF (done_alu71 = '1') THEN
					math_state_next <= fetch_alu81;
				ELSIF (idle_alu71 = '1') THEN
					math_state_next <= run_alu71;
				ELSIF (done_alu72 = '1') THEN
					math_state_next <= fetch_alu72;
				ELSIF (idle_alu72 = '1') THEN
					math_state_next <= run_alu72;
				ELSIF (done_alu73 = '1') THEN
					math_state_next <= fetch_alu73;
				ELSIF (idle_alu73 = '1') THEN
					math_state_next <= run_alu73;
				ELSIF (done_alu74 = '1') THEN
					math_state_next <= fetch_alu74;
				ELSIF (idle_alu74 = '1') THEN
					math_state_next <= run_alu74;
				ELSIF (done_alu75 = '1') THEN
					math_state_next <= fetch_alu75;
				ELSIF (idle_alu75 = '1') THEN
					math_state_next <= run_alu75;
				ELSIF (done_alu76 = '1') THEN
					math_state_next <= fetch_alu76;
				ELSIF (idle_alu76 = '1') THEN
					math_state_next <= run_alu76;
				ELSIF (done_alu77 = '1') THEN
					math_state_next <= fetch_alu77;
				ELSIF (idle_alu77 = '1') THEN
					math_state_next <= run_alu77;
				ELSIF (done_alu78 = '1') THEN
					math_state_next <= fetch_alu78;
				ELSIF (idle_alu78 = '1') THEN
					math_state_next <= run_alu78;
				ELSIF (done_alu79 = '1') THEN
					math_state_next <= fetch_alu79;
				ELSIF (idle_alu79 = '1') THEN
					math_state_next <= run_alu79;
				ELSIF (done_alu80 = '1') THEN
					math_state_next <= fetch_alu80;
				ELSIF (idle_alu80 = '1') THEN
					math_state_next <= run_alu80;
				ELSIF (done_alu81 = '1') THEN
					math_state_next <= fetch_alu81;
				ELSIF (idle_alu81 = '1') THEN
					math_state_next <= run_alu81;
				ELSIF (done_alu82 = '1') THEN
					math_state_next <= fetch_alu82;
				ELSIF (idle_alu82 = '1') THEN
					math_state_next <= run_alu82;
				ELSIF (done_alu83 = '1') THEN
					math_state_next <= fetch_alu83;
				ELSIF (idle_alu83 = '1') THEN
					math_state_next <= run_alu83;
				ELSIF (done_alu84 = '1') THEN
					math_state_next <= fetch_alu84;
				ELSIF (idle_alu84 = '1') THEN
					math_state_next <= run_alu84;
				ELSIF (done_alu85 = '1') THEN
					math_state_next <= fetch_alu85;
				ELSIF (idle_alu85 = '1') THEN
					math_state_next <= run_alu85;
				ELSIF (done_alu86 = '1') THEN
					math_state_next <= fetch_alu86;
				ELSIF (idle_alu86 = '1') THEN
					math_state_next <= run_alu86;
				ELSIF (done_alu87 = '1') THEN
					math_state_next <= fetch_alu87;
				ELSIF (idle_alu87 = '1') THEN
					math_state_next <= run_alu87;
				ELSIF (done_alu88 = '1') THEN
					math_state_next <= fetch_alu88;
				ELSIF (idle_alu88 = '1') THEN
					math_state_next <= run_alu88;
				ELSIF (done_alu89 = '1') THEN
					math_state_next <= fetch_alu89;
				ELSIF (idle_alu89 = '1') THEN
					math_state_next <= run_alu89;
				ELSIF (done_alu90 = '1') THEN
					math_state_next <= fetch_alu90;
				ELSIF (idle_alu90 = '1') THEN
					math_state_next <= run_alu90;
				ELSIF (done_alu91 = '1') THEN
					math_state_next <= fetch_alu91;
				ELSIF (idle_alu91 = '1') THEN
					math_state_next <= run_alu91;
				ELSIF (done_alu92 = '1') THEN
					math_state_next <= fetch_alu92;
				ELSIF (idle_alu92 = '1') THEN
					math_state_next <= run_alu92;
				ELSIF (done_alu93 = '1') THEN
					math_state_next <= fetch_alu93;
				ELSIF (idle_alu93 = '1') THEN
					math_state_next <= run_alu93;
				ELSIF (done_alu94 = '1') THEN
					math_state_next <= fetch_alu94;
				ELSIF (idle_alu94 = '1') THEN
					math_state_next <= run_alu94;
				ELSIF (done_alu95 = '1') THEN
					math_state_next <= fetch_alu95;
				ELSIF (idle_alu95 = '1') THEN
					math_state_next <= run_alu95;
				ELSIF (done_alu96 = '1') THEN
					math_state_next <= fetch_alu96;
				ELSIF (idle_alu96 = '1') THEN
					math_state_next <= run_alu96;
				ELSIF (done_alu97 = '1') THEN
					math_state_next <= fetch_alu97;
				ELSIF (idle_alu97 = '1') THEN
					math_state_next <= run_alu97;
				ELSIF (done_alu98 = '1') THEN
					math_state_next <= fetch_alu98;
				ELSIF (idle_alu98 = '1') THEN
					math_state_next <= run_alu98;
				ELSIF (done_alu99 = '1') THEN
					math_state_next <= fetch_alu99;
				ELSIF (idle_alu99 = '1') THEN
					math_state_next <= run_alu99;
				ELSIF (done_alu100 = '1') THEN
					math_state_next <= fetch_alu100;
				ELSIF (idle_alu100 = '1') THEN
					math_state_next <= run_alu100;
				ELSIF (done_alu101 = '1') THEN
					math_state_next <= fetch_alu101;
				ELSIF (idle_alu101 = '1') THEN
					math_state_next <= run_alu101;
				ELSIF (done_alu102 = '1') THEN
					math_state_next <= fetch_alu102;
				ELSIF (idle_alu102 = '1') THEN
					math_state_next <= run_alu102;
				ELSIF (done_alu103 = '1') THEN
					math_state_next <= fetch_alu103;
				ELSIF (idle_alu103 = '1') THEN
					math_state_next <= run_alu103;
				ELSIF (done_alu104 = '1') THEN
					math_state_next <= fetch_alu104;
				ELSIF (idle_alu104 = '1') THEN
					math_state_next <= run_alu104;
				ELSIF (done_alu105 = '1') THEN
					math_state_next <= fetch_alu105;
				ELSIF (idle_alu105 = '1') THEN
					math_state_next <= run_alu105;
				ELSIF (done_alu106 = '1') THEN
					math_state_next <= fetch_alu106;
				ELSIF (idle_alu106 = '1') THEN
					math_state_next <= run_alu106;
				ELSIF (done_alu107 = '1') THEN
					math_state_next <= fetch_alu107;
				ELSIF (idle_alu107 = '1') THEN
					math_state_next <= run_alu107;
				ELSIF (done_alu108 = '1') THEN
					math_state_next <= fetch_alu108;
				ELSIF (idle_alu108 = '1') THEN
					math_state_next <= run_alu4;
				ELSIF (done_alu109 = '1') THEN
					math_state_next <= fetch_alu109;
				ELSIF (idle_alu109 = '1') THEN
					math_state_next <= run_alu109;
				ELSIF (done_alu110 = '1') THEN
					math_state_next <= fetch_alu110;
				ELSIF (idle_alu110 = '1') THEN
					math_state_next <= run_alu110;
				ELSIF (done_alu111 = '1') THEN
					math_state_next <= fetch_alu111;
				ELSIF (idle_alu111 = '1') THEN
					math_state_next <= run_alu111;
				ELSIF (done_alu112 = '1') THEN
					math_state_next <= fetch_alu112;
				ELSIF (idle_alu112 = '1') THEN
					math_state_next <= run_alu112;
				ELSIF (done_alu113 = '1') THEN
					math_state_next <= fetch_alu113;
				ELSIF (idle_alu113 = '1') THEN
					math_state_next <= run_alu113;
				ELSIF (done_alu114 = '1') THEN
					math_state_next <= fetch_alu114;
				ELSIF (idle_alu114 = '1') THEN
					math_state_next <= run_alu114;
				ELSIF (done_alu115 = '1') THEN
					math_state_next <= fetch_alu115;
				ELSIF (idle_alu115 = '1') THEN
					math_state_next <= run_alu115;
				ELSIF (done_alu116 = '1') THEN
					math_state_next <= fetch_alu116;
				ELSIF (idle_alu116 = '1') THEN
					math_state_next <= run_alu116;
				ELSIF (done_alu117 = '1') THEN
					math_state_next <= fetch_alu117;
				ELSIF (idle_alu117 = '1') THEN
					math_state_next <= run_alu117;
				ELSIF (done_alu118 = '1') THEN
					math_state_next <= fetch_alu118;
				ELSIF (idle_alu118 = '1') THEN
					math_state_next <= run_alu118;
				ELSIF (done_alu119 = '1') THEN
					math_state_next <= fetch_alu119;
				ELSIF (idle_alu119 = '1') THEN
					math_state_next <= run_alu119;
				ELSIF (done_alu120 = '1') THEN
					math_state_next <= fetch_alu120;
				ELSIF (idle_alu120 = '1') THEN
					math_state_next <= run_alu120;
				ELSIF (done_alu121 = '1') THEN
					math_state_next <= fetch_alu121;
				ELSIF (idle_alu121 = '1') THEN
					math_state_next <= run_alu121;
				ELSIF (done_alu122 = '1') THEN
					math_state_next <= fetch_alu122;
				ELSIF (idle_alu122 = '1') THEN
					math_state_next <= run_alu122;
				ELSIF (done_alu123 = '1') THEN
					math_state_next <= fetch_alu123;
				ELSIF (idle_alu123 = '1') THEN
					math_state_next <= run_alu123;
				ELSIF (done_alu124 = '1') THEN
					math_state_next <= fetch_alu124;
				ELSIF (idle_alu124 = '1') THEN
					math_state_next <= run_alu124;
				ELSIF (done_alu125 = '1') THEN
					math_state_next <= fetch_alu125;
				ELSIF (idle_alu125 = '1') THEN
					math_state_next <= run_alu125;
				ELSIF (done_alu126 = '1') THEN
					math_state_next <= fetch_alu126;
				ELSIF (idle_alu126 = '1') THEN
					math_state_next <= run_alu126;
				ELSIF (done_alu127 = '1') THEN
					math_state_next <= fetch_alu127;
				ELSIF (idle_alu127 = '1') THEN
					math_state_next <= run_alu127;
				END IF;

				WHEN inc_pixel => 
				IF ((current_pixel MOD display_width = 0) AND current_pixel /= 6144) THEN --line break, increase im value
					math_state_next <= calc_next_pixel_im;
				ELSIF ((current_pixel MOD display_width /= 0) AND current_pixel /= 6144) THEN
					math_state_next <= calc_next_pixel_re;
				ELSE
					math_state_next <= wait_for_alus;
				END IF;
				WHEN run_alu0 | run_alu1 | run_alu2 | run_alu3 | run_alu4 | run_alu5 | run_alu6 | run_alu7 | run_alu8 | run_alu9 | run_alu10 | run_alu11 | run_alu12 | run_alu13 | run_alu14 | run_alu15 | run_alu16 | run_alu17 | run_alu18 | run_alu19 | run_alu20 | run_alu21 | run_alu22 | run_alu23 | run_alu24 | run_alu25 | run_alu26 | run_alu27 | run_alu28 | run_alu29 | run_alu30 | run_alu31 | run_alu32 | run_alu33 | run_alu34 | run_alu35 | run_alu36 | run_alu37 | run_alu38 | run_alu39 | run_alu40 | run_alu41 | run_alu42 | run_alu43 | run_alu44 | run_alu45 | run_alu46 | run_alu47 | run_alu48 | run_alu49 | run_alu50 | run_alu51 | run_alu52 | run_alu53 | run_alu54 | run_alu55 | run_alu56 | run_alu57 | run_alu58 | run_alu59 | run_alu60 | run_alu61 | run_alu62 | run_alu63 | run_alu64 | run_alu65 | run_alu66 | run_alu67 | run_alu68 | run_alu69 | run_alu70 | run_alu71 | run_alu72 | run_alu73 | run_alu74 | run_alu75 | run_alu76 | run_alu77 | run_alu78 | run_alu79 | run_alu80 | run_alu81 | run_alu82 | run_alu83 | run_alu84 | run_alu85 | run_alu86 | run_alu87 | run_alu88 | run_alu89 | run_alu90 | run_alu91 | run_alu92 | run_alu93 | run_alu94 | run_alu95 | run_alu96 | run_alu97 | run_alu98 | run_alu99 | run_alu100 | run_alu101 | run_alu102 | run_alu103 | run_alu104 | run_alu105 | run_alu106 | run_alu107 | run_alu108 | run_alu109 | run_alu110 | run_alu111 | run_alu112 | run_alu113 | run_alu114 | run_alu115 | run_alu116 | run_alu117 | run_alu118 | run_alu119 | run_alu120 | run_alu121 | run_alu122 | run_alu123 | run_alu124 | run_alu125 | run_alu126 | run_alu127 => 
				math_state_next <= inc_pixel;
				WHEN fetch_alu0 | fetch_alu1 | fetch_alu2 | fetch_alu3 | fetch_alu4 | fetch_alu5 | fetch_alu6 | fetch_alu7 | fetch_alu8 | fetch_alu9 | fetch_alu10 | fetch_alu11 | fetch_alu12 | fetch_alu13 | fetch_alu14 | fetch_alu15 |  fetch_alu16 | fetch_alu17 | fetch_alu18 | fetch_alu19 | fetch_alu20 | fetch_alu21 | fetch_alu22 | fetch_alu23 | fetch_alu24 | fetch_alu25 | fetch_alu26 | fetch_alu27 | fetch_alu28 | fetch_alu29 | fetch_alu30 | fetch_alu31 | fetch_alu32 | fetch_alu33 | fetch_alu34 | fetch_alu35 | fetch_alu36 | fetch_alu37 | fetch_alu38 | fetch_alu39 | fetch_alu40 | fetch_alu41 | fetch_alu42 | fetch_alu43 | fetch_alu44 | fetch_alu45 | fetch_alu46 | fetch_alu47 |  fetch_alu48 | fetch_alu49 | fetch_alu50 | fetch_alu51 | fetch_alu52 | fetch_alu53 | fetch_alu54 | fetch_alu55 | fetch_alu56 | fetch_alu57 | fetch_alu58 | fetch_alu59 | fetch_alu60 | fetch_alu61 | fetch_alu62 | fetch_alu63 | fetch_alu64 | fetch_alu65 | fetch_alu66 | fetch_alu67 | fetch_alu68 | fetch_alu69 | fetch_alu70 | fetch_alu71 | fetch_alu72 | fetch_alu73 | fetch_alu74 | fetch_alu75 | fetch_alu76 | fetch_alu77 | fetch_alu78 | fetch_alu79 |  fetch_alu80 | fetch_alu81 | fetch_alu82 | fetch_alu83 | fetch_alu84 | fetch_alu85 | fetch_alu86 | fetch_alu87 | fetch_alu88 | fetch_alu89 | fetch_alu90 | fetch_alu91 | fetch_alu92 | fetch_alu93 | fetch_alu94 | fetch_alu95 | fetch_alu96 | fetch_alu97 | fetch_alu98 | fetch_alu99 | fetch_alu100 | fetch_alu101 | fetch_alu102 | fetch_alu103 | fetch_alu104 | fetch_alu105 | fetch_alu106 | fetch_alu107 | fetch_alu108 | fetch_alu109 | fetch_alu110 | fetch_alu111 |  fetch_alu112 | fetch_alu113 | fetch_alu114 | fetch_alu115 | fetch_alu116 | fetch_alu117 | fetch_alu118 | fetch_alu119 | fetch_alu120 | fetch_alu121 | fetch_alu122 | fetch_alu123 | fetch_alu124 | fetch_alu125 | fetch_alu126 | fetch_alu127 => 
				IF (current_pixel = 6144) THEN
					IF (pixel_received = '1') THEN
						math_state_next <= wait_for_alus;
					END IF;
				ELSIF (current_pixel < 6144) THEN
					IF (pixel_received = '1') THEN
						math_state_next <= pixel_ready;
					END IF;
				END IF;
				WHEN wait_for_alus => 
				IF (done_alu0 = '1') THEN
					math_state_next <= fetch_alu0;
				ELSIF (done_alu1 = '1') THEN
					math_state_next <= fetch_alu1;
				ELSIF (done_alu2 = '1') THEN
					math_state_next <= fetch_alu2;
				ELSIF (done_alu3 = '1') THEN
					math_state_next <= fetch_alu3;
				ELSIF (done_alu4 = '1') THEN
					math_state_next <= fetch_alu4;
				ELSIF (done_alu5 = '1') THEN
					math_state_next <= fetch_alu5;
				ELSIF (done_alu6 = '1') THEN
					math_state_next <= fetch_alu6;
				ELSIF (done_alu7 = '1') THEN
					math_state_next <= fetch_alu7;
				ELSIF (done_alu8 = '1') THEN
					math_state_next <= fetch_alu8;
				ELSIF (done_alu9 = '1') THEN
					math_state_next <= fetch_alu9;
				ELSIF (done_alu10 = '1') THEN
					math_state_next <= fetch_alu10;
				ELSIF (done_alu11 = '1') THEN
					math_state_next <= fetch_alu11;
				ELSIF (done_alu12 = '1') THEN
					math_state_next <= fetch_alu12;
				ELSIF (done_alu13 = '1') THEN
					math_state_next <= fetch_alu13;
				ELSIF (done_alu14 = '1') THEN
					math_state_next <= fetch_alu14;
				ELSIF (done_alu15 = '1') THEN
					math_state_next <= fetch_alu15;
				ELSIF (done_alu16 = '1') THEN
					math_state_next <= fetch_alu16;
				ELSIF (done_alu17 = '1') THEN
					math_state_next <= fetch_alu17;
				ELSIF (done_alu18 = '1') THEN
					math_state_next <= fetch_alu18;
				ELSIF (done_alu19 = '1') THEN
					math_state_next <= fetch_alu19;
				ELSIF (done_alu20 = '1') THEN
					math_state_next <= fetch_alu20;
				ELSIF (done_alu21 = '1') THEN
					math_state_next <= fetch_alu21;
				ELSIF (done_alu22 = '1') THEN
					math_state_next <= fetch_alu22;
				ELSIF (done_alu23 = '1') THEN
					math_state_next <= fetch_alu23;
				ELSIF (done_alu24 = '1') THEN
					math_state_next <= fetch_alu24;
				ELSIF (done_alu25 = '1') THEN
					math_state_next <= fetch_alu25;
				ELSIF (done_alu26 = '1') THEN
					math_state_next <= fetch_alu26;
				ELSIF (done_alu27 = '1') THEN
					math_state_next <= fetch_alu27;
				ELSIF (done_alu28 = '1') THEN
					math_state_next <= fetch_alu28;
				ELSIF (done_alu29 = '1') THEN
					math_state_next <= fetch_alu29;
				ELSIF (done_alu30 = '1') THEN
					math_state_next <= fetch_alu30;
				ELSIF (done_alu31 = '1') THEN
					math_state_next <= fetch_alu31;
				ELSIF (done_alu32 = '1') THEN
					math_state_next <= fetch_alu32;
				ELSIF (done_alu33 = '1') THEN
					math_state_next <= fetch_alu33;
				ELSIF (done_alu34 = '1') THEN
					math_state_next <= fetch_alu34;
				ELSIF (done_alu35 = '1') THEN
					math_state_next <= fetch_alu35;
				ELSIF (done_alu36 = '1') THEN
					math_state_next <= fetch_alu36;
				ELSIF (done_alu37 = '1') THEN
					math_state_next <= fetch_alu37;
				ELSIF (done_alu38 = '1') THEN
					math_state_next <= fetch_alu38;
				ELSIF (done_alu39 = '1') THEN
					math_state_next <= fetch_alu39;
				ELSIF (done_alu40 = '1') THEN
					math_state_next <= fetch_alu40;
				ELSIF (done_alu41 = '1') THEN
					math_state_next <= fetch_alu41;
				ELSIF (done_alu42 = '1') THEN
					math_state_next <= fetch_alu42;
				ELSIF (done_alu43 = '1') THEN
					math_state_next <= fetch_alu43;
				ELSIF (done_alu44 = '1') THEN
					math_state_next <= fetch_alu44;
				ELSIF (done_alu45 = '1') THEN
					math_state_next <= fetch_alu45;
				ELSIF (done_alu46 = '1') THEN
					math_state_next <= fetch_alu46;
				ELSIF (done_alu47 = '1') THEN
					math_state_next <= fetch_alu47;
				ELSIF (done_alu48 = '1') THEN
					math_state_next <= fetch_alu48;
				ELSIF (done_alu49 = '1') THEN
					math_state_next <= fetch_alu49;
				ELSIF (done_alu50 = '1') THEN
					math_state_next <= fetch_alu50;
				ELSIF (done_alu51 = '1') THEN
					math_state_next <= fetch_alu51;
				ELSIF (done_alu52 = '1') THEN
					math_state_next <= fetch_alu52;
				ELSIF (done_alu53 = '1') THEN
					math_state_next <= fetch_alu53;
				ELSIF (done_alu54 = '1') THEN
					math_state_next <= fetch_alu54;
				ELSIF (done_alu55 = '1') THEN
					math_state_next <= fetch_alu55;
				ELSIF (done_alu56 = '1') THEN
					math_state_next <= fetch_alu56;
				ELSIF (done_alu57 = '1') THEN
					math_state_next <= fetch_alu57;
				ELSIF (done_alu58 = '1') THEN
					math_state_next <= fetch_alu58;
				ELSIF (done_alu59 = '1') THEN
					math_state_next <= fetch_alu59;
				ELSIF (done_alu60 = '1') THEN
					math_state_next <= fetch_alu60;
				ELSIF (done_alu61 = '1') THEN
					math_state_next <= fetch_alu61;
				ELSIF (done_alu62 = '1') THEN
					math_state_next <= fetch_alu62;
				ELSIF (done_alu63 = '1') THEN
					math_state_next <= fetch_alu63;
				ELSIF (done_alu64 = '1') THEN
					math_state_next <= fetch_alu64;
				ELSIF (done_alu65 = '1') THEN
					math_state_next <= fetch_alu65;
				ELSIF (done_alu66 = '1') THEN
					math_state_next <= fetch_alu66;
				ELSIF (done_alu67 = '1') THEN
					math_state_next <= fetch_alu67;
				ELSIF (done_alu68 = '1') THEN
					math_state_next <= fetch_alu68;
				ELSIF (done_alu69 = '1') THEN
					math_state_next <= fetch_alu69;
				ELSIF (done_alu70 = '1') THEN
					math_state_next <= fetch_alu70;
				ELSIF (done_alu71 = '1') THEN
					math_state_next <= fetch_alu71;
				ELSIF (done_alu72 = '1') THEN
					math_state_next <= fetch_alu72;
				ELSIF (done_alu73 = '1') THEN
					math_state_next <= fetch_alu73;
				ELSIF (done_alu74 = '1') THEN
					math_state_next <= fetch_alu74;
				ELSIF (done_alu75 = '1') THEN
					math_state_next <= fetch_alu75;
				ELSIF (done_alu76 = '1') THEN
					math_state_next <= fetch_alu76;
				ELSIF (done_alu77 = '1') THEN
					math_state_next <= fetch_alu77;
				ELSIF (done_alu78 = '1') THEN
					math_state_next <= fetch_alu78;
				ELSIF (done_alu79 = '1') THEN
					math_state_next <= fetch_alu79;
				ELSIF (done_alu80 = '1') THEN
					math_state_next <= fetch_alu80;
				ELSIF (done_alu81 = '1') THEN
					math_state_next <= fetch_alu81;
				ELSIF (done_alu82 = '1') THEN
					math_state_next <= fetch_alu82;
				ELSIF (done_alu83 = '1') THEN
					math_state_next <= fetch_alu83;
				ELSIF (done_alu84 = '1') THEN
					math_state_next <= fetch_alu84;
				ELSIF (done_alu85 = '1') THEN
					math_state_next <= fetch_alu85;
				ELSIF (done_alu86 = '1') THEN
					math_state_next <= fetch_alu86;
				ELSIF (done_alu87 = '1') THEN
					math_state_next <= fetch_alu87;
				ELSIF (done_alu88 = '1') THEN
					math_state_next <= fetch_alu88;
				ELSIF (done_alu89 = '1') THEN
					math_state_next <= fetch_alu89;
				ELSIF (done_alu90 = '1') THEN
					math_state_next <= fetch_alu90;
				ELSIF (done_alu91 = '1') THEN
					math_state_next <= fetch_alu91;
				ELSIF (done_alu92 = '1') THEN
					math_state_next <= fetch_alu92;
				ELSIF (done_alu93 = '1') THEN
					math_state_next <= fetch_alu93;
				ELSIF (done_alu94 = '1') THEN
					math_state_next <= fetch_alu94;
				ELSIF (done_alu95 = '1') THEN
					math_state_next <= fetch_alu95;
				ELSIF (done_alu96 = '1') THEN
					math_state_next <= fetch_alu96;
				ELSIF (done_alu97 = '1') THEN
					math_state_next <= fetch_alu97;
				ELSIF (done_alu98 = '1') THEN
					math_state_next <= fetch_alu98;
				ELSIF (done_alu99 = '1') THEN
					math_state_next <= fetch_alu99;
				ELSIF (done_alu100 = '1') THEN
					math_state_next <= fetch_alu100;
				ELSIF (done_alu101 = '1') THEN
					math_state_next <= fetch_alu101;
				ELSIF (done_alu102 = '1') THEN
					math_state_next <= fetch_alu102;
				ELSIF (done_alu103 = '1') THEN
					math_state_next <= fetch_alu103;
				ELSIF (done_alu104 = '1') THEN
					math_state_next <= fetch_alu104;
				ELSIF (done_alu105 = '1') THEN
					math_state_next <= fetch_alu105;
				ELSIF (done_alu106 = '1') THEN
					math_state_next <= fetch_alu106;
				ELSIF (done_alu107 = '1') THEN
					math_state_next <= fetch_alu107;
				ELSIF (done_alu108 = '1') THEN
					math_state_next <= fetch_alu108;
				ELSIF (done_alu109 = '1') THEN
					math_state_next <= fetch_alu109;
				ELSIF (done_alu110 = '1') THEN
					math_state_next <= fetch_alu110;
				ELSIF (done_alu111 = '1') THEN
					math_state_next <= fetch_alu111;
				ELSIF (done_alu112 = '1') THEN
					math_state_next <= fetch_alu112;
				ELSIF (done_alu113 = '1') THEN
					math_state_next <= fetch_alu113;
				ELSIF (done_alu114 = '1') THEN
					math_state_next <= fetch_alu114;
				ELSIF (done_alu115 = '1') THEN
					math_state_next <= fetch_alu115;
				ELSIF (done_alu116 = '1') THEN
					math_state_next <= fetch_alu116;
				ELSIF (done_alu117 = '1') THEN
					math_state_next <= fetch_alu117;
				ELSIF (done_alu118 = '1') THEN
					math_state_next <= fetch_alu118;
				ELSIF (done_alu119 = '1') THEN
					math_state_next <= fetch_alu119;
				ELSIF (done_alu120 = '1') THEN
					math_state_next <= fetch_alu120;
				ELSIF (done_alu121 = '1') THEN
					math_state_next <= fetch_alu121;
				ELSIF (done_alu122 = '1') THEN
					math_state_next <= fetch_alu122;
				ELSIF (done_alu123 = '1') THEN
					math_state_next <= fetch_alu123;
				ELSIF (done_alu124 = '1') THEN
					math_state_next <= fetch_alu124;
				ELSIF (done_alu125 = '1') THEN
					math_state_next <= fetch_alu125;
				ELSIF (done_alu126 = '1') THEN
					math_state_next <= fetch_alu126;
				ELSIF (done_alu127 = '1') THEN
					math_state_next <= fetch_alu127;
				END IF;

				IF ((idle_alu0 = '1') AND (idle_alu1 = '1') AND (idle_alu2 = '1') AND (idle_alu3 = '1') AND (idle_alu4 = '1') AND (idle_alu5 = '1') AND (idle_alu6 = '1') AND (idle_alu7 = '1') AND (idle_alu8 = '1') AND (idle_alu9 = '1') AND (idle_alu10 = '1') AND (idle_alu11 = '1') AND (idle_alu12 = '1') AND (idle_alu13 = '1') AND (idle_alu14 = '1') AND (idle_alu15 = '1') and (idle_alu16 = '1') AND (idle_alu17 = '1') AND (idle_alu18 = '1') AND (idle_alu19 = '1') AND (idle_alu20 = '1') AND (idle_alu21 = '1') AND (idle_alu22 = '1') AND (idle_alu23 = '1') AND (idle_alu24 = '1') AND (idle_alu25 = '1') AND (idle_alu26 = '1') AND (idle_alu27 = '1') AND (idle_alu28 = '1') AND (idle_alu29 = '1') AND (idle_alu30 = '1') AND (idle_alu31 = '1') and (idle_alu32 = '1') AND (idle_alu33 = '1') AND (idle_alu34 = '1') AND (idle_alu35 = '1') AND (idle_alu36 = '1') AND (idle_alu37 = '1') AND (idle_alu38 = '1') AND (idle_alu39 = '1') AND (idle_alu40 = '1') AND (idle_alu41 = '1') AND (idle_alu42 = '1') AND (idle_alu43 = '1') AND (idle_alu44 = '1') AND (idle_alu45 = '1') AND (idle_alu46 = '1') AND (idle_alu47 = '1') and (idle_alu48 = '1') AND (idle_alu49 = '1') AND (idle_alu50 = '1') AND (idle_alu51 = '1') AND (idle_alu52 = '1') AND (idle_alu53 = '1') AND (idle_alu54 = '1') AND (idle_alu55 = '1') AND (idle_alu56 = '1') AND (idle_alu57 = '1') AND (idle_alu58 = '1') AND (idle_alu59 = '1') AND (idle_alu60 = '1') AND (idle_alu61 = '1') AND (idle_alu62 = '1') AND (idle_alu63 = '1') AND (idle_alu64 = '1') AND (idle_alu65 = '1') AND (idle_alu66 = '1') AND (idle_alu67 = '1') AND (idle_alu68 = '1') AND (idle_alu69 = '1') AND (idle_alu70 = '1') AND (idle_alu71 = '1') AND (idle_alu72 = '1') AND (idle_alu73 = '1') AND (idle_alu74 = '1') AND (idle_alu75 = '1') AND (idle_alu76 = '1') AND (idle_alu77 = '1') AND (idle_alu78 = '1') AND (idle_alu79 = '1') and (idle_alu80 = '1') AND (idle_alu81 = '1') AND (idle_alu82 = '1') AND (idle_alu83 = '1') AND (idle_alu84 = '1') AND (idle_alu85 = '1') AND (idle_alu86 = '1') AND (idle_alu87 = '1') AND (idle_alu88 = '1') AND (idle_alu89 = '1') AND (idle_alu90 = '1') AND (idle_alu91 = '1') AND (idle_alu92 = '1') AND (idle_alu93 = '1') AND (idle_alu94 = '1') AND (idle_alu95 = '1') and (idle_alu96 = '1') AND (idle_alu97 = '1') AND (idle_alu98 = '1') AND (idle_alu99 = '1') AND (idle_alu100 = '1') AND (idle_alu101 = '1') AND (idle_alu102 = '1') AND (idle_alu103 = '1') AND (idle_alu104 = '1') AND (idle_alu105 = '1') AND (idle_alu106 = '1') AND (idle_alu107 = '1') AND (idle_alu108 = '1') AND (idle_alu109 = '1') AND (idle_alu110 = '1') AND (idle_alu111 = '1') and (idle_alu112 = '1') AND (idle_alu113 = '1') AND (idle_alu114 = '1') AND (idle_alu115 = '1') AND (idle_alu116 = '1') AND (idle_alu117 = '1') AND (idle_alu118 = '1') AND (idle_alu119 = '1') AND (idle_alu120 = '1') AND (idle_alu121 = '1') AND (idle_alu122 = '1') AND (idle_alu123 = '1') AND (idle_alu124 = '1') AND (idle_alu125 = '1') AND (idle_alu126 = '1') AND (idle_alu127 = '1')) THEN
					math_state_next <= idle;
				END IF;
		END CASE;
	END IF;
END PROCESS transitions;

END Behavioral;
