----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 02.06.2017 11:35:52
-- Design Name: 
-- Module Name: jstk_controller - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity jstk_controller is
port (
    clk : in std_logic;
    reset : in std_logic;
    led2 : in std_logic;
    led1 : in std_logic;
    up : out std_logic;
    down : out std_logic;
    left : out std_logic;
    right : out std_logic;
    btn1 : out std_logic;
    btn2 : out std_logic;
    btn3 : out std_logic;
    miso : in std_logic;
    ss : out std_logic;
    sclk : out std_logic;
    mosi : out std_logic
);
end jstk_controller;

architecture Behavioral of jstk_controller is

component PmodJSTK
Port ( 
    CLK : in  STD_LOGIC;
    RST : in  STD_LOGIC;
    sndRec : in  STD_LOGIC;
    DIN : in  STD_LOGIC_VECTOR (7 downto 0);
    MISO : in  STD_LOGIC;
    SS : out  STD_LOGIC;
    SCLK : out  STD_LOGIC;
    MOSI : out  STD_LOGIC;
    DOUT : inout  STD_LOGIC_VECTOR (39 downto 0));
end component;

component ClkDiv_5Hz port (
    CLK : in  STD_LOGIC;
    RST : in  STD_LOGIC;
    CLKOUT : inout  STD_LOGIC
);
end component;

--signals for joystick
signal clk5hz : std_logic;
signal dout : STD_LOGIC_VECTOR(39 downto 0) := (others => '0');
signal din : std_logic_vector(7 downto 0) := "10000000";

begin

jstk_clk: ClkDiv_5Hz port map (
    CLK => clk,
    RST => reset,
    CLKOUT => clk5hz
);

jstk_controller: PmodJSTK port map (
    clk => clk,
    rst => reset,
    sndrec => clk5hz,
    din => din,
    miso => miso,
    ss => ss,
    sclk => sclk,
    mosi => mosi,
    dout => dout
);

din <= "100000" & led2 & led1;

btn3 <= dout(0);
btn2 <= dout(2);
btn1 <= dout(1);
up <= (dout(24) and dout (25));
down <= (dout(24) nor dout(25));
left <= (dout(8) and dout(9));
right <= (dout(8) nor dout(9));


end Behavioral;
