----------------------------------------------------------------------------------
-- Company:
-- Engineer: Meister Rados
--
-- Create Date: 02.05.2017 21:07:44
-- Design Name:
-- Module Name: complex_alu - Behavioral
-- Project Name: Bachelorarbeit
-- Target Devices: Artix-7
-- Tool Versions:
-- Description: Komplexe-ALU der Bachelorarbeit
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
----------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
USE IEEE.NUMERIC_STD.ALL; 

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

ENTITY complex_alu IS
	PORT 
	(
		re, im                      : IN std_logic_vector (63 DOWNTO 0);
		iteration_out               : OUT std_logic_vector (9 DOWNTO 0);
		clk, start, received, reset : IN std_logic;
		done                        : OUT std_logic := '0';
		idle                        : OUT std_logic := '1'
	);
END complex_alu;

ARCHITECTURE Behavioral OF complex_alu IS

	--signals for fsm
	TYPE complex_states IS (c_idle, c_iterate, c_init, c_converge, c_diverge, c_calc0, c_calc1, c_calc2, c_calc3, c_calc4, c_calc5, c_calc6, c_calc7, c_calc8, c_calc9, c_calc10, c_calc11, c_calc12);
	SIGNAL complex_state                                                      : complex_states := c_idle;
	SIGNAL complex_state_next                                                 : complex_states;
	SIGNAL z0_re, z0_im, z_re, z_im, z_re_s, z_im_s, z_absolute, zp_re, zp_im : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL l0, l1, l2, l3, l4, l5, l6, l7, l8, l9                             : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL iteration                                                          : NATURAL RANGE 0 TO 1000;

	--signals for IPCores
	--where m is for the multiplyers, a for the adder and s for the subtractor

	SIGNAL m0_a_valid, m0_a_ready, m0_b_valid, m0_b_ready, m0_result_valid, m0_result_ready : std_logic := '0';
	SIGNAL m0_a_data, m0_b_data, m0_result                                                  : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL m1_a_valid, m1_a_ready, m1_b_valid, m1_b_ready, m1_result_valid, m1_result_ready : std_logic := '0';
	SIGNAL m1_a_data, m1_b_data, m1_result                                                  : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL a0_a_valid, a0_a_ready, a0_b_valid, a0_b_ready, a0_result_valid, a0_result_ready : std_logic := '0';
	SIGNAL a0_a_data, a0_b_data, a0_result                                                  : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";
	SIGNAL s0_a_valid, s0_a_ready, s0_b_valid, s0_b_ready, s0_result_valid, s0_result_ready : std_logic := '0';
	SIGNAL s0_a_data, s0_b_data, s0_result                                                  : std_logic_vector (63 DOWNTO 0) := "0000000000000000000000000000000000000000000000000000000000000000";

	COMPONENT floating_point_multiply
		PORT 
		(
			aclk                 : IN STD_LOGIC;
			s_axis_a_tvalid      : IN STD_LOGIC;
			s_axis_a_tready      : OUT STD_LOGIC;
			s_axis_a_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid      : IN STD_LOGIC;
			s_axis_b_tready      : OUT STD_LOGIC;
			s_axis_b_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata  : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);
	END COMPONENT;

	COMPONENT floating_point_adder
		PORT 
		(
			aclk                 : IN STD_LOGIC;
			s_axis_a_tvalid      : IN STD_LOGIC;
			s_axis_a_tready      : OUT STD_LOGIC;
			s_axis_a_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid      : IN STD_LOGIC;
			s_axis_b_tready      : OUT STD_LOGIC;
			s_axis_b_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata  : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);
	END COMPONENT;

	COMPONENT floating_point_subtractor
		PORT 
		(
			aclk                 : IN STD_LOGIC;
			s_axis_a_tvalid      : IN STD_LOGIC;
			s_axis_a_tready      : OUT STD_LOGIC;
			s_axis_a_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			s_axis_b_tvalid      : IN STD_LOGIC;
			s_axis_b_tready      : OUT STD_LOGIC;
			s_axis_b_tdata       : IN STD_LOGIC_VECTOR(63 DOWNTO 0);
			m_axis_result_tvalid : OUT STD_LOGIC;
			m_axis_result_tready : IN STD_LOGIC;
			m_axis_result_tdata  : OUT STD_LOGIC_VECTOR(63 DOWNTO 0)
		);
	END COMPONENT;

BEGIN
	multiplyer0 : floating_point_multiply
	PORT MAP
	(
		aclk                 => clk, 
		s_axis_a_tvalid      => m0_a_valid, 
		s_axis_a_tready      => m0_a_ready, 
		s_axis_a_tdata       => m0_a_data, 
		s_axis_b_tvalid      => m0_b_valid, 
		s_axis_b_tready      => m0_b_ready, 
		s_axis_b_tdata       => m0_b_data, 
		m_axis_result_tvalid => m0_result_valid, 
		m_axis_result_tready => m0_result_ready, 
		m_axis_result_tdata  => m0_result
	);

	multiplyer1 : floating_point_multiply
	PORT MAP
	(
		aclk                 => clk, 
		s_axis_a_tvalid      => m1_a_valid, 
		s_axis_a_tready      => m1_a_ready, 
		s_axis_a_tdata       => m1_a_data, 
		s_axis_b_tvalid      => m1_b_valid, 
		s_axis_b_tready      => m1_b_ready, 
		s_axis_b_tdata       => m1_b_data, 
		m_axis_result_tvalid => m1_result_valid, 
		m_axis_result_tready => m1_result_ready, 
		m_axis_result_tdata  => m1_result
	);

	adder0 : floating_point_adder
	PORT MAP
	(
		aclk                 => clk, 
		s_axis_a_tvalid      => a0_a_valid, 
		s_axis_a_tready      => a0_a_ready, 
		s_axis_a_tdata       => a0_a_data, 
		s_axis_b_tvalid      => a0_b_valid, 
		s_axis_b_tready      => a0_b_ready, 
		s_axis_b_tdata       => a0_b_data, 
		m_axis_result_tvalid => a0_result_valid, 
		m_axis_result_tready => a0_result_ready, 
		m_axis_result_tdata  => a0_result
	);

	subtractor0 : floating_point_subtractor
	PORT MAP
	(
		aclk                 => clk, 
		s_axis_a_tvalid      => s0_a_valid, 
		s_axis_a_tready      => s0_a_ready, 
		s_axis_a_tdata       => s0_a_data, 
		s_axis_b_tvalid      => s0_b_valid, 
		s_axis_b_tready      => s0_b_ready, 
		s_axis_b_tdata       => s0_b_data, 
		m_axis_result_tvalid => s0_result_valid, 
		m_axis_result_tready => s0_result_ready, 
		m_axis_result_tdata  => s0_result
	);

	--next state process
	next_state : PROCESS (clk) IS BEGIN
		IF rising_edge(clk) THEN
			IF (reset = '1') THEN
				complex_state <= c_idle;
			ELSE
				complex_state <= complex_state_next;
			END IF;
		END IF;
	END PROCESS;

	outputs : PROCESS (complex_state) IS BEGIN
		idle            <= '0';
		done            <= '0';
		m0_a_valid      <= '0';
		m0_b_valid      <= '0';
		m0_result_ready <= '0';
		m1_a_valid      <= '0';
		m1_b_valid      <= '0';
		m1_result_ready <= '0';
		a0_a_valid      <= '0';
		a0_b_valid      <= '0';
		a0_result_ready <= '0';
		s0_a_valid      <= '0';
		s0_b_valid      <= '0';
		s0_result_ready <= '0';
		m0_a_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		m0_b_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		m1_a_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		m1_b_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		a0_a_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		a0_b_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		s0_a_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		s0_b_data       <= "0000000000000000000000000000000000000000000000000000000000000000";
		z_absolute      <= z_absolute;
		z_re            <= z_re;
		z_im            <= z_im;
		zp_re           <= zp_re;
		zp_im           <= zp_im;
		z_re_s          <= z_re_s;
		z_im_s          <= z_im_s;
		z0_re           <= z0_re;
		z0_im           <= z0_im;
 
		CASE complex_state IS
			WHEN c_idle => 
				idle      <= '1';
				iteration <= 0;
			WHEN c_init => 
				l0    <= (OTHERS => '0');
				l1    <= (OTHERS => '0');
				l2    <= (OTHERS => '0');
				l3    <= (OTHERS => '0');
				l4    <= (OTHERS => '0');
				l5    <= (OTHERS => '0');
				l6    <= (OTHERS => '0');
				l7    <= (OTHERS => '0');
				l8    <= (OTHERS => '0');
				l9    <= (OTHERS => '0'); 
				z_re  <= re;
				z_im  <= im;
				z0_re <= re;
				z0_im <= im;
			WHEN c_calc0 => 
				m0_a_valid      <= '1';
				m0_b_valid      <= '1';
				m0_a_data       <= z_re;
				m0_b_data       <= z_re;
				m0_result_ready <= '1';
				m1_a_valid      <= '1';
				m1_b_valid      <= '1';
				m1_a_data       <= z_im;
				m1_b_data       <= z_im;
				m1_result_ready <= '1';
				l9              <= l8;
			WHEN c_calc1 => 
				l8 <= l7;
			WHEN c_calc2 => 
				z_re_s <= m0_result;
				z_im_s <= m1_result;
				l7     <= l6;
			WHEN c_calc3 => 
				a0_a_valid      <= '1';
				a0_b_valid      <= '1';
				a0_result_ready <= '1';
				s0_a_valid      <= '1';
				s0_b_valid      <= '1';
				s0_result_ready <= '1';
				a0_a_data       <= z_re_s;
				a0_b_data       <= z_im_s;
				s0_a_data       <= z_re_s;
				s0_b_data       <= z_im_s;
				m0_a_valid      <= '1';
				m0_b_valid      <= '1';
				m0_a_data       <= z_re;
				m0_b_data       <= "0100000000000000000000000000000000000000000000000000000000000000"; --constant 2
				m0_result_ready <= '1';
				l6              <= l5;
			WHEN c_calc4 => 
				l5 <= l4;
			WHEN c_calc5 => 
				z_absolute <= a0_result;
				zp_re      <= s0_result;
				zp_im      <= m0_result;
				l4         <= l3;
			WHEN c_calc6 => 
				m0_a_valid      <= '1';
				m0_b_valid      <= '1';
				m0_a_data       <= zp_im;
				m0_b_data       <= z_im;
				m0_result_ready <= '1';
				a0_a_valid      <= '1';
				a0_b_valid      <= '1';
				a0_a_data       <= zp_re;
				a0_b_data       <= z0_re;
				a0_result_ready <= '1';
				s0_a_valid      <= '1';
				s0_b_valid      <= '1';
				s0_a_data       <= z_absolute;
				s0_b_data       <= "0100000000010000000000000000000000000000000000000000000000000000"; --constant 4
				s0_result_ready <= '1';
				l3              <= l2;
			WHEN c_calc7 => 
				l2 <= l1;
			WHEN c_calc8 => 
				z_absolute <= s0_result;
				zp_im      <= m0_result;
				zp_re      <= a0_result;
				l1         <= l0;
			WHEN c_calc9 => 
				a0_a_valid      <= '1';
				a0_b_valid      <= '1';
				a0_a_data       <= zp_im;
				a0_b_data       <= z0_im;
				a0_result_ready <= '1';
				l0              <= zp_re;
			WHEN c_calc10 => 
			WHEN c_calc11 => 
				zp_im <= a0_result;
			WHEN c_calc12 => 
				z_re <= zp_re;
				z_im <= zp_im;
			WHEN c_iterate => 
				IF (iteration < 1000) THEN
					iteration <= iteration + 1;
				END IF;
			WHEN c_diverge => 
			    iteration_out <= std_logic_vector(to_unsigned(iteration, 10));
			    done          <= '1';
			WHEN c_converge => 
				done          <= '1';
				iteration_out <= "0000000000";
		END CASE;

	END PROCESS;

	transistions : PROCESS (clk, start, complex_state, received, m0_a_ready, m0_b_ready, m1_a_ready, m1_b_ready, m0_result_valid, m1_result_valid, a0_a_ready, a0_b_ready, s0_a_ready, s0_b_ready, a0_result_valid, s0_result_valid, z_absolute, iteration) IS BEGIN
		IF rising_edge(clk) THEN

			complex_state_next <= complex_state; --loop
 
			CASE complex_state IS
				WHEN c_idle => 
					IF (start = '1') THEN
						complex_state_next <= c_init;
					END IF;
				WHEN c_init => 
					complex_state_next <= c_iterate;
				WHEN c_iterate => 
					IF (iteration = 1000) THEN
						complex_state_next <= c_converge;
					ELSE
						complex_state_next <= c_calc0;
					END IF;
				WHEN c_calc0 => 
					IF (m0_a_ready = '1' AND m0_b_ready = '1' AND m1_a_ready = '1' AND m1_b_ready = '1') THEN
						complex_state_next <= c_calc1;
					END IF;
				WHEN c_calc1 => 
					IF (m0_result_valid = '1' AND m1_result_valid = '1') THEN
						complex_state_next <= c_calc2;
					END IF;
				WHEN c_calc2 => 
					complex_state_next <= c_calc3;
				WHEN c_calc3 => 
					IF (a0_a_ready = '1' AND a0_b_ready = '1' AND s0_a_ready = '1' AND s0_b_ready = '1' AND m0_a_ready = '1' AND m0_b_ready = '1') THEN
						complex_state_next <= c_calc4;
					END IF;
				WHEN c_calc4 => 
					IF (m0_result_valid = '1' AND a0_result_valid = '1' AND s0_result_valid = '1') THEN
						complex_state_next <= c_calc5;
					END IF;
				WHEN c_calc5 => 
					complex_state_next <= c_calc6;
				WHEN c_calc6 => 
					IF (m0_a_ready = '1' AND m0_b_ready = '1' AND s0_a_ready = '1' AND s0_b_ready = '1' AND a0_a_ready = '1'AND a0_b_ready = '1') THEN
						complex_state_next <= c_calc7;
					END IF;
				WHEN c_calc7 => 
					IF (m0_result_valid = '1' AND s0_result_valid = '1' AND a0_result_valid = '1') THEN
						complex_state_next <= c_calc8;
					END IF;
				WHEN c_calc8 => 
					IF (z_absolute(63) = '0') THEN
						complex_state_next      <= c_diverge;
					ELSE complex_state_next <= c_calc9;
					END IF;
				WHEN c_calc9 => 
					IF (a0_a_ready = '1'AND a0_b_ready = '1') THEN
						complex_state_next <= c_calc10;
					END IF;
				WHEN c_calc10 => 
					IF (a0_result_valid = '1') THEN
						complex_state_next <= c_calc11;
					END IF;
				WHEN c_calc11 => 
					complex_state_next <= c_calc12;
				WHEN c_calc12 => 
					IF ((zp_re = re AND zp_im = im) OR (re = l1) OR (re = l2) OR (re = l3) OR (re = l4) OR (re = l5) OR (re = l6) OR (re = l7) OR (re = l8) OR (re = l9))
				 THEN
				complex_state_next      <= c_converge;
					ELSE complex_state_next <= c_iterate;
					 END IF;
				WHEN c_diverge => 
					 IF (received = '1') THEN
							complex_state_next <= c_idle;
						END IF;
				WHEN c_converge => 
							IF (received = '1') THEN
								complex_state_next <= c_idle;
							END IF;
				END CASE;
			END IF;
		END PROCESS;
END Behavioral;
