----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 10.06.2017 13:29:26
-- Design Name: 
-- Module Name: color_module - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity color_module is
port (
    clk : in std_logic;
    reset : in std_logic;
    iteration : in natural;
    valid : in std_logic;
    color : out std_logic_vector (8 downto 0); --3bit for red, 3bit for green, 3 bit for blue
    ready : out std_logic := '0';
    done : out std_logic := '0'
);
end color_module;

architecture Behavioral of color_module is

type clr_states is (idle, black, conv, check_for_zero, calc, calc_done);
signal clr_state : clr_states := idle;
signal clr_state_next : clr_states;
signal mem : natural range 0 to 100000; --store the iteration as a natural to calc mod with it
signal modulus : natural range 0 to 511;

begin

next_state: process (clk, reset) is begin

    if (rising_edge(clk)) then
        if (reset = '0') then
            clr_state <= clr_state_next;
        else
            clr_state <= idle;
        end if;
    end if;
    
end process;

outputs: process (clk, clr_state, iteration, mem, modulus, valid) is begin

if rising_edge(clk) then


ready <= '0';
done <= '0';
color <= "000000000";

    case clr_state is
        when idle => ready <= '1';
        when conv =>
            mem <= iteration;
        when black =>
            done <= '1';
        when calc =>
            modulus <= mem mod 512;
        when check_for_zero =>
            if (modulus = 0) then
                modulus <= 1;
            end if;
        when calc_done =>
            done <= '1';
            color <= std_logic_vector(to_unsigned(modulus, 9));
    end case;
    end if;
end process;

transitions: process (valid, clk, reset, iteration, clr_state) is begin

if(rising_edge(clk)) then
clr_state_next <= clr_state;
    case clr_state is
        when idle => if (valid = '1') then
            clr_state_next <= conv;
            end if;
        when conv =>
            if (iteration = 0) then
                clr_state_next <= black;
            else clr_state_next <= calc;
            end if;
        when calc => clr_state_next <= check_for_zero;
        when check_for_zero => clr_state_next <= calc_done;
        when black =>
        when calc_done =>
    end case;
    end if;
end process;

end Behavioral;
