package de.uni_frankfurt.prgpr.phase3.images;

import java.io.Serializable;

/**
 * A pair of a dye channel and a colour gradient; intended as a specification to map the channel to the gradient
 * 
 * @author creichen
 *
 */
public class DyeSpec implements Comparable<DyeSpec>, Serializable {
	private static final long serialVersionUID = 42L;
	private DyeChannel channel;
	private Gradient gradient;

	/**
	 * Creates a new channel-to-gradient specification
	 * 
	 * @param channel The channel to map
	 * @param gradient The gradient that the channel should be mapped to
	 */
	public DyeSpec(DyeChannel channel, Gradient gradient) {
		this.channel = channel;
		this.gradient = gradient;
	}
	
	/**
	 * Retrieves the colour channel
	 * 
	 * @return The dye channel to map
	 */
	public DyeChannel getChannel() {
		return this.channel;
	}
	
	/**
	 * The colour gradient that the channel should be mapped to
	 * 
	 * @return The colour gradient
	 */
	public Gradient getGradient() {
		return this.gradient;
	}

	/**
	 * Compares this dyeSpec to another
	 * 
	 * @param other The other dyeSpec to compare this one to
	 * @return a negative number if this DyeSpec is less than, a positive number if this DyeSpec is greater than, or zero if this DyeSpec is equal to the other.
	 */
	@Override
	public int compareTo(DyeSpec other) {
		int i = other.channel.getColorIndex() - this.channel.getColorIndex();
		if (i != 0) {
			return i;
		}
		return gradient.toString().compareTo(other.gradient.toString());
	}
	
	/**
	 * Generates a hash code for this DyeSpec, for use in hashing datastructures
	 * 
	 * @return a hash code
	 */
	@Override
	public int hashCode() {
		return channel.hashCode() ^ gradient.hashCode();
	}
	
	/**
	 * Tests whether this DyeSpec is equal to another object
	 * 
	 */
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof DyeSpec) {
			DyeSpec other = (DyeSpec)obj;
			return other.channel == this.channel && other.gradient.equals(this.gradient);
		}
		return false;
	}
}