package de.uni_frankfurt.prgpr.phase3.images;

/**
 * Spritesheets can be dyed, using colours indicated by DyeChannels.  There are seven DyeChannels,
 * which each describe a set of pixels.  Recall that each pixel is made up of values (red, green, blue),
 * and optionally a fourth `alpha' value (which we ignore here).
 * 
 * The DyeChannel RED describes all pixels whose green and blue RGB values are zero.
 * The DyeChannel YELLOW describes all pixels whose lue values are zero while at the same
 * time their red and green values are equal. 
 * 
 * @author creichen
 *
 */
public enum DyeChannel {
	BLUE(false, false, true, 1),
	GREEN(false, true, false, 2),
	CYAN(false, true, true, 3),
	RED(true, false, false, 4),
	MAGENTA(true, false, true, 5),
	YELLOW(true, true, false, 6),
	WHITE(true, true, true, 7);
	
	
	boolean r, g, b; // colour must be equal for everything listed as `true', and zero for everything else
	int colorIndex;
	
	/**
	 * Constructs a new DyeChannel
	 * @param red
	 * @param green
	 * @param blue
	 */
	DyeChannel(boolean red, boolean green, boolean blue, int colorIndex) {
		this.r = red;
		this.g = green;
		this.b = blue;
		this.colorIndex = colorIndex;
	}
	
	public int getColorIndex() {
		return colorIndex;
	}
	
	public boolean hasRed() {
		return this.r;
	}
	public boolean hasGreen() {
		return this.g;
	}
	public boolean hasBlue() {
		return this.b;
	}
}
