package de.uni_frankfurt.prgpr.phase3.images;

import java.io.Serializable;

/**
 * A sequence of cel indices
 * 
 * @author creichen
 *
 */
class CelSequence implements Serializable {
	private static final long serialVersionUID = 1L;
	private int start;
	private int end;
	private int delay;
	
	private int xOffset, yOffset;

	/**
	 * Creates a new cel index sequence
	 * 
	 * @param start First cel index
	 * @param end Last cel index
	 * @param delay Delay between cel indices (in milliseconds)
	 */
	public CelSequence(int start, int end, int delay) {
		this.start = start;
		this.end = end;
		this.delay = delay;
	}
	
	/**
	 * Retrieves the horizontal offset to use for this cel sequence.
	 * 
	 * @return The horizontal offset.
	 */
	public int getXOffset() {
		return xOffset;
	}
	
	/**
	 * Retrieves the vertical offset to use for this cel sequence.
	 * 
	 * @return The vertical offset.
	 */
	public int getYOffset() {
		return yOffset;
	}
	
	/**
	 * Sets the horizontal and vertical offsets to use for this cel sequence.
	 *
	 * These offsets are used to shift cels relative to other cels that they are
	 * meant to stack together with.  For example, a hat sprite might be shifted relative to the
	 * head sprite that it is meant to cover.
	 * 
	 * @param x The horizontal offset for this cel sequence
	 * @param y The vertical offset for this cel sequence
	 * @return this
	 */
	public CelSequence setOffsets(int x, int y) {
		this.xOffset = x;
		this.yOffset = y;
		return this;
	}
	
	/**
	 * Gets the first cel index for the animation
	 * 
	 * @return The first cel index
	 */
	int getStart() {
		return this.start;
	}
	
	/**
	 * Gets the last cel index for the animation
	 * 
	 * @return The last cel index
	 */
	int getEnd() {
		return this.end;
	}
	
	/**
	 * Gets the delay between cels for this  part of the animation
	 *  
	 * @return The delay between cels (in milliseconds)
	 */
	public int getDelay() {
		return this.delay;
	}
}