package de.uni_frankfurt.prgpr.phase3.images;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;

/**
 * Animations describe sprite animations, either looped or one-time.
 * 
 * @author creichen
 *
 */
public class Animation implements Serializable {
	private static final long serialVersionUID = 1L;
	private boolean looping = false;
	private List<CelSequence> celSequence = new ArrayList<>();
	
	/**
	 * Creates a fresh and un
	 */
	public Animation() {
	}
	
	/**
	 * Determines whether the animation loops indefinitely
	 * 
	 * @return true iff the animation loops
	 */
	public boolean isLooping() {
		return this.looping;
	}
	
	/**
	 * Configures whether the animation loops
	 * 
	 * @param isLooped true iff the animation should loop
	 */
	void setIsLooping(boolean isLooped) {
		this.looping = isLooped;
	}
	
	/**
	 * Appends a sequence of cels to be drawn
	 * 
	 * Should only be called while building the animation
	 * 
	 * @param seq
	 */
	void addCelSequence(CelSequence seq) {
		this.celSequence.add(seq);
	}
			
	/**
	 * Creates a fresh animation state
	 * 
	 * @return An animation state object, initialised to the first animation cel.  This object can advance through subsequent animation steps.
	 */
	public AnimationState newState() {
		return new AnimationState(this);
	}
	
	/**
	 * Retrieves one particular cel sequence
	 * 
	 * @param i Number of the cel sequence to retrieve (must be between 0, inclusive, and getCelSequencesNr(), exclusive)
	 * @return The selected CelSequence
	 */
	public CelSequence getCelSequence(int i) {
		return this.celSequence.get(i);
	}
	
	/**
	 * Determines the number of CelSequences stored in this animation
	 */
	int getCelSequencesNr() {
		return this.celSequence.size();
	}
}
