package de.uni_frankfurt.prgpr.core;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;


/**
 * A class that sends a project update to a bppr server
 * 
 * @author creichen
 *
 */
public class UpdateClient {
	/**
	 * 
	 * @return The jar file contents for the default jar file
	 * @throws IOException
	 */
	static byte[] loadJarFile() throws IOException {
		/* added by DG: */
		 String current = new java.io.File( "." ).getCanonicalPath();
	        System.out.println("Current dir:"+current);
	     String currentDir = System.getProperty("user.dir");
	        System.out.println("Current dir using System:" +currentDir);
		System.out.println("using path: " + FileSystems.getDefault().getPath("",Config.JAR_FILENAME) + " for the jar file");
		/* END by DG */
		return Files.readAllBytes(FileSystems.getDefault().getPath("", Config.JAR_FILENAME));
	}
	
	/**
	 * Main entry point; starts up the client and prepares and sends an update message
	 * @param args
	 * @throws IOException
	 */
	public static final void main(String[] args) throws IOException {
		Message.Update message = new Message.Update();
		message.setClientMainClass(Config.CLIENT_CLASS.getName());
		message.setServerMainClass(Config.SERVER_CLASS.getName());
		message.setProject(Config.PROJECT_NAME);
		message.setVersion(Config.PROJECT_VERSION);
		message.setJarData(loadJarFile());
		Client client = new Client(Config.SERVER_NAME);
		Message reply = client.sendMessage(message);
		System.out.println(reply);
	}
}
