package de.uni_frankfurt.prgpr.core;

import java.io.Serializable;
import java.util.Set;

/**
 * Interface that the server infrastructure provides to servers.  This
 * interface permits the servers to access server-side storage and logging.
 * 
 * @author creichen
 *
 */
public interface ServerServiceInterface extends LogInterface {
	/**
	 * Stores an object on disk, by name.
	 * 
	 * @param name A name to store the object under.  The name must have no more than 128 characters and
	 * may only consist of alphanumeric characters (letters and numbers) that are suitable for file system
	 * use (including dashes and underscores).
	 * @param object The object to store under the given name
	 * @throws RuntimeException if the name is invalid
	 */
	public void storeObject(String name, Serializable object);

	/**
	 * Load an object by name.
	 *  
	 * The object must have been previously stored via `store'.
	 * 
	 * @param name
	 * @return null if there is no matching object, otherwise the serialised object
	 */
	public Serializable loadObject(String name);
	
	/**
	 * Retrieves a list of all stored objects by name.
	 * 
	 * @return A set of all previously stored objects.
	 */
	public Set<? extends String> listStoredObjects();
	
	/**
	 * Deletes an object by name
	 * 
	 * @param name Name of the name to delete
	 */
	public void deleteObject(String name);
}
