package de.uni_frankfurt.prgpr.core;

import java.io.Serializable;

/**
 * Interface to be implemented by deployable servers
 * 
 * @author creichen
 *
 */
public interface NewServerInterface {
	/**
	 * Initialises the server.  Invoked after the server has been installed.
	 * @param serviceInterface A mechanism for accessing server-side logging and storage
	 */
	public void init(ServerServiceInterface serviceInterface);
	
	/**
	 * This method is called in regular time intervals, ideally once every 25 ms.
	 * 
	 * The server limits execution time for this method and may forcefully abort it.
	 * 
	 * @param ticks The number of ticks that have elapsed since this server was started.
	 * The number may increase by more than one between calls if the system is under high load.
	 */
	public void update(int ticks);
	
	/**
	 * Notifies the server that a new client wants to connect to it. 
	 * 
	 * @param client ChannelInterface to the new client.
	 * @return true iff the server accepted the connection
	 */
	public boolean connectClient(ChannelInterface client);
	
	/**
	 * Notifies the server that it received a message.
	 * 
	 * @param client The client that we received the message from
	 * @param message The message
	 */
	public void receive(ChannelInterface client, Serializable message);
	
}
