package de.uni_frankfurt.prgpr.core;

import java.io.IOException;

import de.uni_frankfurt.prgpr.phase3.gui.UIPanel;

/**
 * Generic system for requesting and executing client codekl
 * 
 * @author creichen
 *
 */
public class ClientRunner {
	private Client communicationsClient;
	byte[] clientJar; // Client jar file, if we have one
	private String mainClassName;
	private String projectName;

	/**
	 * Constructs a new ClientRunner that connects to a particular server
	 * 
	 * @param serverName
	 *            The server to connect to
	 */
	public ClientRunner(String serverName) {
		communicationsClient = new Client(serverName);
	}

	/**
	 * Loads the client data jar files for a given project from the given server
	 * 
	 * @param projectName
	 *            Name of the project to load
	 * @return true iff the load was successful
	 */
	public boolean loadClient(String projectName) {
		try {
			this.projectName = projectName;
			Message request = new Message.GetClient();
			request.setProject(projectName);
			Message reply = communicationsClient.sendMessage(request);
			if (reply instanceof Message.Client) {
				Message.Client cd = (Message.Client) reply;
				clientJar = cd.getJarData();
				mainClassName = cd.getClientMainClass();
			}
			return true;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
	}

	/**
	 * Runs a previously loaded client
	 */
	public void run(UIPanel panel) {
		if (clientJar == null) {
			throw new RuntimeException("1No client code available to run!  Make sure to run loadClient() first.");
		}
		if (mainClassName == null) {
			throw new RuntimeException("2No client code available to run!  Make sure to run loadClient() first.");
		}

		InMemoryJarClassLoader classloader = new InMemoryJarClassLoader(this.getClass().getClassLoader(), clientJar);
		try {
			ChannelInterface serverChannel = communicationsClient.connect(classloader, projectName);
			Class<?> c = classloader.findClass(mainClassName);
			Object obj = c.newInstance();
			ClientInterface client = (ClientInterface) obj;
			client.init(panel, serverChannel);
			System.out.println("run successful");
		} catch (Throwable t) {
			t.printStackTrace();
			throw new RuntimeException(t);
		}

	}

	/**
	 * Main method, runs a client selected by name
	 * 
	 * @param args
	 */
	public static final void main(String[] args) {
		System.out.println("main has been called");

		ClientRunner cl = new ClientRunner(Config.SERVER_NAME);
		if (cl.loadClient(Config.PROJECT_NAME))
			System.out.println("client loaded successfully");
		else
			System.out.println("failed to load client");
		cl.run(new UIPanel("PRG-PR"));

		System.out.println("main done");
	}
}
