package de.uni_frankfurt.prgpr.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;


/**
 * Client implementation; a class for sending messages
 * @author creichen
 *
 */
public class Client {
	/** ADDED:  **/
	
	private String name;
	/** sets a client / player name 
	 * @param string is a name for the client/player
	 * **/
	
	public void setUnique_playername(String string){
		this.name = string;
	}

	/**
	 * getter for client/player name
	 * @return a client name as a string
	 */
	public String getUnique_playername(){
		return this.name;
	}

	/*************/
	
	
	/**
	 * Port to connect to
	 */
	private int port = Config.SERVER_PORT;

	/**
	 * Server to connect to
	 */
	private String server = null;
	/**
	 * Creates a new client that connects to the specified server
	 * @param serverName Server to connect to (IP address or DNS name)
	 */
	public Client(String serverName) {
		this.server = serverName;
	}
	
	/**
	 * Updates the server port number to connect to, from the default
	 */
	public void setPort(int port_nr) {
		this.port = port_nr;
	}
	
	/**
	 * Sends a synchronous message to the server and waits for a reply
	 * @param m The message to send
	 * @return The returned message
	 * @throws IOException If the network connection fails 
	 * @throws RuntimeException If the message didn't have all mandatory properties set 
	 */
	public Message sendMessage(Message m) throws IOException {
		m.validate();
		Message[] result = new Message[1];
		Socket sock = null;
		try {
			sock = commWithServer(null, m, result);
		} finally {
			if (sock != null) {
				sock.close();
			}
		}
		return result[0];
	}

	ObjectOutputStream ostream = null;
	ObjectInputStream istream = null;
	
	/**
	 * Communicates a message to the server
	 * @param classloader 
	 * 
	 * @param sendMessage The message to send
	 * @param receiveMessage Array into which the received message will be written
	 * @return The communications socket
	 * @throws IOException If the network connection failed
	 */
	private Socket commWithServer(InMemoryJarClassLoader classloader, Message sendMessage, Message[] receiveMessage) throws IOException {
		Socket clientSocket = new Socket(server, port);
		ostream = new ObjectOutputStream(clientSocket.getOutputStream());
		ostream.writeObject(sendMessage);
		if (classloader == null) {
			istream = new ObjectInputStream(clientSocket.getInputStream());
		} else {
			istream = new ClassLoadingObjectInputStream(classloader, clientSocket.getInputStream());
		}
		try {
			Object obj = istream.readObject();
			if (obj instanceof Message) {
				receiveMessage[0] = (Message) obj;
			} else {
				receiveMessage[0] = new Message.Error("Invalid server reply: " + obj);
			}
		} catch (ClassNotFoundException exn) {
			// We're ONLY supposed to send `Message' objects and primitive types, so this should not ever happen
			// unless someone changed the Message class or the server implementation in an incompatible way.
			throw new RuntimeException(exn);
		}
		return clientSocket;
	}

	/**
	 * Establishes a network connection for the given project
	 * 
	 * @param classloader The classloader to use to decode data sent from the server 
	 * @param projectName The project name for which to connect
	 * @return A channel interface that can be used to send to the server
	 * @throws IOException If network connection failed
	 */
	public ChannelInterface connect(InMemoryJarClassLoader classloader, String projectName) throws IOException {
		Message[] result = new Message[1];
		Socket sock = null;
		
		Message.Connect mc = new Message.Connect();
		mc.setProject(projectName);
		sock = commWithServer(classloader, mc, result);

		if (result[0] instanceof Message.OK) {
			QueuedChannel retval = new QueuedChannel(sock, istream, ostream);
			return retval;
		} else {
			System.err.println("Failed to establish connection: " + result[0] + " for class " + result[0].getClass() + " from classloader " + result[0].getClass().getClassLoader());
		}
		return null;
	}
}
