package de.uni_frankfurt.prgpr.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

/**
 * ObjectInputStream with customisable classloader abilities
 * 
 * @author creichen
 *
 */
public class ClassLoadingObjectInputStream extends ObjectInputStream {
	ClassLoader classloader;
	
	/**
	 * Constructs a ClassLoadingObjectInputStream with a custom classloader
	 * 
	 * @param classloader The initial classloader; may be null
	 * @param in The input stream to read from
	 * @throws IOException
	 */
	public ClassLoadingObjectInputStream(ClassLoader classloader, InputStream in) throws IOException {
		super(in);
		this.classloader = classloader;
	}
	
	@Override
	public Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
		if (classloader == null) {
			return super.resolveClass(desc);
		}
		return Class.forName(desc.getName(), false, classloader);
	}

	/**
	 * Updates the classloader in current use.
	 * 
	 * Note that this will only affect classes that have not been observed yet.
	 * 
	 * @param cl The new classloader to use.
	 */
	public void setClassloader(ClassLoader cl) {
		this.classloader = cl;
	}
}
